/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.parser;

import com.atlassian.dc.filestore.api.FileStore;
import com.atlassian.dc.filestore.api.compat.FilesystemPath;
import com.atlassian.dc.filestore.impl.filesystem.FilesystemFileStore;
import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.external.beans.ExternalAttachment;
import com.atlassian.jira.external.beans.ExternalProject;
import com.atlassian.jira.imports.project.parser.AttachmentParser;
import com.atlassian.jira.issue.attachment.AttachmentKey;
import com.atlassian.jira.issue.attachment.FileAttachments;
import com.atlassian.jira.util.dbc.Assertions;
import java.io.File;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class AttachmentParserImpl
implements AttachmentParser {
    private static final String ID = "id";
    private static final String ISSUE = "issue";
    private static final String FILENAME = "filename";
    private static final String CREATED = "created";
    private static final String AUTHOR = "author";
    protected final File rootImportAttachmentPath;

    public AttachmentParserImpl(String rootImportAttachmentPath) {
        this.rootImportAttachmentPath = new File(rootImportAttachmentPath);
    }

    @Override
    public ExternalAttachment parse(Map<String, String> attributes) throws ParseException {
        Assertions.notNull((String)"attributes", attributes);
        String id = attributes.get(ID);
        String issueId = attributes.get(ISSUE);
        String fileName = attributes.get(FILENAME);
        String created = attributes.get(CREATED);
        String author = attributes.get(AUTHOR);
        if (StringUtils.isEmpty((CharSequence)id)) {
            throw new ParseException("A file attachment must have an id specified.");
        }
        if (StringUtils.isEmpty((CharSequence)issueId)) {
            throw new ParseException("A file attachment with id '" + id + "' must have an issue id specified.");
        }
        if (fileName == null) {
            throw new ParseException("A file attachment with id '" + id + "' must have a file name specified.");
        }
        if (StringUtils.isEmpty((CharSequence)created)) {
            throw new ParseException("A file attachment with id '" + id + "' must have a create date specified.");
        }
        Timestamp createdDate = Timestamp.valueOf(created);
        return new ExternalAttachment(id, issueId, fileName, (Date)createdDate, author);
    }

    @Override
    public File getExternalAttachmentFile(ExternalAttachment attachment, ExternalProject project, String issueKey) {
        String projectKey = AttachmentParser.getProjectKeyInUse(project);
        String normalisedIssueKey = FileAttachments.computeIssueKeyForOriginalProjectKey(projectKey, issueKey);
        AttachmentKey attachmentKey = AttachmentKey.builder().withProjectKey(projectKey).withIssueKey(normalisedIssueKey).withAttachmentId(Long.valueOf(attachment.getId())).withAttachmentFilename(attachment.getFileName()).build();
        FilesystemPath rootAttachmentImportsPath = FilesystemFileStore.forFile((File)this.rootImportAttachmentPath);
        FilesystemPath externalFile = (FilesystemPath)FileAttachments.getAttachmentPathFromRoot(attachmentKey, (FileStore.Path)rootAttachmentImportsPath);
        return externalFile.asJavaFile();
    }
}

