/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index;

import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.issue.index.IndexDirectoryFactory;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

interface WriterWrapperEntityVersionCache {
    public static final Logger log = LoggerFactory.getLogger(WriterWrapperEntityVersionCache.class);

    public void put(String var1, long var2);

    public void clear();

    public Optional<Long> get(String var1);

    public int size();

    public CacheStats.MutableCacheStats.Result getTotal();

    public CacheStats.MutableCacheStats.Result getSnapshotAndReset();

    public static WriterWrapperEntityVersionCache create(@Nullable IndexDirectoryFactory.Name name, Runnable onClearCacheCallback) {
        if (name == null) {
            return new NoOpWriterWrapperEntityVersionCache();
        }
        return new DefaultWriterWrapperEntityVersionCache(name, onClearCacheCallback);
    }

    public static interface CacheStats {
        public void onPut();

        public void onClear();

        public void onGet(boolean var1);

        public void onClearSizeExceeded();

        public static CacheStats create() {
            return new DefaultCacheStats();
        }

        public static class DefaultCacheStats
        implements CacheStats {
            private final MutableCacheStats snapshot = new MutableCacheStats();
            private final MutableCacheStats total = new MutableCacheStats();

            @Override
            public void onPut() {
                this.snapshot.onPut();
                this.total.onPut();
            }

            @Override
            public void onGet(boolean found) {
                this.snapshot.onGet(found);
                this.total.onGet(found);
            }

            @Override
            public void onClear() {
                this.snapshot.onClear();
                this.total.onClear();
            }

            @Override
            public void onClearSizeExceeded() {
                this.snapshot.onClearSizeExceeded();
                this.total.onClearSizeExceeded();
            }
        }

        public static class MutableCacheStats
        implements CacheStats {
            private final AtomicLong put = new AtomicLong();
            private final AtomicLong get = new AtomicLong();
            private final AtomicLong getFound = new AtomicLong();
            private final AtomicLong clear = new AtomicLong();
            private final AtomicLong clearSizeExceeded = new AtomicLong();

            @Override
            public void onPut() {
                this.put.incrementAndGet();
            }

            @Override
            public void onGet(boolean found) {
                this.get.incrementAndGet();
                if (found) {
                    this.getFound.incrementAndGet();
                }
            }

            @Override
            public void onClear() {
                this.clear.incrementAndGet();
            }

            @Override
            public void onClearSizeExceeded() {
                this.clearSizeExceeded.incrementAndGet();
            }

            void reset() {
                this.put.set(0L);
                this.get.set(0L);
                this.getFound.set(0L);
                this.clear.set(0L);
                this.clearSizeExceeded.set(0L);
            }

            Result result(boolean reset) {
                Result result = new Result();
                if (reset) {
                    this.reset();
                }
                return result;
            }

            final class Result {
                final long put;
                final long get;
                final long getFound;
                final long clear;
                final long clearSizeExceeded;

                Result() {
                    this.put = MutableCacheStats.this.put.get();
                    this.get = MutableCacheStats.this.get.get();
                    this.getFound = MutableCacheStats.this.getFound.get();
                    this.clear = MutableCacheStats.this.clear.get();
                    this.clearSizeExceeded = MutableCacheStats.this.clearSizeExceeded.get();
                }
            }
        }
    }

    @NotThreadSafe
    public static class DefaultWriterWrapperEntityVersionCache
    implements WriterWrapperEntityVersionCache {
        static final String SYSTEM_PROPERTY_MAX_CACHE_SIZE = "com.atlassian.jira.index.writerWrapperEntityVersionCache.maxCacheSize";
        private final int MAX_CACHE_SIZE = JiraSystemProperties.getInstance().getInteger("com.atlassian.jira.index.writerWrapperEntityVersionCache.maxCacheSize", Integer.valueOf(50000));
        private final String logPrefix;
        private final Map<String, Long> entityVersionByIdCache = new HashMap<String, Long>();
        private final IndexDirectoryFactory.Name name;
        private final CacheStats.DefaultCacheStats cacheStats = new CacheStats.DefaultCacheStats();
        private final Runnable onClearCacheCallback;

        DefaultWriterWrapperEntityVersionCache(IndexDirectoryFactory.Name name, Runnable onClearCacheCallback) {
            this.name = name;
            this.onClearCacheCallback = onClearCacheCallback;
            this.logPrefix = "[WriterWrapperEntityVersionCache:" + name.name() + "] ";
        }

        @Override
        public void put(String entityId, long entityVersion) {
            log.trace(this.logPrefix + "put:{entityId:{}, entityVersion:{}}", (Object)entityId, (Object)entityVersion);
            if (this.entityVersionByIdCache.size() == this.MAX_CACHE_SIZE) {
                this.clearCache(true);
            }
            this.entityVersionByIdCache.put(entityId, entityVersion);
            this.cacheStats.onPut();
        }

        @Override
        public void clear() {
            this.clearCache(false);
        }

        @Override
        public Optional<Long> get(String entityId) {
            Optional<Long> versionFromCache = Optional.ofNullable(this.entityVersionByIdCache.get(entityId));
            log.trace(this.logPrefix + "get:entityId:" + entityId + " -> entityVersion:" + versionFromCache);
            this.cacheStats.onGet(versionFromCache.isPresent());
            return versionFromCache;
        }

        @Override
        public int size() {
            return this.entityVersionByIdCache.size();
        }

        @Override
        @Nullable
        public CacheStats.MutableCacheStats.Result getTotal() {
            return this.cacheStats.total.result(false);
        }

        @Override
        @Nullable
        public CacheStats.MutableCacheStats.Result getSnapshotAndReset() {
            return this.cacheStats.snapshot.result(true);
        }

        private void clearCache(boolean sizeExceeded) {
            if (sizeExceeded) {
                log.trace(this.logPrefix + "clear on size exceeded");
                this.cacheStats.onClearSizeExceeded();
            } else {
                log.trace(this.logPrefix + "clear");
                this.cacheStats.onClear();
            }
            this.entityVersionByIdCache.clear();
            this.onClearCacheCallback.run();
        }
    }

    public static class NoOpWriterWrapperEntityVersionCache
    implements WriterWrapperEntityVersionCache {
        @Override
        public void put(String entityId, long entityVersion) {
        }

        @Override
        public void clear() {
        }

        @Override
        public Optional<Long> get(String entityId) {
            return Optional.empty();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        @Nullable
        public CacheStats.MutableCacheStats.Result getTotal() {
            return null;
        }

        @Override
        @Nullable
        public CacheStats.MutableCacheStats.Result getSnapshotAndReset() {
            return null;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.METHOD})
    public static @interface Marker {
        public Operation[] operations();

        public static enum Operation {
            GET,
            PUT,
            CLEAR,
            NOOP;

        }
    }
}

