/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.ha;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventListenerRegistrar;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.config.util.FileStores;
import com.atlassian.jira.index.ha.IndexSnapshotAsyncStartResult;
import com.atlassian.jira.index.ha.IndexSnapshotCreationResult;
import com.atlassian.jira.index.ha.IndexSnapshotOperator;
import com.atlassian.jira.index.ha.IndexSnapshotOperatorStats;
import com.atlassian.jira.index.ha.IndexUtils;
import com.atlassian.jira.index.ha.TemporaryFilesProvider;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.util.stats.JiraStats;
import com.atlassian.jira.util.thread.JiraThreadLocalUtils;
import com.atlassian.plugin.event.events.PluginFrameworkShutdownEvent;
import com.google.common.base.Stopwatch;
import io.atlassian.util.concurrent.ThreadFactories;
import java.io.File;
import java.io.FilenameFilter;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.ofbiz.core.entity.DelegatorInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIndexSnapshotOperator
implements IndexSnapshotOperator {
    public static final String DEFAULT_DATE_FORMAT = "yyMMdd-HHmmss";
    private static final String INDEX_BACKUP_SEQUENCE = "IndexBackupSequence";
    private static final Logger log = LoggerFactory.getLogger(DefaultIndexSnapshotOperator.class);
    private static final long TERMINATION_TIMEOUT_SECONDS = 5L;
    private final long pollingFrequencyInSeconds;
    private final FileStores fileStores;
    private final IndexUtils indexUtils;
    private final ClusterLockService clusterLockService;
    private final JiraProperties jiraProperties;
    private final DelegatorInterface delegatorInterface;
    private final ExecutorService snapshotSingleThreadExecutor;
    private final IndexSnapshotOperatorStats stats;

    DefaultIndexSnapshotOperator(FileStores fileStores, IndexUtils indexUtils, DelegatorInterface delegatorInterface, ClusterLockService clusterLockService, @Nonnull EventListenerRegistrar eventListenerRegistrar, JiraProperties jiraProperties, long pollingFrequencyInSeconds) {
        this.fileStores = fileStores;
        this.indexUtils = indexUtils;
        this.delegatorInterface = delegatorInterface;
        this.clusterLockService = clusterLockService;
        this.jiraProperties = jiraProperties;
        this.snapshotSingleThreadExecutor = new ThreadPoolExecutor(0, 1, 0L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), ThreadFactories.namedThreadFactory((String)"index-snapshot-creation"));
        eventListenerRegistrar.register((Object)this);
        this.pollingFrequencyInSeconds = pollingFrequencyInSeconds;
        this.stats = (IndexSnapshotOperatorStats)JiraStats.create(IndexSnapshotOperatorStats.class, IndexSnapshotOperatorStats.Data::new, (boolean)false);
    }

    public DefaultIndexSnapshotOperator(FileStores fileStores, IndexUtils indexUtils, DelegatorInterface delegatorInterface, ClusterLockService clusterLockService, @Nonnull EventListenerRegistrar eventListenerRegistrar, JiraProperties jiraProperties) {
        this(fileStores, indexUtils, delegatorInterface, clusterLockService, eventListenerRegistrar, jiraProperties, 60L);
    }

    @Override
    public IndexSnapshotCreationResult forceCreateSnapshot() {
        return this.tryToCreateSnapshotWhile(null, null, () -> {
            log.info("We are forcing the snapshot creation. It will be always re-attempted.");
            return true;
        });
    }

    @Override
    public IndexSnapshotCreationResult forceCreateSnapshot(TemporaryFilesProvider temporaryFilesProvider, String notifyNode) {
        return this.tryToCreateSnapshotWhile(temporaryFilesProvider, notifyNode, () -> {
            log.info("We are forcing the snapshot creation. It will be always re-attempted.");
            return true;
        });
    }

    @Override
    public IndexSnapshotCreationResult tryCreateSnapshot() {
        return this.tryToCreateSnapshotWhile(null, null, this::isLatestSnapshotOlderThanTwoPollingPeriods);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexSnapshotCreationResult tryToCreateSnapshotWhile(TemporaryFilesProvider temporaryFilesProvider, String notifyNode, BooleanSupplier retryCondition) {
        IndexSnapshotCreationResult result = null;
        int attemptNumber = 0;
        try {
            do {
                log.info("Attempting to create snapshot, attempt number: {}", (Object)(++attemptNumber));
                result = this.performIndexSnapshotBackupAndCleanup(temporaryFilesProvider, notifyNode, this.getFutureSnapshotName());
                if (result.getStatus() != IndexSnapshotCreationResult.Status.BLOCKED) {
                    log.info("On attempt number {} snapshot creation status was {}. Finishing.", (Object)attemptNumber, (Object)result.getStatus());
                    break;
                }
                log.info("Waiting for another process to finish snapshot creation. Attempt number: {}. Cluster lock name: {}.", (Object)attemptNumber, (Object)"com.atlassian.jira.index.snapshot.in.progress.lock");
                this.waitWhileAnotherIndexSnapshotIsRunning();
            } while (retryCondition.getAsBoolean());
        }
        finally {
            this.stats.totalNumberOfCreationAttempts(attemptNumber);
            if (result != null) {
                if (result.getStatus() == IndexSnapshotCreationResult.Status.SUCCESS) {
                    this.stats.totalNumberOfSuccessfulAttempts();
                } else if (result.getStatus() == IndexSnapshotCreationResult.Status.ERROR) {
                    this.stats.totalNumberOfErrorAttempts();
                } else if (result.getStatus() == IndexSnapshotCreationResult.Status.BLOCKED) {
                    this.stats.totalNumberOfBlockedAttempts();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitWhileAnotherIndexSnapshotIsRunning() {
        Stopwatch waitingTimeStopwatch = Stopwatch.createStarted();
        int pollingAttempt = 0;
        try {
            do {
                Thread.sleep(TimeUnit.SECONDS.toMillis(this.pollingFrequencyInSeconds));
                log.info("Checking if the other index snapshot operation is still running. Polling attempt number: {}. Total waiting time: {} seconds.", (Object)(++pollingAttempt), (Object)waitingTimeStopwatch.elapsed(TimeUnit.SECONDS));
            } while (this.isIndexSnapshotRunning());
            log.info("The other index snapshot operation has finished after {}. We can now move on with our attempt to create an index snapshot.", (Object)waitingTimeStopwatch.elapsed());
        }
        catch (InterruptedException e) {
            log.warn("Interrupted while waiting for snapshot to be created");
        }
        finally {
            this.stats.totalNumberOfPollingAttempts(pollingAttempt);
            this.stats.totalWaitingTimeInSeconds(waitingTimeStopwatch.elapsed(TimeUnit.SECONDS));
        }
    }

    @Override
    public IndexSnapshotAsyncStartResult performIndexSnapshotBackupAndCleanupAsync() {
        if (this.isIndexSnapshotRunning()) {
            return IndexSnapshotAsyncStartResult.blocked();
        }
        String futureSnapshotName = this.getFutureSnapshotName();
        Runnable indexSnapshotRunnable = () -> this.performIndexSnapshotBackupAndCleanup(null, null, futureSnapshotName);
        try {
            this.snapshotSingleThreadExecutor.execute(JiraThreadLocalUtils.wrap(indexSnapshotRunnable));
        }
        catch (RejectedExecutionException e) {
            if (this.snapshotSingleThreadExecutor.isShutdown()) {
                throw e;
            }
            return IndexSnapshotAsyncStartResult.blocked();
        }
        return IndexSnapshotAsyncStartResult.startedFor(futureSnapshotName);
    }

    private IndexSnapshotCreationResult performIndexSnapshotBackupAndCleanup(TemporaryFilesProvider temporaryFilesProvider, String notifyNode, String snapshotFilename) {
        String destinationPath = this.getSnapshotDirPath().getAbsolutePath();
        try {
            return this.indexUtils.performBackupOperations(destinationPath, snapshotFilename, temporaryFilesProvider, notifyNode);
        }
        catch (IndexException | ExecutionException | TimeoutException ex) {
            log.error("Index backup failed. {}", (Object)ex.getMessage());
            return IndexSnapshotCreationResult.error();
        }
        catch (InterruptedException ex) {
            log.error("Interrupted while preparing index backup", (Throwable)ex);
            Thread.currentThread().interrupt();
            return IndexSnapshotCreationResult.error();
        }
    }

    @Override
    public List<File> listIndexSnapshotFiles() {
        File exportSnapshotsDirectory = this.getSnapshotDirPath();
        File[] exportSnapshots = exportSnapshotsDirectory.listFiles((FilenameFilter)IndexUtils.INDEX_SNAPSHOT_FILTER);
        if (exportSnapshots == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(exportSnapshots).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isIndexSnapshotRunning() {
        boolean isParallelCreationAllowed = this.jiraProperties.getBoolean("com.atlassian.jira.index.snapshot.parallel.creation.allowed");
        if (isParallelCreationAllowed) {
            log.warn("When parallel index snapshot creation is allowed we cannot reliably tell if index snapshot creation is currently running. Returning false by default");
            return false;
        }
        ClusterLock snapshotInProgressClusterLock = this.clusterLockService.getLockForName("com.atlassian.jira.index.snapshot.in.progress.lock");
        log.info("Trying to acquire {} lock to verify if index snapshot is being currently created", (Object)"com.atlassian.jira.index.snapshot.in.progress.lock");
        if (snapshotInProgressClusterLock.tryLock()) {
            try {
                boolean bl = false;
                return bl;
            }
            finally {
                snapshotInProgressClusterLock.unlock();
            }
        }
        return true;
    }

    private boolean isLatestSnapshotOlderThanTwoPollingPeriods() {
        long twoPollingPeriodsAgoTimestamp;
        boolean isLatestSnapshotOlder;
        long latestSnapshotTimestamp = this.listIndexSnapshotFiles().stream().mapToLong(File::lastModified).max().orElse(0L);
        boolean bl = isLatestSnapshotOlder = latestSnapshotTimestamp < (twoPollingPeriodsAgoTimestamp = Instant.now().minusSeconds(this.pollingFrequencyInSeconds * 2L).toEpochMilli());
        if (isLatestSnapshotOlder) {
            log.info("Snapshot not found. The newest one is from {}", (Object)Instant.ofEpochMilli(latestSnapshotTimestamp));
        } else {
            log.info("Found a snapshot created within the last {} seconds.", (Object)(this.pollingFrequencyInSeconds * 2L));
        }
        return isLatestSnapshotOlder;
    }

    @EventListener
    public void onPluginFrameworkShutdown(PluginFrameworkShutdownEvent event) {
        log.info("Shutting down DefaultIndexSnapshotOperator");
        this.snapshotSingleThreadExecutor.shutdown();
        try {
            if (!this.snapshotSingleThreadExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.snapshotSingleThreadExecutor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            log.info("Interrupted while shutting down DefaultIndexSnapshotOperator", (Throwable)e);
            this.snapshotSingleThreadExecutor.shutdownNow();
            Thread.currentThread().interrupt();
        }
        finally {
            log.info("Finished shutting down DefaultIndexSnapshotOperator");
        }
    }

    private String getFutureSnapshotName() {
        return this.indexUtils.deriveFilename(this.getSnapshotId());
    }

    private String getSnapshotId() {
        return this.delegatorInterface.getNextSeqId(INDEX_BACKUP_SEQUENCE) + "_" + new SimpleDateFormat(DEFAULT_DATE_FORMAT).format(new Date());
    }

    private File getSnapshotDirPath() {
        return this.fileStores.getIndexSnapshotsPath().asJavaFile();
    }
}

