/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.ha;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.instrumentation.AtomicCounter;
import com.atlassian.instrumentation.Counter;
import com.atlassian.instrumentation.ExternalGauge;
import com.atlassian.instrumentation.ExternalValue;
import com.atlassian.instrumentation.Instrument;
import com.atlassian.jira.bc.project.index.ProjectReindexService;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.Node;
import com.atlassian.jira.cluster.distribution.localq.LocalQConfig;
import com.atlassian.jira.index.EntityDocumentFactory;
import com.atlassian.jira.index.ManagedIndexSearcher;
import com.atlassian.jira.index.QueueingIndexPriority;
import com.atlassian.jira.index.ha.EntityWithOperation;
import com.atlassian.jira.index.ha.FailedReplicationOperation;
import com.atlassian.jira.index.ha.FailedReplicationOperationService;
import com.atlassian.jira.index.ha.IndexCopyService;
import com.atlassian.jira.index.ha.NodeIndexCounterStore;
import com.atlassian.jira.index.ha.NodeReindexService;
import com.atlassian.jira.index.ha.OfBizReplicatedIndexOperationStore;
import com.atlassian.jira.index.ha.ReIndexStatsLogger;
import com.atlassian.jira.index.ha.ReplicatedIndexOperation;
import com.atlassian.jira.index.ha.ReplicationStats;
import com.atlassian.jira.index.ha.SharedEntityResolver;
import com.atlassian.jira.index.ha.VersionedReplicatedIndexOperation;
import com.atlassian.jira.index.request.AffectedIndex;
import com.atlassian.jira.instrumentation.Instrumentation;
import com.atlassian.jira.instrumentation.InstrumentationName;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.index.IndexDirectoryFactory;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IndexingTimers;
import com.atlassian.jira.issue.index.InternalIndexingService;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.index.IssueIndexingParams;
import com.atlassian.jira.issue.index.IssueIndexingService;
import com.atlassian.jira.issue.index.ThreadLocalSearcherCache;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.issue.worklog.WorklogManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.sharing.index.SharedEntityIndexer;
import com.atlassian.jira.task.AlreadyExecutingException;
import com.atlassian.jira.task.context.Contexts;
import com.atlassian.jira.util.RuntimeIOException;
import com.atlassian.jira.util.concurrent.ScheduledExecutorServiceUtils;
import com.atlassian.jira.util.index.IndexLifecycleManager;
import com.atlassian.jira.util.thread.JiraThreadLocalUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.Gson;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.concurrent.GuardedBy;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultNodeReindexService
implements NodeReindexService {
    private static final Logger log = LoggerFactory.getLogger(DefaultNodeReindexService.class);
    public static final String PREFIX = "[INDEX-REPLAY] ";
    final ReplicationStats replicationStats;
    private final ReIndexStatsLogger statsLogger;
    private final ClusterManager clusterManager;
    private final NodeIndexCounterStore nodeIndexCounterStore;
    private final OfBizReplicatedIndexOperationStore ofBizNodeIndexOperationStore;
    private final IssueIndexManager indexManager;
    private final SharedEntityIndexer sharedEntityIndexer;
    final ProjectManager projectManager;
    private final ProjectReindexService projectReindexService;
    final IssueManager issueManager;
    final CommentManager commentManager;
    final WorklogManager worklogManager;
    private final SharedEntityResolver sharedEntityResolver;
    private final IndexCopyService indexCopyService;
    final IssueIndexingService indexingService;
    final InternalIndexingService internalIndexingService;
    private final IndexLifecycleManager indexLifecycleManager;
    private final FailedReplicationOperationService.FailedReplicationOperationContext failedReplicationOperationContext;
    private final Runnable indexer = JiraThreadLocalUtils.wrap(this::reIndex);
    private final ScheduledExecutorService scheduler;
    private final LatestGaugeValue latestGaugeValue = new LatestGaugeValue();
    private final Counter totalOperationCountInstrument;
    private final int delayInSeconds;
    private static final int INITIAL_DELAY_SEC = 10;
    @VisibleForTesting
    public static final int PERIOD_SEC = 5;
    private final AtomicBoolean isPaused = new AtomicBoolean(true);
    private final AtomicReference<StackCollector> lastPausedStacktrace = new AtomicReference();
    private final AtomicInteger notRunningCounter = new AtomicInteger(0);
    private static final int NOT_RUNNING_LOG_FREQUENCY = 12;
    @GuardedBy(value="this")
    private boolean scheduled = false;

    public DefaultNodeReindexService(ClusterManager clusterManager, NodeIndexCounterStore nodeIndexCounterStore, OfBizReplicatedIndexOperationStore ofBizNodeIndexOperationStore, IssueIndexManager indexManager, SharedEntityIndexer sharedEntityIndexer, ProjectManager projectManager, ProjectReindexService projectReindexService, IssueManager issueManager, CommentManager commentManager, WorklogManager worklogManager, SharedEntityResolver sharedEntityResolver, IndexCopyService indexCopyService, IssueIndexingService indexingService, InternalIndexingService internalIndexingService, IndexLifecycleManager indexLifecycleManager, FailedReplicationOperationService failedReplicationOperationService, EventPublisher eventPublisher) {
        this.statsLogger = new ReIndexStatsLogger(clusterManager.getNodeId());
        this.clusterManager = clusterManager;
        this.nodeIndexCounterStore = nodeIndexCounterStore;
        this.ofBizNodeIndexOperationStore = ofBizNodeIndexOperationStore;
        this.indexManager = indexManager;
        this.sharedEntityIndexer = sharedEntityIndexer;
        this.projectManager = projectManager;
        this.projectReindexService = projectReindexService;
        this.issueManager = issueManager;
        this.commentManager = commentManager;
        this.worklogManager = worklogManager;
        this.sharedEntityResolver = sharedEntityResolver;
        this.indexCopyService = indexCopyService;
        this.indexingService = indexingService;
        this.internalIndexingService = internalIndexingService;
        this.indexLifecycleManager = indexLifecycleManager;
        this.failedReplicationOperationContext = failedReplicationOperationService.getContext();
        this.delayInSeconds = (int)TimeUnit.MILLISECONDS.toSeconds(LocalQConfig.putTTLMillis());
        this.replicationStats = new ReplicationStats(eventPublisher);
        this.scheduler = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("NodeReindexServiceThread:thread-%d").build());
        this.totalOperationCountInstrument = new AtomicCounter(InstrumentationName.CLUSTER_REPLICATED_INDEX_OPERATIONS_TOTAL.getInstrumentName());
        ExternalGauge operationCountInstrument = new ExternalGauge(InstrumentationName.CLUSTER_REPLICATED_INDEX_OPERATIONS_LATEST.getInstrumentName(), (ExternalValue)this.latestGaugeValue);
        Instrumentation.putInstrument((Instrument)this.totalOperationCountInstrument);
        Instrumentation.putInstrument((Instrument)operationCountInstrument);
    }

    private synchronized void schedulePeriodicTaskIfNotRunning() {
        if (!this.scheduled) {
            ScheduledExecutorServiceUtils.scheduleWithVariableDelay(this.scheduler, this.indexer, Duration.ofSeconds(10L), Duration.ofSeconds(5L));
            log.info("[INDEX-REPLAY] Created node re-index service, paused={}, running period={}sec, delay={}sec", new Object[]{this.isPaused.get(), 5, this.delayInSeconds});
            this.scheduled = true;
        }
    }

    @Override
    public void shutDown() {
        this.pause();
        log.info("[INDEX-REPLAY] Shutting down replication thread", (Throwable)new StackCollector());
        this.scheduler.shutdownNow();
        try {
            this.scheduler.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void notShutDown() {
        Preconditions.checkState((!this.scheduler.isShutdown() ? 1 : 0) != 0, (Object)"Service is shut down.");
    }

    @Override
    public synchronized void start() {
        this.notShutDown();
        this.schedulePeriodicTaskIfNotRunning();
        if (this.clusterManager.isClustered()) {
            this.lastPausedStacktrace.set(null);
            if (!this.isPaused.compareAndSet(true, false) && log.isDebugEnabled()) {
                log.debug("[INDEX-REPLAY] Start called on NodeReindexService when already running", (Throwable)new StackCollector());
            }
            log.info("[INDEX-REPLAY] Starting node re-index service, paused={}, running period={}sec, delay={}sec", new Object[]{this.isPaused.get(), 5, this.delayInSeconds});
        } else {
            log.warn("[INDEX-REPLAY] Requested to start node re-index service but this is not a clustered node.");
        }
    }

    @Override
    public synchronized void pause() {
        this.notShutDown();
        this.schedulePeriodicTaskIfNotRunning();
        StackCollector currentStack = new StackCollector();
        log.info("[INDEX-REPLAY] Pausing node re-index service", (Throwable)currentStack);
        this.isPaused.set(true);
        this.lastPausedStacktrace.set(currentStack);
    }

    @Override
    public boolean isPaused() {
        return this.isPaused.get();
    }

    @Override
    public void resetIndexCount() {
        for (Node node : this.clusterManager.getAllNodes()) {
            Long lastId = this.ofBizNodeIndexOperationStore.getLatestOperation(node.getNodeId());
            if (lastId == null) continue;
            this.nodeIndexCounterStore.storeHighestIdForNode(node.getNodeId(), lastId);
        }
    }

    @Override
    public boolean canIndexBeRebuilt() {
        String currentNodeId = this.getCurrentNodeId();
        for (Node node : this.clusterManager.getAllNodes()) {
            Long latestOperation;
            long lastIndexed;
            String nodeId = node.getNodeId();
            if (!node.isClustered() || nodeId == null || nodeId.equals(currentNodeId) || this.ofBizNodeIndexOperationStore.contains(lastIndexed = this.getCurrentIndexCount(nodeId)) || (latestOperation = this.ofBizNodeIndexOperationStore.getLatestOperation(nodeId)) == null) continue;
            return false;
        }
        return true;
    }

    boolean handleIsReindexEnabled() {
        Preconditions.checkState((boolean)this.clusterManager.isClustered(), (Object)(DefaultNodeReindexService.class.getSimpleName() + " running in non-clustered mode."));
        if (this.isPaused.get()) {
            boolean shouldLogInfo = this.notRunningCounter.get() % 12 == 0 && !this.isForegroundIndexing();
            boolean shouldLogTrace = log.isTraceEnabled();
            if (shouldLogInfo || shouldLogTrace) {
                String msg = String.format("[INDEX-REPLAY] Node re-index service is not running: currentNode.isClustered=%b, notRunningCounter=%d, paused=%b, lastPausedStacktrace=%s", this.clusterManager.isClustered(), this.notRunningCounter.get(), this.isPaused.get(), this.lastPausedStacktrace.get() != null ? Throwables.getStackTraceAsString((Throwable)this.lastPausedStacktrace.get()) : "n/a");
                if (shouldLogInfo) {
                    log.info(msg);
                } else if (shouldLogTrace) {
                    log.trace(msg);
                }
            }
            this.notRunningCounter.incrementAndGet();
            return false;
        }
        this.notRunningCounter.set(0);
        return true;
    }

    private boolean isForegroundIndexing() {
        return !this.indexLifecycleManager.isIndexAvailable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reIndex() {
        if (!this.handleIsReindexEnabled()) {
            return;
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        String currentNodeId = this.getCurrentNodeId();
        log.debug("[INDEX-REPLAY] Starting reIndex for the node, nodeId={}", (Object)currentNodeId);
        if (currentNodeId == null) {
            log.debug("[INDEX-REPLAY] Finished reIndex for the node as nodeId=null, took={}.", (Object)stopwatch);
            return;
        }
        boolean error = false;
        long numberOfOperations = 0L;
        long numberOfLocalOperations = 0L;
        try {
            Set<ReplicatedIndexOperation> allIndexOps = this.getAllUnprocessedReplicatedIndexOperations();
            numberOfLocalOperations = allIndexOps.stream().filter(replicatedIndexOperation -> replicatedIndexOperation.getNodeId().equals(currentNodeId)).count();
            numberOfOperations = (long)allIndexOps.size() - numberOfLocalOperations;
            QueueingIndexPriority.runWithIndexingPriority(() -> this.applyIndexOperations(allIndexOps), -1000);
            this.totalOperationCountInstrument.addAndGet((long)allIndexOps.size());
            this.latestGaugeValue.setValue(allIndexOps.size());
            this.retryPreviouslyFailedOperations();
        }
        catch (Throwable e) {
            log.error("[INDEX-REPLAY] Error re-indexing node changes", e);
            error = true;
        }
        finally {
            log.debug("[INDEX-REPLAY] Finished reIndex for the node, nodeId={}, took={}.", (Object)currentNodeId, (Object)stopwatch);
        }
        stopwatch.stop();
        this.statsLogger.reIndex(numberOfOperations, numberOfLocalOperations, stopwatch.elapsed(TimeUnit.MILLISECONDS), error);
        this.statsLogger.logNotTooOften();
    }

    @Override
    public boolean hasPendingReindexOperations() {
        Set pendingReindexOperations = this.clusterManager.getAllNodes().stream().filter(Node::isClustered).map(Node::getNodeId).filter(Objects::nonNull).filter(sendingNodeId -> !sendingNodeId.equals(this.getCurrentNodeId())).map(this::getPendingReindexOperations).flatMap(Collection::stream).collect(Collectors.toSet());
        log.debug("Pending reindex operations: {}", pendingReindexOperations);
        return !pendingReindexOperations.isEmpty();
    }

    private Set<ReplicatedIndexOperation> getPendingReindexOperations(String sendingNodeId) {
        return this.ofBizNodeIndexOperationStore.getUnprocessedReindexOperationsAfterId(sendingNodeId, this.getCurrentIndexCount(sendingNodeId));
    }

    Set<ReplicatedIndexOperation> getAllUnprocessedReplicatedIndexOperations() {
        String currentNodeId = this.getCurrentNodeId();
        HashSet allIndexOps = Sets.newHashSet();
        Set<Node> allNodes = this.clusterManager.getAllNodes();
        for (Node sourceNodeId : allNodes) {
            Set<ReplicatedIndexOperation> indexOps = this.ofBizNodeIndexOperationStore.getIndexOperationsAfterIdAndOlderThan(sourceNodeId.getNodeId(), this.getCurrentIndexCount(sourceNodeId.getNodeId()), this.delayInSeconds);
            allIndexOps.addAll(indexOps);
            log.debug("[INDEX-REPLAY] Index operations stats: operationsCount={}, sourceNodeId={}, nodeId={}", new Object[]{allIndexOps.size(), sourceNodeId.getNodeId(), currentNodeId});
        }
        return allIndexOps;
    }

    private void applyIndexOperations(Set<ReplicatedIndexOperation> indexOperations) {
        if (!indexOperations.isEmpty()) {
            log.debug("[INDEX-REPLAY] Applying index operations: current node={}, numberOfIndexOperations={}", (Object)this.getCurrentNodeId(), (Object)indexOperations.size());
            log.trace("[INDEX-REPLAY] Applying index operations: operations={}", indexOperations);
            try {
                this.updateAffectedIndexes(indexOperations);
            }
            catch (Exception e) {
                this.failedReplicationOperationContext.addOperation(indexOperations);
                throw new RuntimeException("Failed to update index for (" + indexOperations + ")", e);
            }
            finally {
                this.updateIndexCount(indexOperations);
            }
        }
    }

    private void retryPreviouslyFailedOperations() {
        for (FailedReplicationOperation operation : this.failedReplicationOperationContext.getOperationsToRetry()) {
            log.info("[INDEX-REPLAY] Retrying indexing of {}", (Object)operation);
            try {
                this.updateAffectedIndexes(operation.getOperations());
                log.info("[INDEX-REPLAY] Successfully retried indexing of {}", (Object)operation);
            }
            catch (Exception e) {
                log.error(String.format("[INDEX-REPLAY] Failed re-attempting to replicate index operations for (%s)", operation), (Throwable)e);
                this.failedReplicationOperationContext.addOperation(operation);
            }
        }
    }

    private void updateIndexCount(Set<ReplicatedIndexOperation> indexOps) {
        Map<String, Long> highestNodeCounts = DefaultNodeReindexService.getHighestNodeCounts(indexOps);
        for (Map.Entry<String, Long> countEntry : highestNodeCounts.entrySet()) {
            this.nodeIndexCounterStore.storeHighestIdForNode(countEntry.getKey(), countEntry.getValue());
        }
    }

    private String getCurrentNodeId() {
        return this.clusterManager.getNodeId();
    }

    private long getCurrentIndexCount(String sendingNodeId) {
        return this.nodeIndexCounterStore.getIndexOperationCounterForNodeId(sendingNodeId);
    }

    private boolean handleFullReindexOperation(Set<ReplicatedIndexOperation> indexOps) {
        ReplicatedIndexOperation latestReindex = null;
        for (ReplicatedIndexOperation indexOp : indexOps) {
            if (indexOp.getNodeId().equals(this.clusterManager.getNodeId())) continue;
            log.trace("[INDEX-REPLAY] Index operation to replay={},  operation.reindexEnd={}, entityType={}, indexTime={}", new Object[]{indexOp.getOperation(), indexOp.getOperation().isReindexEnd(), indexOp.getEntityType(), indexOp.getIndexTime()});
            if (!indexOp.getOperation().isReindexEnd() || latestReindex != null && indexOp.getIndexTime().getTime() <= latestReindex.getIndexTime().getTime()) continue;
            latestReindex = indexOp;
        }
        if (latestReindex != null) {
            log.info("[INDEX-REPLAY] Re-index after last sync detected: operationName={}, sourceNodeId={}, indexTime={}. Resetting index count and restoring index from backupFilename='{}'", new Object[]{latestReindex.getOperation(), latestReindex.getNodeId(), latestReindex.getIndexTime(), latestReindex.getBackupFilename()});
            this.resetIndexCount();
            this.indexCopyService.restoreIndex(latestReindex.getBackupFilename());
            return true;
        }
        return false;
    }

    private static void logErrorIfUnsupportedAffectedIndex(Map<AffectedIndex, Set<ReplicatedIndexOperation>> partitionedOperations, AffectedIndex affectedIndex) {
        if (partitionedOperations.get(affectedIndex) != null && !partitionedOperations.get(affectedIndex).isEmpty()) {
            log.error("[INDEX-REPLAY] Operations with affected index: {}. Those operations are not allowed and will be ignored: {}", (Object)affectedIndex, partitionedOperations.get(affectedIndex));
        }
    }

    Set<ReplicatedIndexOperation> filterOutLocalNonVersionedOperations(Set<ReplicatedIndexOperation> replicatedIndexOperations) {
        String currentNodeId = this.clusterManager.getNodeId();
        return replicatedIndexOperations.stream().filter(o -> {
            if (currentNodeId == null || !currentNodeId.equals(o.getNodeId())) {
                return true;
            }
            Optional<IndexDirectoryFactory.Name> maybeIndexName = IndexDirectoryFactory.Name.fromSafe(o.getAffectedIndex());
            return maybeIndexName.map(indexName -> VersionedReplicatedIndexOperation.isReplicatedIndexOperationVersioned(o.getOperation(), indexName)).orElse(false);
        }).collect(Collectors.toSet());
    }

    void updateAffectedIndexes(Set<ReplicatedIndexOperation> indexOps) throws IndexException {
        if (this.handleFullReindexOperation(indexOps = this.filterOutLocalNonVersionedOperations(indexOps))) {
            return;
        }
        Map<AffectedIndex, Set<ReplicatedIndexOperation>> partitionedOperations = this.partition(indexOps);
        log.debug("[INDEX-REPLAY] Start updating indexes with new index operations: total={}, issueSize={}, commentSize={}, sharedEntitySize={}, worklogSize={}", new Object[]{partitionedOperations.size(), partitionedOperations.get(AffectedIndex.ISSUE).size(), partitionedOperations.get(AffectedIndex.COMMENT).size(), partitionedOperations.get(AffectedIndex.SHAREDENTITY).size(), partitionedOperations.get(AffectedIndex.WORKLOG).size()});
        DefaultNodeReindexService.logErrorIfUnsupportedAffectedIndex(partitionedOperations, AffectedIndex.CHANGEHISTORY);
        log.trace("[INDEX-REPLAY] Clearing cached index searchers before #filterOutAlreadyIndexed");
        ThreadLocalSearcherCache.internalCloseSearchers();
        Stopwatch stopwatch = Stopwatch.createStarted();
        this.processIssueIndexingOperations(partitionedOperations.get(AffectedIndex.ISSUE));
        this.processCommentIndexingOperations(partitionedOperations.get(AffectedIndex.COMMENT));
        this.processWorklogIndexingOperations(partitionedOperations.get(AffectedIndex.WORKLOG));
        this.updateSharedEntityIndex(partitionedOperations.get(AffectedIndex.SHAREDENTITY));
        log.debug("[INDEX-REPLAY] Done processing batch with: {} operations took: {}", (Object)indexOps.size(), (Object)stopwatch.stop().elapsed());
    }

    void processIssueIndexingOperations(Set<ReplicatedIndexOperation> issueIndexingOps) throws IndexException {
        IndexDirectoryFactory.Name indexName = IndexDirectoryFactory.Name.ISSUE;
        this.updateIssueIndex(this.filterOutAlreadyIndexed(indexName, this.compact(indexName, issueIndexingOps)));
    }

    void processCommentIndexingOperations(Set<ReplicatedIndexOperation> commentIndexingOps) throws IndexException {
        IndexDirectoryFactory.Name indexName = IndexDirectoryFactory.Name.COMMENT;
        this.updateCommentsIndex(this.filterOutAlreadyIndexed(indexName, this.compact(indexName, commentIndexingOps)));
    }

    void processWorklogIndexingOperations(Set<ReplicatedIndexOperation> worklogIndexingOps) throws IndexException {
        IndexDirectoryFactory.Name indexName = IndexDirectoryFactory.Name.WORKLOG;
        this.updateWorklogsIndex(this.filterOutAlreadyIndexed(indexName, this.compact(indexName, worklogIndexingOps)));
    }

    List<EntityWithOperation> compact(IndexDirectoryFactory.Name indexName, Set<ReplicatedIndexOperation> indexOps) throws IllegalStateException {
        DefaultNodeReindexService.preconditionCheckStateAllReplicatedIndexOperationOnSameIndex(indexName, (List<ReplicatedIndexOperation>)ImmutableList.copyOf(indexOps));
        Stopwatch stopwatch = Stopwatch.createStarted();
        HashMap<Long, EntityWithOperation> entityWithVersionOperationByEntityId = new HashMap<Long, EntityWithOperation>();
        HashSet<EntityWithOperation> unVersionedOperations = new HashSet<EntityWithOperation>();
        AtomicInteger versionedCounter = new AtomicInteger(0);
        AtomicInteger unVersionedCounter = new AtomicInteger(0);
        for (ReplicatedIndexOperation operation : indexOps) {
            for (Map.Entry<Long, Long> entityIdToVersion : operation.getAffectedIdToVersion().entrySet()) {
                Long version = entityIdToVersion.getValue();
                if (EntityDocumentFactory.ENTITY_VERSION_ZERO.equals(version)) {
                    unVersionedCounter.incrementAndGet();
                    if (VersionedReplicatedIndexOperation.isReplicatedIndexOperationVersioned(operation.getOperation(), indexName)) {
                        if (indexName == IndexDirectoryFactory.Name.ISSUE) {
                            log.warn("[INDEX-REPLAY] Unexpected ISSUE un-versioned operation added for processing: {}", (Object)operation);
                        } else {
                            log.debug("[INDEX-REPLAY] Un-versioned COMMENT/WORKLOG operation added for processing: {}. ", (Object)operation);
                        }
                    } else {
                        log.trace("[INDEX-REPLAY] Un-versioned operation added for processing: {}", (Object)operation);
                    }
                    unVersionedOperations.add(EntityWithOperation.createForVersionZero(indexName, entityIdToVersion.getKey(), operation.getOperation(), operation.getIndexTime()));
                    continue;
                }
                versionedCounter.incrementAndGet();
                log.trace("[INDEX-REPLAY] Versioned operation added for processing: {}", (Object)operation);
                entityWithVersionOperationByEntityId.computeIfAbsent(entityIdToVersion.getKey(), entityId -> EntityWithOperation.create(indexName, entityId)).maybeSetOperationAndVersion(operation.getOperation(), operation.getIndexTime(), version);
            }
        }
        List<EntityWithOperation> result = Stream.concat(unVersionedOperations.stream(), entityWithVersionOperationByEntityId.values().stream()).collect(Collectors.toList());
        this.statsLogger.compact(indexName, stopwatch.elapsed(TimeUnit.MILLISECONDS), indexOps.size(), result.size(), versionedCounter.get(), unVersionedCounter.get());
        return result;
    }

    ManagedIndexSearcher getManagedIndexSearcher(IndexDirectoryFactory.Name name) {
        switch (name) {
            case ISSUE: {
                return this.indexManager.getIssueSearcher();
            }
            case COMMENT: {
                return this.indexManager.getCommentSearcher();
            }
            case WORKLOG: {
                return this.indexManager.getWorklogSearcher();
            }
            case CHANGE_HISTORY: {
                return this.indexManager.getChangeHistorySearcher();
            }
        }
        throw new IllegalStateException("Unhandled indexer: " + (Object)((Object)name));
    }

    List<EntityWithOperation> filterOutAlreadyIndexed(IndexDirectoryFactory.Name indexName, List<EntityWithOperation> entitiesWithOperations) throws RuntimeIOException {
        DefaultNodeReindexService.preconditionCheckStateAllEntityWithOperationOnSameIndex(indexName, entitiesWithOperations);
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            if (entitiesWithOperations.isEmpty()) {
                return ImmutableList.of();
            }
            ArrayList<EntityWithOperation> operationsNotInIndex = new ArrayList<EntityWithOperation>();
            ManagedIndexSearcher managedIndexSearcher = this.getManagedIndexSearcher(indexName);
            for (EntityWithOperation entityWithOperation : entitiesWithOperations) {
                if (EntityDocumentFactory.ENTITY_VERSION_ZERO.equals(entityWithOperation.getVersion()) || !VersionedReplicatedIndexOperation.isReplicatedIndexOperationVersioned(entityWithOperation.getOperation(), indexName)) {
                    log.trace("[INDEX-REPLAY] Not skipping replaying operation with no version: {}", (Object)entityWithOperation);
                    operationsNotInIndex.add(entityWithOperation);
                    continue;
                }
                Term identifyingTerm = new Term(indexName.getEntityIdFieldName(), String.valueOf(entityWithOperation.getId()));
                TopDocs topDocs = managedIndexSearcher.search((Query)new TermQuery(identifyingTerm), 1);
                if (topDocs.scoreDocs.length > 0) {
                    Document documentWithVersion = managedIndexSearcher.doc(topDocs.scoreDocs[0].doc, (Set)ImmutableSet.of((Object)indexName.getEntityVersionFieldName()));
                    Long versionFromIndex = Optional.ofNullable(documentWithVersion.getField(indexName.getEntityVersionFieldName())).map(indexableField -> indexableField.numericValue().longValue()).orElse(null);
                    if (versionFromIndex != null && entityWithOperation.getVersion() != null && versionFromIndex >= entityWithOperation.getVersion()) {
                        log.trace("[INDEX-REPLAY]  Skip replaying operation with version: {}, entity found in index already with version: {}", (Object)entityWithOperation, (Object)versionFromIndex);
                        continue;
                    }
                    log.trace("[INDEX-REPLAY]  Not skipping replaying operation with version: {}, entity found in index with version: {}", (Object)entityWithOperation, (Object)versionFromIndex);
                } else {
                    log.trace("[INDEX-REPLAY]  Not skipping replaying operation with version: {}, entity not found in index", (Object)entityWithOperation);
                }
                operationsNotInIndex.add(entityWithOperation);
            }
            this.statsLogger.filterOutAlreadyIndexed(indexName, stopwatch.elapsed(TimeUnit.MILLISECONDS), entitiesWithOperations.size(), operationsNotInIndex.size());
            return operationsNotInIndex;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private static List<EntityWithOperation> sortOperations(List<EntityWithOperation> operations) {
        return operations.stream().sorted(EntityWithOperation.indexTimeBasedComparator()).collect(Collectors.toList());
    }

    private void updateSharedEntityIndex(Set<ReplicatedIndexOperation> indexOps) {
        HashSet entitiesToIndex = Sets.newHashSet();
        HashSet entitiesToDelete = Sets.newHashSet();
        for (ReplicatedIndexOperation operation : indexOps) {
            ReplicatedIndexOperation.Operation action = operation.getOperation();
            switch (action) {
                case UPDATE: 
                case CREATE: {
                    entitiesToIndex.addAll(this.sharedEntityResolver.getSharedEntities(operation.getEntityType(), operation.getAffectedIds()));
                    break;
                }
                case DELETE: {
                    entitiesToDelete.addAll(this.sharedEntityResolver.getDummySharedEntities(operation.getEntityType(), operation.getAffectedIds()));
                }
            }
        }
        long startTime = System.currentTimeMillis();
        if (!entitiesToIndex.isEmpty()) {
            this.sharedEntityIndexer.index(entitiesToIndex, false).await();
        }
        if (!entitiesToDelete.isEmpty()) {
            this.sharedEntityIndexer.deIndex(entitiesToDelete, false).await();
        }
        long endTime = System.currentTimeMillis();
        indexOps.forEach(op -> this.recordStats(ReplicationStats.Index.SHAREDENTITY, endTime, startTime, op.getIndexTime().getTime()));
    }

    static List<List<EntityWithOperation>> breakEntityWithOperationsSequenceByOperation(IndexDirectoryFactory.Name indexName, List<EntityWithOperation> entitiesWithOperations) {
        DefaultNodeReindexService.preconditionCheckStateAllEntityWithOperationOnSameIndex(indexName, entitiesWithOperations);
        if (entitiesWithOperations.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<List<EntityWithOperation>> result = new ArrayList<List<EntityWithOperation>>();
        ArrayList<EntityWithOperation> currentBatchOfSameOperations = new ArrayList<EntityWithOperation>();
        result.add(currentBatchOfSameOperations);
        EntityWithOperation lastEntityWithOperation = entitiesWithOperations.get(0);
        currentBatchOfSameOperations.add(lastEntityWithOperation);
        Comparator operationComparator = (op1, op2) -> {
            if (ReplicatedIndexOperation.Operation.CREATE.equals(op1) || ReplicatedIndexOperation.Operation.UPDATE_WITH_RELATED.equals(op1)) {
                op1 = ReplicatedIndexOperation.Operation.UPDATE;
            }
            if (ReplicatedIndexOperation.Operation.CREATE.equals(op2) || ReplicatedIndexOperation.Operation.UPDATE_WITH_RELATED.equals(op2)) {
                op2 = ReplicatedIndexOperation.Operation.UPDATE;
            }
            return op1.compareTo(op2);
        };
        for (int i = 1; i < entitiesWithOperations.size(); ++i) {
            EntityWithOperation currentEntityWithOperation = entitiesWithOperations.get(i);
            if (operationComparator.compare(currentEntityWithOperation.getOperation(), lastEntityWithOperation.getOperation()) != 0) {
                currentBatchOfSameOperations = new ArrayList();
                result.add(currentBatchOfSameOperations);
            }
            currentBatchOfSameOperations.add(currentEntityWithOperation);
            lastEntityWithOperation = currentEntityWithOperation;
        }
        log.trace("[INDEX-REPLAY] breaking: {} entities with operations to: {} batches of same operations", (Object)entitiesWithOperations.size(), (Object)result.size());
        return result;
    }

    /*
     * Unable to fully structure code
     */
    void updateIssueIndex(List<EntityWithOperation> entitiesWithOperations) throws IndexException {
        DefaultNodeReindexService.preconditionCheckStateAllEntityWithOperationOnSameIndex(IndexDirectoryFactory.Name.ISSUE, entitiesWithOperations);
        if (entitiesWithOperations.isEmpty()) {
            return;
        }
        stopwatch = Stopwatch.createStarted();
        batchCounter = new AtomicInteger();
        block40: for (List<EntityWithOperation> entitiesWithOperationSequence : DefaultNodeReindexService.breakEntityWithOperationsSequenceByOperation(IndexDirectoryFactory.Name.ISSUE, DefaultNodeReindexService.sortOperations(entitiesWithOperations))) {
            if (entitiesWithOperationSequence.isEmpty()) continue;
            batchCounter.incrementAndGet();
            firstEntityWithOperationInSequence = entitiesWithOperationSequence.get(0);
            switch (1.$SwitchMap$com$atlassian$jira$index$ha$ReplicatedIndexOperation$Operation[firstEntityWithOperationInSequence.getOperation().ordinal()]) {
                case 1: 
                case 2: 
                case 4: {
                    ignored = this.timer(entitiesWithOperationSequence);
                    var8_8 = null;
                    this.handleUpdateWithRelatedIssuesWithoutVersion(entitiesWithOperationSequence);
                    issueToUpdate = this.issueManager.getIssueObjects((Collection)entitiesWithOperationSequence.stream().map((Function<EntityWithOperation, Long>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getId(), (Lcom/atlassian/jira/index/ha/EntityWithOperation;)Ljava/lang/Long;)()).collect(Collectors.toList()));
                    this.indexingService.reIndexIssueObjects((Collection)issueToUpdate, IssueIndexingParams.builder().withChangeHistory().build(), false);
                    if (ignored == null) continue block40;
                    if (var8_8 == null) ** GOTO lbl28
                    try {
                        ignored.close();
                    }
                    catch (Throwable issueToUpdate) {
                        var8_8.addSuppressed(issueToUpdate);
                    }
                    break;
lbl28:
                    // 1 sources

                    ignored.close();
                    break;
                    catch (Throwable issueToUpdate) {
                        try {
                            var8_8 = issueToUpdate;
                            throw issueToUpdate;
                        }
                        catch (Throwable var10_15) {
                            if (ignored != null) {
                                if (var8_8 != null) {
                                    try {
                                        ignored.close();
                                    }
                                    catch (Throwable var11_17) {
                                        var8_8.addSuppressed(var11_17);
                                    }
                                } else {
                                    ignored.close();
                                }
                            }
                            throw var10_15;
                        }
                    }
                }
                case 3: {
                    ignored = this.timer(entitiesWithOperationSequence);
                    var8_8 = null;
                    this.indexingService.deIndexIssueObjectsById(new HashSet<EntityWithOperation>(entitiesWithOperationSequence), false);
                    if (ignored == null) continue block40;
                    if (var8_8 == null) ** GOTO lbl58
                    try {
                        ignored.close();
                    }
                    catch (Throwable issueToUpdate) {
                        var8_8.addSuppressed(issueToUpdate);
                    }
                    break;
lbl58:
                    // 1 sources

                    ignored.close();
                    break;
                    catch (Throwable issueToUpdate) {
                        try {
                            var8_8 = issueToUpdate;
                            throw issueToUpdate;
                        }
                        catch (Throwable var12_19) {
                            if (ignored != null) {
                                if (var8_8 != null) {
                                    try {
                                        ignored.close();
                                    }
                                    catch (Throwable var13_24) {
                                        var8_8.addSuppressed(var13_24);
                                    }
                                } else {
                                    ignored.close();
                                }
                            }
                            throw var12_19;
                        }
                    }
                }
                case 5: {
                    for (EntityWithOperation entityWithOperation : entitiesWithOperationSequence) {
                        projectToUpdate = this.projectManager.getProjectObj(entityWithOperation.getId());
                        if (projectToUpdate == null) continue;
                        ignored = this.timer((List<EntityWithOperation>)ImmutableList.of((Object)entityWithOperation));
                        var11_16 = null;
                        try {
                            this.reindexProject(projectToUpdate);
                        }
                        catch (Throwable var12_21) {
                            var11_16 = var12_21;
                            throw var12_21;
                        }
                        finally {
                            if (ignored == null) continue;
                            if (var11_16 != null) {
                                try {
                                    ignored.close();
                                }
                                catch (Throwable var12_20) {
                                    var11_16.addSuppressed(var12_20);
                                }
                                continue;
                            }
                            ignored.close();
                        }
                    }
                    continue block40;
                }
                case 6: {
                    for (EntityWithOperation entityWithOperation : entitiesWithOperationSequence) {
                        projectToDelete = this.projectManager.getProjectObj(entityWithOperation.getId());
                        if (projectToDelete == null) continue;
                        ignored = this.timer((List<EntityWithOperation>)ImmutableList.of((Object)entityWithOperation));
                        var11_16 = null;
                        try {
                            this.deindexProject(projectToDelete);
                        }
                        catch (Throwable var12_23) {
                            var11_16 = var12_23;
                            throw var12_23;
                        }
                        finally {
                            if (ignored == null) continue;
                            if (var11_16 != null) {
                                try {
                                    ignored.close();
                                }
                                catch (Throwable var12_22) {
                                    var11_16.addSuppressed(var12_22);
                                }
                                continue;
                            }
                            ignored.close();
                        }
                    }
                    continue block40;
                }
                default: {
                    DefaultNodeReindexService.log.error("[INDEX-REPLAY] Unsupported operation for issue index: {}, {}", (Object)firstEntityWithOperationInSequence.getOperation(), entitiesWithOperations);
                }
            }
        }
        this.statsLogger.updateIndex(IndexDirectoryFactory.Name.ISSUE, stopwatch.elapsed(TimeUnit.MILLISECONDS), entitiesWithOperations.size(), batchCounter.get());
    }

    static void preconditionCheckStateAllReplicatedIndexOperationOnSameIndex(IndexDirectoryFactory.Name indexName, List<ReplicatedIndexOperation> replicatedIndexOperations) {
        replicatedIndexOperations.forEach(operation -> Preconditions.checkState((boolean)indexName.equals((Object)IndexDirectoryFactory.Name.from(operation.getAffectedIndex()))));
    }

    static void preconditionCheckStateAllEntityWithOperationOnSameIndex(IndexDirectoryFactory.Name indexName, List<EntityWithOperation> entitiesWithOperations) {
        entitiesWithOperations.forEach(entityWithOperation -> Preconditions.checkState((boolean)indexName.equals((Object)entityWithOperation.getIndexName())));
    }

    /*
     * Unable to fully structure code
     */
    void updateCommentsIndex(List<EntityWithOperation> entitiesWithOperations) throws IndexException {
        DefaultNodeReindexService.preconditionCheckStateAllEntityWithOperationOnSameIndex(IndexDirectoryFactory.Name.COMMENT, entitiesWithOperations);
        if (entitiesWithOperations.isEmpty()) {
            return;
        }
        stopwatch = Stopwatch.createStarted();
        batchCounter = new AtomicInteger();
        block20: for (List<EntityWithOperation> entitiesWithOperationSequence : DefaultNodeReindexService.breakEntityWithOperationsSequenceByOperation(IndexDirectoryFactory.Name.COMMENT, DefaultNodeReindexService.sortOperations(entitiesWithOperations))) {
            if (entitiesWithOperationSequence.isEmpty()) continue;
            batchCounter.incrementAndGet();
            firstEntityWithOperationInSequence = entitiesWithOperationSequence.get(0);
            switch (1.$SwitchMap$com$atlassian$jira$index$ha$ReplicatedIndexOperation$Operation[firstEntityWithOperationInSequence.getOperation().ordinal()]) {
                case 3: {
                    ignored = this.timer(entitiesWithOperationSequence);
                    var8_8 = null;
                    this.indexingService.deIndexComments(new HashSet<EntityWithOperation>(entitiesWithOperationSequence), false);
                    if (ignored == null) continue block20;
                    if (var8_8 == null) ** GOTO lbl25
                    try {
                        ignored.close();
                    }
                    catch (Throwable var9_10) {
                        var8_8.addSuppressed(var9_10);
                    }
                    break;
lbl25:
                    // 1 sources

                    ignored.close();
                    break;
                    catch (Throwable var9_11) {
                        try {
                            var8_8 = var9_11;
                            throw var9_11;
                        }
                        catch (Throwable var10_13) {
                            if (ignored != null) {
                                if (var8_8 != null) {
                                    try {
                                        ignored.close();
                                    }
                                    catch (Throwable var11_15) {
                                        var8_8.addSuppressed(var11_15);
                                    }
                                } else {
                                    ignored.close();
                                }
                            }
                            throw var10_13;
                        }
                    }
                }
                case 1: 
                case 2: {
                    commentsToUpdate = entitiesWithOperationSequence.stream().map((Function<EntityWithOperation, Comment>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$updateCommentsIndex$11(com.atlassian.jira.index.ha.EntityWithOperation ), (Lcom/atlassian/jira/index/ha/EntityWithOperation;)Lcom/atlassian/jira/issue/comments/Comment;)((DefaultNodeReindexService)this)).filter((Predicate<Comment>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, nonNull(java.lang.Object ), (Lcom/atlassian/jira/issue/comments/Comment;)Z)()).collect(Collectors.toSet());
                    if (commentsToUpdate.isEmpty()) continue block20;
                    ignored = this.timer(entitiesWithOperationSequence);
                    var9_9 = null;
                    this.indexingService.reIndexComments(commentsToUpdate, Contexts.nullContext(), false);
                    if (ignored == null) continue block20;
                    if (var9_9 == null) ** GOTO lbl58
                    try {
                        ignored.close();
                    }
                    catch (Throwable var10_12) {
                        var9_9.addSuppressed(var10_12);
                    }
                    break;
lbl58:
                    // 1 sources

                    ignored.close();
                    break;
                    catch (Throwable var10_14) {
                        try {
                            var9_9 = var10_14;
                            throw var10_14;
                        }
                        catch (Throwable var12_16) {
                            if (ignored != null) {
                                if (var9_9 != null) {
                                    try {
                                        ignored.close();
                                    }
                                    catch (Throwable var13_17) {
                                        var9_9.addSuppressed(var13_17);
                                    }
                                } else {
                                    ignored.close();
                                }
                            }
                            throw var12_16;
                        }
                    }
                }
                default: {
                    DefaultNodeReindexService.log.error("[INDEX-REPLAY] Unsupported operation for comment index: {}, {}", (Object)firstEntityWithOperationInSequence.getOperation(), entitiesWithOperations);
                }
            }
        }
        this.statsLogger.updateIndex(IndexDirectoryFactory.Name.COMMENT, stopwatch.elapsed(TimeUnit.MILLISECONDS), entitiesWithOperations.size(), batchCounter.get());
    }

    /*
     * Unable to fully structure code
     */
    void updateWorklogsIndex(List<EntityWithOperation> entitiesWithOperations) throws IndexException {
        DefaultNodeReindexService.preconditionCheckStateAllEntityWithOperationOnSameIndex(IndexDirectoryFactory.Name.WORKLOG, entitiesWithOperations);
        if (entitiesWithOperations.isEmpty()) {
            return;
        }
        stopwatch = Stopwatch.createStarted();
        batchCounter = new AtomicInteger();
        block20: for (List<EntityWithOperation> entitiesWithOperationSequence : DefaultNodeReindexService.breakEntityWithOperationsSequenceByOperation(IndexDirectoryFactory.Name.WORKLOG, DefaultNodeReindexService.sortOperations(entitiesWithOperations))) {
            if (entitiesWithOperationSequence.isEmpty()) continue;
            batchCounter.incrementAndGet();
            firstEntityWithOperationInSequence = entitiesWithOperationSequence.get(0);
            switch (1.$SwitchMap$com$atlassian$jira$index$ha$ReplicatedIndexOperation$Operation[firstEntityWithOperationInSequence.getOperation().ordinal()]) {
                case 3: {
                    ignored = this.timer(entitiesWithOperationSequence);
                    var8_8 = null;
                    this.indexingService.deIndexWorklogs(new HashSet<EntityWithOperation>(entitiesWithOperationSequence), false);
                    if (ignored == null) continue block20;
                    if (var8_8 == null) ** GOTO lbl25
                    try {
                        ignored.close();
                    }
                    catch (Throwable var9_10) {
                        var8_8.addSuppressed(var9_10);
                    }
                    break;
lbl25:
                    // 1 sources

                    ignored.close();
                    break;
                    catch (Throwable var9_11) {
                        try {
                            var8_8 = var9_11;
                            throw var9_11;
                        }
                        catch (Throwable var10_13) {
                            if (ignored != null) {
                                if (var8_8 != null) {
                                    try {
                                        ignored.close();
                                    }
                                    catch (Throwable var11_15) {
                                        var8_8.addSuppressed(var11_15);
                                    }
                                } else {
                                    ignored.close();
                                }
                            }
                            throw var10_13;
                        }
                    }
                }
                case 1: 
                case 2: {
                    ids = entitiesWithOperationSequence.stream().map((Function<EntityWithOperation, Long>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getId(), (Lcom/atlassian/jira/index/ha/EntityWithOperation;)Ljava/lang/Long;)()).collect(Collectors.toSet());
                    worklogsToUpdate = this.getWorklogsForIds(ids);
                    if (worklogsToUpdate.isEmpty()) continue block20;
                    ignored = this.timer(entitiesWithOperationSequence);
                    var10_12 = null;
                    this.indexingService.reIndexWorklogs(worklogsToUpdate, Contexts.nullContext(), false);
                    if (ignored == null) continue block20;
                    if (var10_12 == null) ** GOTO lbl59
                    try {
                        ignored.close();
                    }
                    catch (Throwable var11_14) {
                        var10_12.addSuppressed(var11_14);
                    }
                    break;
lbl59:
                    // 1 sources

                    ignored.close();
                    break;
                    catch (Throwable var11_16) {
                        try {
                            var10_12 = var11_16;
                            throw var11_16;
                        }
                        catch (Throwable var12_17) {
                            if (ignored != null) {
                                if (var10_12 != null) {
                                    try {
                                        ignored.close();
                                    }
                                    catch (Throwable var13_18) {
                                        var10_12.addSuppressed(var13_18);
                                    }
                                } else {
                                    ignored.close();
                                }
                            }
                            throw var12_17;
                        }
                    }
                }
                default: {
                    DefaultNodeReindexService.log.error("[INDEX-REPLAY] Unsupported operation for worklog index: {}, {}", (Object)firstEntityWithOperationInSequence.getOperation(), entitiesWithOperations);
                }
            }
        }
        this.statsLogger.updateIndex(IndexDirectoryFactory.Name.WORKLOG, stopwatch.elapsed(TimeUnit.MILLISECONDS), entitiesWithOperations.size(), batchCounter.get());
    }

    private Set<Worklog> getWorklogsForIds(Set<Long> ids) {
        List batches = Lists.partition(new ArrayList<Long>(ids), (int)1000);
        HashSet<Worklog> result = new HashSet<Worklog>();
        for (List idsBatch : batches) {
            result.addAll(this.worklogManager.getWorklogsForIds(new HashSet(idsBatch)));
        }
        return result;
    }

    void recordStats(ReplicationStats.Index index, long endTime, long startTime, long opIndexTime) {
        long localOperationTime = endTime - startTime;
        long replicationLatency = endTime - opIndexTime;
        IndexingTimers.REPLICATION_LATENCY.update(replicationLatency, TimeUnit.MILLISECONDS);
        this.replicationStats.addDataPoint(index, replicationLatency, localOperationTime);
    }

    private OperationTimer timer(List<EntityWithOperation> entitiesWithOperations) {
        long start = System.currentTimeMillis();
        return () -> {
            long end = System.currentTimeMillis();
            entitiesWithOperations.forEach(e -> this.recordStats(ReplicationStats.Index.from(e.getIndexName().toAffectedIndex()), end, start, e.getIndexTime().getTime()));
        };
    }

    void deindexProject(Project project) {
        this.indexingService.deIndex(project, false);
    }

    void reindexProject(Project project) {
        try {
            if (this.projectReindexService.isReindexPossible(project)) {
                this.projectReindexService.reindex(project, false);
            }
        }
        catch (AlreadyExecutingException aee) {
            log.debug("[INDEX-REPLAY] Lost race detecting that project reindex for '" + project.getKey() + "' is already in progress", (Throwable)aee);
        }
    }

    private Map<AffectedIndex, Set<ReplicatedIndexOperation>> partition(Set<ReplicatedIndexOperation> indexOps) {
        HashMap partitionedOperations = Maps.newHashMap();
        for (AffectedIndex affectedIndex : AffectedIndex.values()) {
            partitionedOperations.put(affectedIndex, Sets.newHashSet());
        }
        for (ReplicatedIndexOperation operation : indexOps) {
            ((Set)partitionedOperations.get(operation.getAffectedIndex())).add(operation);
        }
        return partitionedOperations;
    }

    @Override
    public Map totalStats() {
        Gson gson = new Gson();
        return (Map)gson.fromJson(this.statsLogger.total().toString(), Map.class);
    }

    static Map<String, Long> getHighestNodeCounts(Iterable<ReplicatedIndexOperation> indexOperations) {
        HashMap<String, Long> highestOperationIds = new HashMap<String, Long>();
        for (ReplicatedIndexOperation indexOperation : indexOperations) {
            String nodeId = indexOperation.getNodeId();
            Long currentHigh = (Long)highestOperationIds.get(nodeId);
            if (currentHigh != null && currentHigh >= indexOperation.getId()) continue;
            highestOperationIds.put(nodeId, indexOperation.getId());
        }
        return highestOperationIds;
    }

    private void handleUpdateWithRelatedIssuesWithoutVersion(List<EntityWithOperation> operations) {
        List issueToUpdate = this.issueManager.getIssueObjects((Collection)operations.stream().filter(e -> EntityDocumentFactory.ENTITY_VERSION_ZERO.equals(e.getVersion())).filter(e -> e.getIndexName() == IndexDirectoryFactory.Name.ISSUE).filter(e -> e.getOperation() == ReplicatedIndexOperation.Operation.UPDATE_WITH_RELATED).map(EntityWithOperation::getId).collect(Collectors.toSet()));
        if (!issueToUpdate.isEmpty()) {
            this.internalIndexingService.unconditionallyReindexIssuesAndRelatedEntitiesLocally(issueToUpdate);
            log.info("[INDEX-REPLAY] {} issues with related entities had no version and were re-indexed unconditionally.", (Object)issueToUpdate.size());
        }
    }

    private /* synthetic */ Comment lambda$updateCommentsIndex$11(EntityWithOperation entityWithOperation) {
        return this.commentManager.getCommentById(entityWithOperation.getId());
    }

    private static class StackCollector
    extends Throwable {
        private StackCollector() {
        }
    }

    private static class LatestGaugeValue
    implements ExternalValue {
        private long value = 0L;

        private LatestGaugeValue() {
        }

        public void setValue(long value) {
            this.value = value;
        }

        public long getValue() {
            return this.value;
        }
    }

    private static interface OperationTimer
    extends AutoCloseable {
        @Override
        public void close();
    }
}

