/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.ha;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.dataimport.ImportCompletedEvent;
import com.atlassian.jira.bc.dataimport.ImportStartedEvent;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.index.ha.DefaultIndexRecoveryManager;
import com.atlassian.jira.index.ha.IndexRecoveryManager;
import com.atlassian.jira.index.ha.IndexRecoveryResult;
import com.atlassian.jira.index.ha.TotalAndSnapshotIndexRepairStats;
import com.atlassian.jira.issue.index.IndexingShutdownEvent;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.util.stats.JiraStats;
import com.atlassian.jira.util.thread.JiraThreadLocalUtils;
import com.atlassian.plugin.event.events.PluginFrameworkShutdownEvent;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServerIndexRepairService {
    private static final Logger log = LoggerFactory.getLogger(DefaultServerIndexRepairService.class);
    public static final String SYSTEM_PROPERTY_PERIOD_SECONDS = "jira.index.repairjob.period.seconds";
    public static final long DEFAULT_PERIOD_SECONDS = 10L;
    public static final String SYSTEM_PROPERTY_MAX_TIMESPAN_SECONDS = "jira.index.repairjob.max.replay.timespan.seconds";
    public static final long DEFAULT_MAX_TIMESPAN_SECONDS = Duration.ofMinutes(5L).getSeconds();
    public static final String SYSTEM_PROPERTY_SAFETY_MARGIN_SECONDS = "jira.index.repairjob.safety.margin.seconds";
    public static final long DEFAULT_SAFETY_MARGIN_SECONDS = 15L;
    private final IndexRecoveryManager indexRecoveryManager;
    private final ScheduledExecutorService executor;
    private final TotalAndSnapshotIndexRepairStats stats;
    private final AtomicBoolean isPaused = new AtomicBoolean();
    private final Duration maxTimeSpanForReplayingOperations;
    private final Duration period;
    private final Duration safetyMargin;
    private final Clock clock;
    private Instant lastRun;

    public DefaultServerIndexRepairService(JiraProperties jiraProperties, EventPublisher eventPublisher, IndexRecoveryManager indexRecoveryManager) {
        this(jiraProperties, eventPublisher, indexRecoveryManager, Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("periodic-de-index-fixer-%d").setDaemon(true).build()), Clock.systemUTC(), new TotalAndSnapshotIndexRepairStats());
    }

    @VisibleForTesting
    DefaultServerIndexRepairService(JiraProperties jiraProperties, EventPublisher eventPublisher, IndexRecoveryManager indexRecoveryManager, ScheduledExecutorService executor, Clock clock, TotalAndSnapshotIndexRepairStats stats) {
        this.indexRecoveryManager = indexRecoveryManager;
        this.executor = executor;
        this.maxTimeSpanForReplayingOperations = Duration.ofSeconds(jiraProperties.getLong(SYSTEM_PROPERTY_MAX_TIMESPAN_SECONDS, Long.valueOf(DEFAULT_MAX_TIMESPAN_SECONDS)));
        this.period = Duration.ofSeconds(jiraProperties.getLong(SYSTEM_PROPERTY_PERIOD_SECONDS, Long.valueOf(10L)));
        this.safetyMargin = Duration.ofSeconds(jiraProperties.getLong(SYSTEM_PROPERTY_SAFETY_MARGIN_SECONDS, Long.valueOf(15L)));
        if (this.maxTimeSpanForReplayingOperations.compareTo(this.period) < 0) {
            log.warn("[INDEX-FIXER] Service configured to run less often ({}) than the maximum allowed timespan ({}). {} (default {}s) should denote a smaller value than {} (default {}s).", new Object[]{DefaultIndexRecoveryManager.readableDuration(this.period), DefaultIndexRecoveryManager.readableDuration(this.maxTimeSpanForReplayingOperations), SYSTEM_PROPERTY_PERIOD_SECONDS, 10L, SYSTEM_PROPERTY_MAX_TIMESPAN_SECONDS, DEFAULT_MAX_TIMESPAN_SECONDS});
        }
        if (this.safetyMargin.getSeconds() != 15L) {
            log.info("[INDEX-FIXER] Service configured to use a custom safety margin of {}s via the {} property. The default value was {}s.", new Object[]{this.safetyMargin.getSeconds(), SYSTEM_PROPERTY_SAFETY_MARGIN_SECONDS, 15L});
        }
        this.clock = clock;
        this.lastRun = clock.instant();
        this.stats = stats;
        eventPublisher.register((Object)this);
    }

    @EventListener
    public void onPluginFrameworkStarted(PluginFrameworkStartedEvent event) {
        log.info("[INDEX-FIXER] Starting {} with settings: period={}, max.replay.timespan={}", new Object[]{DefaultServerIndexRepairService.class.getSimpleName(), DefaultIndexRecoveryManager.readableDuration(this.period), DefaultIndexRecoveryManager.readableDuration(this.maxTimeSpanForReplayingOperations)});
        this.lastRun = this.clock.instant();
        this.executor.scheduleAtFixedRate(this::deindexRecentOperations, this.period.getSeconds(), this.period.getSeconds(), TimeUnit.SECONDS);
        long periodInMin = JiraStats.statsLoggingInterval((TimeUnit)TimeUnit.MINUTES);
        log.info("[INDEX-FIXER] stats will be running every: {} min", (Object)periodInMin);
        this.executor.scheduleAtFixedRate(this::onPeriodicStats, periodInMin, periodInMin, TimeUnit.MINUTES);
    }

    @EventListener
    public void onIndexingShutdownEvent(IndexingShutdownEvent event) {
        this.pause();
    }

    @EventListener
    public void onImportStartedEvent(ImportStartedEvent event) {
        this.pause();
    }

    @EventListener
    public void onImportCompletedEvent(ImportCompletedEvent event) {
        this.start();
    }

    public void pause() {
        log.info("Pausing DefaultServerIndexRepairService");
        try {
            this.executor.submit(() -> this.isPaused.set(true)).get(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.warn("Pausing DefaultServerIndexRepairService was interrupted");
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            log.error("Failed to pause DefaultServerIndexRepairService", (Throwable)e);
        }
        catch (TimeoutException e) {
            log.warn("Failed to pause DefaultServerIndexRepairService within 5s");
        }
    }

    public void start() {
        log.info("Restarting DefaultServerIndexRepairService");
        this.isPaused.set(false);
    }

    @EventListener
    public void onPluginFrameworkShutdown(PluginFrameworkShutdownEvent event) {
        this.shutdown();
    }

    public void shutdown() {
        boolean stoppedSuccessfully = MoreExecutors.shutdownAndAwaitTermination((ExecutorService)this.executor, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        if (stoppedSuccessfully) {
            log.info("[INDEX-FIXER] {} was stopped successfully.", (Object)DefaultServerIndexRepairService.class.getSimpleName());
        } else {
            log.warn("[INDEX-FIXER] {} has not stopped on time.", (Object)DefaultServerIndexRepairService.class.getSimpleName());
        }
    }

    private void onPeriodicStats() {
        if (this.isPaused.get()) {
            return;
        }
        try {
            this.stats.onPeriodicStats();
        }
        catch (Throwable t) {
            log.error("[INDEX-FIXER] Printing stats for the job that ensures de-index correctness has failed", t);
        }
    }

    private void deindexRecentOperations() {
        if (this.isPaused.get()) {
            return;
        }
        JiraThreadLocalUtils.wrap(() -> {
            Instant now = this.clock.instant();
            if (now.isAfter(this.lastRun.plus(this.maxTimeSpanForReplayingOperations))) {
                log.warn("[INDEX-FIXER] Time from the last execution ({}) exceeds the maximum allowed timespan to catch up ({}). Skipping some issues.", (Object)DefaultIndexRecoveryManager.readableDuration(Duration.between(this.lastRun, now)), (Object)DefaultIndexRecoveryManager.readableDuration(this.maxTimeSpanForReplayingOperations));
                this.lastRun = now.minus(this.maxTimeSpanForReplayingOperations);
            }
            Duration range = Duration.between(this.lastRun, now).plus(this.safetyMargin);
            log.trace("[INDEX-FIXER] de-indexing recent operations (last {} of activity)", (Object)DefaultIndexRecoveryManager.readableDuration(range));
            try {
                TaskProgressSink traceLoggingSink = (progress, currentSubTask, msg) -> log.trace("[INDEX-FIXER] {}", (Object)msg);
                Instant reindexStartTime = this.clock.instant();
                IndexRecoveryResult reindexResult = this.indexRecoveryManager.deindexEntitiesDeletedInTheLast(range, traceLoggingSink);
                Instant reindexStopTime = this.clock.instant();
                Duration repairTime = Duration.between(reindexStartTime, reindexStopTime);
                this.stats.onIndexRecovery(reindexResult, repairTime.toMillis());
                this.lastRun = now;
            }
            catch (Throwable t) {
                log.error("[INDEX-FIXER] The job to ensure index correctness for de-index operations in the last {} has failed", (Object)DefaultIndexRecoveryManager.readableDuration(range), (Object)t);
                this.stats.onError();
            }
        }).run();
    }
}

