/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.ha;

import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.component.ComponentReference;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.index.ha.ReplicatedIndexOperation;
import com.atlassian.jira.index.ha.ReplicatedIndexOperationFactory;
import com.atlassian.jira.index.request.AffectedIndex;
import com.atlassian.jira.index.request.SharedEntityType;
import com.atlassian.jira.model.querydsl.QReplicatedIndexOperation;
import com.atlassian.jira.model.querydsl.ReplicatedIndexOperationDTO;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.lang.Pair;
import com.google.common.collect.ImmutableList;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.DateTimeExpression;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityExprList;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericValue;

public class OfBizReplicatedIndexOperationStore {
    private static final String MAX_VIEW = "IndexOperationMaxIdForNodeId";
    private static final String MAX_ID = "max";
    private final OfBizDelegator ofBizDelegator;
    private final ComponentReference<ClusterManager> clusterManagerRef = ComponentAccessor.getComponentReference(ClusterManager.class);
    private final ReplicatedIndexOperationFactory operationFactory;
    private final QueryDslAccessor queryDslAccessor;

    public OfBizReplicatedIndexOperationStore(OfBizDelegator ofBizDelegator, QueryDslAccessor queryDslAccessor) {
        this.ofBizDelegator = ofBizDelegator;
        this.queryDslAccessor = queryDslAccessor;
        this.operationFactory = new ReplicatedIndexOperationFactory();
    }

    @Nullable
    public Long createIndexOperation(AffectedIndex affectedIndex, SharedEntityType entityType, ReplicatedIndexOperation.Operation operation, Map<Long, Long> affectedIdToVersion, String backupFilename) {
        String nodeId = this.getClusterManager().getNodeId();
        if (!this.isReplicationDataValid(affectedIndex, nodeId, affectedIdToVersion.isEmpty())) {
            return null;
        }
        Pair<String, String> affectedIdsAndVersions = ReplicatedIndexOperationFactory.serializeMap(affectedIdToVersion);
        return this.insertIndexOperation(affectedIndex, entityType, operation, backupFilename, nodeId, (String)affectedIdsAndVersions.first(), (String)affectedIdsAndVersions.second());
    }

    @Nullable
    public Long createIndexOperationForNonVersionEntities(AffectedIndex affectedIndex, SharedEntityType entityType, ReplicatedIndexOperation.Operation operation, Collection<Long> affectedIds, String backupFilename) {
        String nodeId = this.getClusterManager().getNodeId();
        if (!this.isReplicationDataValid(affectedIndex, nodeId, affectedIds.isEmpty())) {
            return null;
        }
        return this.insertIndexOperation(affectedIndex, entityType, operation, backupFilename, nodeId, ReplicatedIndexOperationFactory.serializeCollection(affectedIds), null);
    }

    private long insertIndexOperation(AffectedIndex affectedIndex, SharedEntityType entityType, ReplicatedIndexOperation.Operation operation, String backupFilename, String nodeId, String affectedIds, @Nullable String versions) {
        ReplicatedIndexOperationDTO dto = ReplicatedIndexOperationDTO.builder().operation(operation.toString()).nodeId(nodeId).affectedIndex(affectedIndex.toString()).entityType(entityType.toString()).affectedIds(affectedIds).versions(versions).filename(backupFilename).build();
        return this.queryDslAccessor.executeQuery(c -> c.insert(QReplicatedIndexOperation.REPLICATED_INDEX_OPERATION).populate(dto).set((Path)QReplicatedIndexOperation.REPLICATED_INDEX_OPERATION.indexTime, (Expression)DateTimeExpression.currentTimestamp(Timestamp.class)).executeWithId());
    }

    boolean isReplicationDataValid(@Nonnull AffectedIndex affectedIndex, String nodeId, boolean empty) {
        return nodeId != null && (!empty || affectedIndex.equals((Object)AffectedIndex.ALL));
    }

    public int purgeOldOperations(String sourceNodeId, Date before) {
        Long latestOperationId = this.getLatestOperation(sourceNodeId);
        if (latestOperationId != null) {
            ImmutableList entityConditions = ImmutableList.of((Object)new EntityExpr("nodeId", EntityOperator.EQUALS, (Object)sourceNodeId), (Object)new EntityExpr("id", EntityOperator.LESS_THAN, (Object)latestOperationId), (Object)new EntityExpr("indexTime", EntityOperator.LESS_THAN, (Object)new Timestamp(before.getTime())));
            return this.ofBizDelegator.removeByCondition("ReplicatedIndexOperation", (EntityCondition)new EntityExprList((List)entityConditions, EntityOperator.AND));
        }
        return 0;
    }

    public Set<ReplicatedIndexOperation> getIndexOperationsAfter(String sourceNodeId, Long operationId) {
        ImmutableList entityConditions = ImmutableList.of((Object)new EntityExpr("nodeId", EntityOperator.EQUALS, (Object)sourceNodeId), (Object)new EntityExpr("id", EntityOperator.GREATER_THAN, (Object)operationId));
        return this.ofBizDelegator.findByAnd("ReplicatedIndexOperation", (List)entityConditions).stream().map(this.operationFactory::build).collect(Collectors.toSet());
    }

    public Set<ReplicatedIndexOperation> getIndexOperationsAfterIdAndOlderThan(String sourceNodeId, Long operationId, int ageThresholdInSec) {
        return this.queryDslAccessor.executeQuery(c -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)c.newSqlQuery().select((Expression)QReplicatedIndexOperation.REPLICATED_INDEX_OPERATION).from((Expression)QReplicatedIndexOperation.REPLICATED_INDEX_OPERATION)).where((Predicate)QReplicatedIndexOperation.REPLICATED_INDEX_OPERATION.nodeId.eq((Object)sourceNodeId))).where((Predicate)QReplicatedIndexOperation.REPLICATED_INDEX_OPERATION.id.gt((Number)operationId))).where((Predicate)QReplicatedIndexOperation.REPLICATED_INDEX_OPERATION.indexTime.before((Expression)SQLExpressions.addSeconds((DateTimeExpression)DateTimeExpression.currentTimestamp(Timestamp.class), (int)(-1 * ageThresholdInSec))))).fetch().stream().map(this.operationFactory::build).collect(Collectors.toSet()));
    }

    public Set<ReplicatedIndexOperation> getUnprocessedReindexOperationsAfterId(String sourceNodeId, Long operationId) {
        return this.queryDslAccessor.executeQuery(c -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)c.newSqlQuery().select((Expression)QReplicatedIndexOperation.REPLICATED_INDEX_OPERATION).from((Expression)QReplicatedIndexOperation.REPLICATED_INDEX_OPERATION)).where((Predicate)QReplicatedIndexOperation.REPLICATED_INDEX_OPERATION.nodeId.eq((Object)sourceNodeId))).where((Predicate)QReplicatedIndexOperation.REPLICATED_INDEX_OPERATION.id.gt((Number)operationId))).where((Predicate)QReplicatedIndexOperation.REPLICATED_INDEX_OPERATION.operation.in((Object[])new String[]{ReplicatedIndexOperation.Operation.FULL_REINDEX_END.toString(), ReplicatedIndexOperation.Operation.BACKGROUND_REINDEX_END.toString(), ReplicatedIndexOperation.Operation.PROJECT_REINDEX.toString(), ReplicatedIndexOperation.Operation.PROJECT_DEINDEX.toString()}))).fetch().stream().map(this.operationFactory::build).collect(Collectors.toSet()));
    }

    public ReplicatedIndexOperation getOperation(long id) {
        ReplicatedIndexOperationDTO dto = this.queryDslAccessor.executeQuery(c -> (ReplicatedIndexOperationDTO)((SQLQuery)((SQLQuery)c.newSqlQuery().select((Expression)QReplicatedIndexOperation.REPLICATED_INDEX_OPERATION).from((Expression)QReplicatedIndexOperation.REPLICATED_INDEX_OPERATION)).where((Predicate)QReplicatedIndexOperation.REPLICATED_INDEX_OPERATION.id.eq((Object)id))).fetchOne());
        return dto == null ? null : this.operationFactory.build(dto);
    }

    public Long getLatestOperation(String sourceNodeId) {
        List gvs = this.ofBizDelegator.findByAnd(MAX_VIEW, (Map)FieldMap.build((String)"nodeId", (Object)sourceNodeId));
        if (gvs.isEmpty()) {
            return null;
        }
        return ((GenericValue)gvs.get(0)).getLong(MAX_ID);
    }

    public boolean contains(long id) {
        GenericValue gv = this.ofBizDelegator.findByPrimaryKey("ReplicatedIndexOperation", Long.valueOf(id));
        return gv != null;
    }

    private ClusterManager getClusterManager() {
        return (ClusterManager)this.clusterManagerRef.get();
    }
}

