/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.stats;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.index.stats.IndexSearcherStats;
import com.atlassian.jira.index.stats.SearchStatsEvent;
import com.atlassian.jira.issue.index.IndexDirectoryFactory;
import com.atlassian.jira.util.stats.JiraStats;
import com.atlassian.jira.util.stats.LongStats;
import com.atlassian.jira.util.stats.MutableLongStats;
import com.google.gson.Gson;
import java.time.Clock;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TotalAndSnapshotIndexSearcherStats
implements IndexSearcherStats {
    private static final Logger log = LoggerFactory.getLogger(TotalAndSnapshotIndexSearcherStats.class);
    private static final String LOGPREFIX = "[index-searcher-stats] ";
    private final IndexDirectoryFactory.Name indexName;
    private final MutableSearcherStats snapshotSearcherStats;
    private final MutableSearcherStats totalSearcherStats;
    private final long periodInMillis;
    private final Clock clock;
    private volatile long lastPublicationTimestamp;

    public TotalAndSnapshotIndexSearcherStats(IndexDirectoryFactory.Name indexName) {
        this(indexName, Clock.systemUTC());
    }

    @VisibleForTesting
    TotalAndSnapshotIndexSearcherStats(IndexDirectoryFactory.Name indexName, Clock clock) {
        this.indexName = indexName;
        this.snapshotSearcherStats = new MutableSearcherStats();
        this.totalSearcherStats = new MutableSearcherStats();
        this.periodInMillis = JiraStats.statsLoggingInterval((TimeUnit)TimeUnit.MILLISECONDS);
        this.clock = clock;
        this.lastPublicationTimestamp = clock.millis();
    }

    @Override
    public void onSearch(long millis) {
        this.totalSearcherStats.onSearch(millis);
        this.snapshotSearcherStats.onSearch(millis);
    }

    @Override
    public void onDoc(long millis) {
        this.totalSearcherStats.onDoc(millis);
        this.snapshotSearcherStats.onDoc(millis);
    }

    @Override
    public void onGetSearcherTotal(long millis) {
        this.totalSearcherStats.onGetSearcherTotal(millis);
        this.snapshotSearcherStats.onGetSearcherTotal(millis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onGetNewSearcher(long millis) {
        this.totalSearcherStats.onGetNewSearcher(millis);
        this.snapshotSearcherStats.onGetNewSearcher(millis);
        if (this.shouldPublishStats()) {
            TotalAndSnapshotIndexSearcherStats totalAndSnapshotIndexSearcherStats = this;
            synchronized (totalAndSnapshotIndexSearcherStats) {
                if (this.shouldPublishStats()) {
                    this.printAndSendStats();
                }
            }
        }
    }

    @VisibleForTesting
    MutableSearcherStats getSnapshotSearcherStats() {
        return this.snapshotSearcherStats;
    }

    @VisibleForTesting
    MutableSearcherStats getTotalSearcherStats() {
        return this.totalSearcherStats;
    }

    private boolean shouldPublishStats() {
        return this.clock.millis() - this.lastPublicationTimestamp >= this.periodInMillis;
    }

    private void printAndSendStats() {
        Optional eventPublisher;
        MutableSearcherStats.Result totalResult = this.totalSearcherStats.get();
        MutableSearcherStats.Result snapshotResult = this.snapshotSearcherStats.get();
        this.snapshotSearcherStats.reset();
        if (log.isInfoEnabled()) {
            Gson gson = new Gson();
            String totalJson = gson.toJson((Object)totalResult);
            String snapshotJson = gson.toJson((Object)snapshotResult);
            log.info("[JIRA-STATS] {}total stats: {}", (Object)this.getPrefix(), (Object)totalJson);
            log.info("[JIRA-STATS] {}snapshot stats: {}", (Object)this.getPrefix(), (Object)snapshotJson);
        }
        if ((eventPublisher = ComponentAccessor.getComponentSafely(EventPublisher.class)).isPresent()) {
            long currentTime = this.clock.millis();
            long intervalInMillis = currentTime - this.lastPublicationTimestamp;
            ((EventPublisher)eventPublisher.get()).publish((Object)new SearchStatsEvent(this.indexName, snapshotResult.searchStatsInMillis, snapshotResult.docStatsInMillis, snapshotResult.getSearcherTotalStatsInMillis, snapshotResult.getNewSearcherStatsInMillis, intervalInMillis));
            this.lastPublicationTimestamp = currentTime;
        } else {
            log.debug("{}could not send analytics. {} component not available yet.", (Object)this.getPrefix(), (Object)EventPublisher.class.getSimpleName());
        }
    }

    private String getPrefix() {
        return LOGPREFIX + (Object)((Object)this.indexName) + " : ";
    }

    static class MutableSearcherStats
    implements IndexSearcherStats {
        private final MutableLongStats searchStatsInMillis = new MutableLongStats(DISTRIBUTION_BUCKETS);
        private final MutableLongStats docStatsInMillis = new MutableLongStats(DISTRIBUTION_BUCKETS);
        private final MutableLongStats getSearcherTotalStatsInMillis = new MutableLongStats(DISTRIBUTION_BUCKETS);
        private final MutableLongStats getNewSearcherStatsInMillis = new MutableLongStats(DISTRIBUTION_BUCKETS);
        private static final long[] DISTRIBUTION_BUCKETS = new long[]{1L, 10L, 20L, 50L, 100L, 500L, 1000L, 5000L};

        @Override
        public void onSearch(long millis) {
            this.searchStatsInMillis.accept(millis);
        }

        @Override
        public void onDoc(long millis) {
            this.docStatsInMillis.accept(millis);
        }

        @Override
        public void onGetSearcherTotal(long millis) {
            this.getSearcherTotalStatsInMillis.accept(millis);
        }

        @Override
        public void onGetNewSearcher(long millis) {
            this.getNewSearcherStatsInMillis.accept(millis);
        }

        public void reset() {
            this.searchStatsInMillis.reset();
            this.docStatsInMillis.reset();
            this.getSearcherTotalStatsInMillis.reset();
            this.getNewSearcherStatsInMillis.reset();
        }

        public Result get() {
            return new Result();
        }

        class Result {
            LongStats searchStatsInMillis;
            LongStats docStatsInMillis;
            LongStats getSearcherTotalStatsInMillis;
            LongStats getNewSearcherStatsInMillis;

            Result() {
                this.searchStatsInMillis = MutableSearcherStats.this.searchStatsInMillis.get();
                this.docStatsInMillis = MutableSearcherStats.this.docStatsInMillis.get();
                this.getSearcherTotalStatsInMillis = MutableSearcherStats.this.getSearcherTotalStatsInMillis.get();
                this.getNewSearcherStatsInMillis = MutableSearcherStats.this.getNewSearcherStatsInMillis.get();
            }
        }
    }
}

