/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.instrumentation;

import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.ManagedCache;
import com.atlassian.instrumentation.caches.CacheCollector;
import com.atlassian.instrumentation.caches.RequestListener;
import com.atlassian.jira.cache.JiraVCacheRequestContextSupplier;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.instrumentation.CacheStatistics;
import com.atlassian.jira.instrumentation.CacheStatisticsUtils;
import com.atlassian.jira.instrumentation.InstrumentationListenerManager;
import com.atlassian.jira.instrumentation.InstrumentationLogger;
import com.atlassian.jira.instrumentation.RequestData;
import com.atlassian.jira.instrumentation.Statistics;
import com.atlassian.vcache.internal.RequestMetrics;
import com.atlassian.vcache.internal.VCacheLifecycleManager;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultInstrumentationListenerManager
implements InstrumentationListenerManager {
    private static final String CACHETYPE_CACHE = "C";
    private static final String CACHETYPE_CACHED_REFERENCE = "R";
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultInstrumentationListenerManager.class);
    private static final ThreadLocal<RequestData> requestData = new ThreadLocal();
    private final List<RequestListener> requestListeners = new CopyOnWriteArrayList<RequestListener>();
    private final InstrumentationLogger instrumentationLogger;
    private final VCacheLifecycleManager vCacheLifecycleManager;
    private final JiraVCacheRequestContextSupplier contextSupplier;
    private final CacheManager cacheManager;
    private final List<String> exclude = ImmutableList.of((Object)"ViewUris.jspa", (Object)"ViewCacheStats.jspa", (Object)"ViewCacheDetails.jspa", (Object)"ViewCachesByRequest.jspa", (Object)"ManageCacheInstrumentation.jspa", (Object)"ClearBuffer.jspa", (Object)"EnableAll.jspa", (Object)"DisableAll.jspa");

    public DefaultInstrumentationListenerManager(InstrumentationLogger instrumentationLogger, VCacheLifecycleManager vCacheLifecycleManager, JiraVCacheRequestContextSupplier contextSupplier, CacheManager cacheManager) {
        this.cacheManager = cacheManager;
        this.vCacheLifecycleManager = Objects.requireNonNull(vCacheLifecycleManager, "vCacheLifecycleManager cannot be null");
        this.contextSupplier = Objects.requireNonNull(contextSupplier, "contextSupplier cannot be null");
        this.instrumentationLogger = Objects.requireNonNull(instrumentationLogger, "instrumentationLogger cannot be null");
    }

    @Override
    public void processOnStartListeners() {
        this.requestListeners.stream().forEach(listener -> {
            try {
                listener.onRequestStart();
            }
            catch (RuntimeException e) {
                LOGGER.info("instrumentation listener threw an exception", (Throwable)e);
            }
        });
    }

    @Override
    public void processOnEndListeners(RequestData requestData, Optional<Long> requestTime) {
        if (requestData.getPath().map(this::excludePath).orElseGet(() -> false).booleanValue()) {
            return;
        }
        Stream<CacheStatistics> atlassianCacheStats = this.collectAtlassianCacheStats();
        Stream<Statistics> otherMetrics = this.collectOtherMetrics();
        Stream<CacheStatistics> vCacheStats = this.collectVCacheStats();
        this.instrumentationLogger.save(requestData, Stream.concat(Stream.concat(atlassianCacheStats, vCacheStats), otherMetrics).collect(Collectors.toList()), requestTime);
    }

    @Override
    @NotNull
    public void addRequestListener(@Nonnull RequestListener listener) {
        Objects.requireNonNull(listener);
        if (!this.requestListeners.contains(listener)) {
            this.requestListeners.add(listener);
        }
    }

    @Override
    @NotNull
    public void removeRequestListener(@Nonnull RequestListener listener) {
        Objects.requireNonNull(listener);
        this.requestListeners.remove(listener);
    }

    public static void startContext(@Nonnull String path) {
        DefaultInstrumentationListenerManager.startContext(path, null, null, null, null, null);
    }

    public static void startContext(@Nonnull String path, @Nullable String traceId, @Nullable String spanId, @Nullable String parentSpanId, @Nullable String queryString, @Nullable Long startNanoTime) {
        if (requestData.get() != null) {
            return;
        }
        requestData.set(new RequestData.Builder().setPath(path).setTraceId(traceId == null ? UUID.randomUUID().toString() : traceId).setSpanId(spanId).setParentSpanId(parentSpanId).setQueryString(queryString).setStartNanoTime(startNanoTime).build());
        ComponentAccessor.getComponentSafely(InstrumentationListenerManager.class).ifPresent(InstrumentationListenerManager::processOnStartListeners);
    }

    public static void endContext() {
        DefaultInstrumentationListenerManager.endContext(Optional.empty());
    }

    public static void endContext(Optional<Long> requestTime) {
        try {
            if (requestData.get() == null) {
                return;
            }
            Optional manager = ComponentAccessor.getComponentSafely(InstrumentationListenerManager.class);
            if (manager.isPresent()) {
                RequestData data = requestData.get();
                ((InstrumentationListenerManager)manager.get()).processOnEndListeners(data, requestTime);
            }
        }
        finally {
            requestData.remove();
        }
    }

    @Override
    public void applyToAllListeners(Consumer<RequestListener> apply) {
        this.requestListeners.forEach(apply);
    }

    @Override
    @Nonnull
    public Optional<String> getCurrentPath() {
        if (requestData.get() != null) {
            return requestData.get().getPath();
        }
        return Optional.empty();
    }

    @Override
    @Nonnull
    public Optional<String> getCurrentTraceId() {
        if (requestData.get() != null) {
            return requestData.get().getTraceId();
        }
        return Optional.empty();
    }

    @Override
    @Nonnull
    public Optional<RequestData> getRequestData() {
        return Optional.ofNullable(requestData.get());
    }

    private boolean excludePath(@Nonnull String path) {
        Objects.requireNonNull(path);
        return this.exclude.stream().anyMatch(path::endsWith);
    }

    private Stream<CacheStatistics> collectAtlassianCacheStats() {
        return this.requestListeners.stream().filter(listener -> listener.isEnabled() && listener instanceof CacheCollector).map(this::getAtlassianCacheStatistics).filter(stat -> Objects.nonNull(stat) && stat.getStatsMap().size() != 0);
    }

    private CacheStatistics getAtlassianCacheStatistics(RequestListener listener) {
        try {
            String cacheType = CACHETYPE_CACHE;
            ManagedCache managedCache = this.cacheManager.getManagedCache(listener.getName());
            if (managedCache instanceof CachedReference) {
                cacheType = CACHETYPE_CACHED_REFERENCE;
            }
            return CacheStatisticsUtils.fromRequestListenerStatistics(listener, cacheType);
        }
        catch (RuntimeException e) {
            LOGGER.warn("instrumentation listener {} threw an exception", (Object)listener.getName(), (Object)e);
            return null;
        }
    }

    private Stream<CacheStatistics> collectVCacheStats() {
        if (this.contextSupplier.isInitilised()) {
            RequestMetrics metrics = this.vCacheLifecycleManager.metrics(this.contextSupplier.get());
            Stream<CacheStatistics> vCacheJvmStats = CacheStatisticsUtils.convertVCacheMetrics("JVMCache", metrics.allJvmCacheLongMetrics());
            Stream<CacheStatistics> vCacheRequestStats = CacheStatisticsUtils.convertVCacheMetrics("RequestCache", metrics.allRequestCacheLongMetrics());
            Stream<CacheStatistics> vCacheExternalStats = CacheStatisticsUtils.convertVCacheMetrics("ExternalCache", metrics.allExternalCacheLongMetrics());
            return Stream.concat(vCacheJvmStats, Stream.concat(vCacheRequestStats, vCacheExternalStats));
        }
        return Stream.empty();
    }

    private Stream<Statistics> collectOtherMetrics() {
        ArrayList result = new ArrayList();
        this.requestListeners.stream().filter(listener -> listener.isEnabled() && !(listener instanceof CacheCollector)).forEach(listener -> listener.onRequestEnd().entrySet().forEach(entry -> {
            StatisticsAdapter a = new StatisticsAdapter((String)entry.getKey(), listener.getLoggingKey(), listener.getTags(), entry.getValue());
            result.add(a);
        }));
        return result.stream();
    }

    class StatisticsAdapter
    implements Statistics {
        private final String name;
        private final String loggingKey;
        private final List<String> tags;
        private final Object resultsMap;

        public StatisticsAdapter(String name, String loggingKey, List<String> tags, Object entry) {
            this.name = name;
            this.loggingKey = loggingKey;
            this.tags = tags;
            this.resultsMap = entry;
        }

        @Override
        @JsonProperty
        public String getName() {
            return this.name;
        }

        @Override
        @JsonIgnore
        public String getLoggingKey() {
            return this.loggingKey;
        }

        @Override
        @JsonProperty
        public List<String> getTags() {
            return this.tags;
        }

        @Override
        @JsonProperty
        public Object getStats() {
            return this.resultsMap;
        }
    }
}

