/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.instrumentation.jdbc;

import com.atlassian.instrumentation.driver.Instrumentation;
import com.atlassian.instrumentation.instruments.Context;
import com.atlassian.instrumentation.instruments.EventType;
import com.atlassian.jira.instrumentation.jdbc.StackTraceHelper;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Collections;
import org.apache.log4j.Logger;

public class InstantLogJdbcStatsCollector
implements Instrumentation.SplitFactory {
    private final Logger log;
    private static final ImmutableList<EventType> SUPPORTED_EVENTS = ImmutableList.of((Object)EventType.CONNECTION_POOL, (Object)EventType.EXECUTION);
    private final ObjectWriter writer = new ObjectMapper().writer();

    public InstantLogJdbcStatsCollector(Logger log) {
        this.log = log;
    }

    public void register() {
        Instrumentation.registerFactory((Instrumentation.SplitFactory)this);
    }

    public void unregister() {
        Instrumentation.unregisterFactory((Instrumentation.SplitFactory)this);
    }

    public Instrumentation.Split startSplit(Context context) {
        return context.getEventType().filter(arg_0 -> SUPPORTED_EVENTS.contains(arg_0)).map(event -> {
            long startTime = System.currentTimeMillis();
            return () -> this.eventEnded(context, System.currentTimeMillis() - startTime);
        }).orElse(() -> {});
    }

    private void eventEnded(Context context, long durationInMs) {
        try {
            ImmutableMap data = ImmutableMap.builder().put((Object)"query", context.getSql().orElse(null)).put((Object)"time", (Object)durationInMs).put((Object)"event", context.getEventType().orElse(null)).put((Object)"stackTrace", StackTraceHelper.filterStackTrace(context.getStackTrace().orElse(Collections.emptyList()))).build();
            this.log.info((Object)this.writer.writeValueAsString((Object)data));
        }
        catch (IOException e) {
            this.log.debug((Object)"Failed to write instrumentation log", (Throwable)e);
        }
    }
}

