/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ipd;

import com.atlassian.diagnostics.internal.ipd.DefaultLoggingService;
import com.atlassian.diagnostics.ipd.internal.spi.IpdMetric;
import com.atlassian.jira.config.FeatureManager;
import com.google.common.annotations.VisibleForTesting;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraIpdLoggingService
extends DefaultLoggingService {
    private static final Logger regularLogger = LoggerFactory.getLogger((String)"ipd-monitoring");
    @VisibleForTesting
    public static final String IN_PRODUCT_DIAGNOSTICS_FF = "com.atlassian.jira.in.product.diagnostics";
    private final FeatureManager featureManager;

    public JiraIpdLoggingService(FeatureManager featureManager) {
        this.featureManager = featureManager;
    }

    public void logMetric(@Nonnull IpdMetric metric, boolean includeExtraLogging) {
        Objects.requireNonNull(metric);
        if (this.loggingFeatureIsEnabled()) {
            regularLogger.debug("{} is logging metric: {}.", (Object)"IPDMONITORING", (Object)metric.getMetricKey());
            super.logMetric(metric, includeExtraLogging);
        } else {
            regularLogger.debug("{} will not log the metric: {}; disabled by feature flag", (Object)"IPDMONITORING", (Object)metric.getMetricKey());
        }
    }

    private boolean loggingFeatureIsEnabled() {
        return this.featureManager.isEnabled(IN_PRODUCT_DIAGNOSTICS_FF);
    }
}

