/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ipd.db;

import com.atlassian.diagnostics.internal.ipd.IpdMainRegistry;
import com.atlassian.diagnostics.internal.ipd.metrics.wrapper.IpdValueAndStatsMetricWrapper;
import com.atlassian.diagnostics.ipd.internal.spi.IpdJob;
import com.atlassian.diagnostics.ipd.internal.spi.IpdJobRunner;
import com.atlassian.jira.database.DatabaseConnectionStateService;
import com.atlassian.util.profiling.MetricTag;
import java.time.Duration;
import java.util.Optional;

public class DatabaseLatencyInProductDiagnosticJob
implements IpdJob {
    private final DatabaseConnectionStateService databaseConnectionStateService;
    private final IpdValueAndStatsMetricWrapper latencyValueAndStats;

    public DatabaseLatencyInProductDiagnosticJob(DatabaseConnectionStateService databaseConnectionStateService, IpdJobRunner inProductDiagnosticScheduler, IpdMainRegistry ipdMainRegistry) {
        this.databaseConnectionStateService = databaseConnectionStateService;
        inProductDiagnosticScheduler.register((IpdJob)this);
        this.latencyValueAndStats = ipdMainRegistry.valueAndStatsMetric("db.connection.latency", new MetricTag.RequiredMetricTag[0]);
    }

    public void runJob() {
        Optional<Duration> latency = this.databaseConnectionStateService.getLatency();
        long value = latency.map(Duration::toMillis).orElse(-1L);
        if (latency.isPresent()) {
            this.latencyValueAndStats.updateStats(Long.valueOf(value));
        }
        this.latencyValueAndStats.updateValue(Long.valueOf(value));
    }
}

