/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ipd.http;

import com.atlassian.diagnostics.internal.ipd.IpdMainRegistry;
import com.atlassian.diagnostics.internal.ipd.IpdMetricRegistry;
import com.atlassian.diagnostics.internal.ipd.metrics.IpdValueMetric;
import com.atlassian.diagnostics.ipd.internal.spi.IpdJob;
import com.atlassian.diagnostics.ipd.internal.spi.IpdJobRunner;
import com.atlassian.jira.ipd.http.HttpConnectionPoolService;
import com.atlassian.util.profiling.MetricTag;

public class HttpConnectionPoolInProductDiagnosticJob
implements IpdJob {
    private final HttpConnectionPoolService httpConnectionPoolService;
    private final IpdValueMetric poolIdleMetric;
    private final IpdValueMetric poolActiveMetric;
    private final IpdValueMetric poolMaxMetric;

    public HttpConnectionPoolInProductDiagnosticJob(IpdJobRunner inProductDiagnosticScheduler, HttpConnectionPoolService httpConnectionPoolService, IpdMainRegistry ipdMainRegistry) {
        this.httpConnectionPoolService = httpConnectionPoolService;
        inProductDiagnosticScheduler.register((IpdJob)this);
        IpdMetricRegistry registry = ipdMainRegistry.createRegistry("http.connection.pool", new MetricTag.RequiredMetricTag[0]);
        this.poolIdleMetric = registry.valueMetric("numIdle", new MetricTag.RequiredMetricTag[0]);
        this.poolMaxMetric = registry.valueMetric("numMax", new MetricTag.RequiredMetricTag[0]);
        this.poolActiveMetric = registry.valueMetric("numActive", new MetricTag.RequiredMetricTag[0]);
    }

    public void runJob() {
        HttpConnectionPoolService.HttpMetric metric = this.httpConnectionPoolService.getHttpPoolSizeValue();
        this.poolIdleMetric.update(Long.valueOf(metric.getNumIdle()));
        this.poolActiveMetric.update(Long.valueOf(metric.getNumActive()));
        this.poolMaxMetric.update(Long.valueOf(metric.getNumMax()));
    }
}

