/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ipd.node;

import com.atlassian.diagnostics.internal.ipd.IpdMetricRegistry;
import com.atlassian.diagnostics.internal.ipd.metrics.IpdCustomMetric;
import com.atlassian.diagnostics.internal.ipd.metrics.IpdStatsMetric;
import com.atlassian.jira.ipd.metric.type.IpdConnectionStateType;
import com.atlassian.util.profiling.MetricTag;

public class IpdInterNodeStats {
    private final IpdMetricRegistry ipdRegistry;
    private final IpdStatsMetric nodeLatencyMetric;
    private final IpdCustomMetric<IpdConnectionStateType> nodeConnectionStateMetric;

    public IpdInterNodeStats(IpdMetricRegistry mainRegistry, String destinationNodeId) {
        this.ipdRegistry = mainRegistry.createRegistry(options -> options.withPrefix("node").withTags(new MetricTag.RequiredMetricTag[]{MetricTag.of((String)"destNode", (String)destinationNodeId)}));
        this.nodeLatencyMetric = this.ipdRegistry.statsMetric("latency", new MetricTag.RequiredMetricTag[0]);
        this.nodeConnectionStateMetric = this.ipdRegistry.customMetric("connection.state", IpdConnectionStateType.class, new MetricTag.RequiredMetricTag[0]);
    }

    public void updateNodeLatency(long timeInMillis) {
        this.nodeLatencyMetric.update(Long.valueOf(timeInMillis));
        this.nodeConnectionStateMetric.update(b -> b.setConnected(true));
    }

    public void setDisconnectedState() {
        this.nodeLatencyMetric.unregisterJmx();
        this.nodeConnectionStateMetric.update(b -> b.setConnected(false));
    }

    public void close() {
        this.ipdRegistry.removeAll();
    }
}

