/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.action;

import com.atlassian.jira.issue.comparator.NullComparator;
import com.atlassian.jira.plugin.issuetabpanel.IssueAction;
import java.util.Comparator;
import java.util.Date;

public class IssueActionComparator
implements Comparator<IssueAction> {
    private final NullComparator nullComparator = new NullComparator();
    public static final Comparator<IssueAction> OLDEST_FIRST = new IssueActionComparator();
    public static final Comparator<IssueAction> NEWEST_FIRST = new IssueActionComparator().reversed();

    @Override
    public int compare(IssueAction o1, IssueAction o2) {
        int returnValue = this.nullComparator.compare(o1, o2);
        if (returnValue != 0) {
            return returnValue;
        }
        Date timePerformed1 = this.getIssueActionTimePerformed(o1);
        Date timePerformed2 = this.getIssueActionTimePerformed(o2);
        return this.nullComparator.compare(timePerformed1, timePerformed2);
    }

    private Date getIssueActionTimePerformed(IssueAction issueAction) {
        if (issueAction == null) {
            return null;
        }
        try {
            Date date = issueAction.getTimePerformed();
            return date == null ? null : new Date(date.getTime());
        }
        catch (UnsupportedOperationException usoe) {
            return null;
        }
    }
}

