/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.dc.filestore.api.FileStore;
import com.atlassian.dc.filestore.api.compat.FilesystemAccess;
import com.atlassian.dc.filestore.api.compat.FilesystemPath;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.attachment.AttachmentAdapterImpl;
import com.atlassian.jira.issue.attachment.AttachmentCleanupException;
import com.atlassian.jira.issue.attachment.AttachmentReadException;
import com.atlassian.jira.issue.attachment.AttachmentStore;
import com.atlassian.jira.issue.attachment.StreamAttachmentStore;
import com.atlassian.jira.issue.attachment.ThumbnailAccessor;
import io.atlassian.util.concurrent.Promise;
import io.atlassian.util.concurrent.Promises;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.io.FileUtils;

@ParametersAreNonnullByDefault
public class DefaultThumbnailAccessor
implements ThumbnailAccessor {
    @VisibleForTesting
    public static final String THUMBNAIL_DESIGNATION = "_thumb_";
    private final StreamAttachmentStore streamAttachmentStore;

    public DefaultThumbnailAccessor(StreamAttachmentStore streamAttachmentStore) {
        this.streamAttachmentStore = Objects.requireNonNull(streamAttachmentStore);
    }

    private static FileStore.Path getThumbnailFilePath(Attachment attachment, FileStore.Path thumbnailContainer) {
        return thumbnailContainer.path(new String[]{THUMBNAIL_DESIGNATION + attachment.getId() + ".png"});
    }

    private static File getLegacyThumbnailFile(AttachmentStore.AttachmentAdapter attachment, File attachmentDirectory) {
        return new File(attachmentDirectory, attachment.getId() + THUMBNAIL_DESIGNATION + attachment.getFilename());
    }

    @Override
    @Nonnull
    public FileStore.Path getThumbnailFilePath(Attachment attachment) {
        return this.getThumbnailFilePath(attachment.getIssueObject(), attachment);
    }

    @Override
    @Nonnull
    public FileStore.Path getThumbnailFilePath(Issue issue, Attachment attachment) {
        FileStore.Path thumbPath = this.getThumbnailContainer(issue).orElseThrow(() -> new AttachmentReadException("Attachments disabled or issue is missing project key"));
        return DefaultThumbnailAccessor.getThumbnailFilePath(attachment, thumbPath);
    }

    @Nonnull
    private Optional<FileStore.Path> getThumbnailContainer(Issue issue) {
        return this.streamAttachmentStore.getAttachmentPathForIssue(issue).map(attachmentPath -> attachmentPath.path(new String[]{"thumbs"}));
    }

    @Override
    public File getLegacyThumbnailFile(@Nonnull Attachment attachment) {
        AttachmentAdapterImpl attachmentAdapter = AttachmentAdapterImpl.fromAttachment(attachment);
        Optional<FileStore.Path> thumbnailPath = this.getThumbnailContainer(attachment.getIssueObject());
        return thumbnailPath.filter(FilesystemPath.class::isInstance).map(FilesystemPath.class::cast).map(FilesystemAccess::asJavaFile).map(thumbDir -> DefaultThumbnailAccessor.getLegacyThumbnailFile(attachmentAdapter, thumbDir)).orElseThrow(() -> new AttachmentReadException("Only filesystem paths are supported"));
    }

    @Override
    public Promise<Void> deleteThumbnailDirectory(@Nonnull Issue issue) {
        return this.getThumbnailContainer(issue).filter(FilesystemPath.class::isInstance).map(FilesystemPath.class::cast).map(FilesystemAccess::asJavaFile).map(thumbnailDirectory -> {
            try {
                FileUtils.deleteDirectory((File)thumbnailDirectory);
            }
            catch (IOException | IllegalArgumentException e) {
                return Promises.rejected((Throwable)new AttachmentCleanupException((Throwable)e));
            }
            return Promises.promise(null);
        }).orElse(Promises.rejected((Throwable)new AttachmentCleanupException("Invalid thumbnail path for issue " + issue.getKey())));
    }
}

