/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment.store;

import com.atlassian.core.util.FileUtils;
import com.atlassian.jira.issue.attachment.AttachmentWriteException;
import com.atlassian.jira.issue.attachment.TemporaryAttachmentId;
import com.atlassian.jira.issue.attachment.store.LocalTemporaryFileStore;
import com.atlassian.jira.issue.attachment.store.NotEnoughDataIOException;
import com.atlassian.jira.issue.attachment.store.PathTraversalChecker;
import com.atlassian.jira.util.LimitedOutputStream;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Unit;
import io.atlassian.util.concurrent.Promise;
import io.atlassian.util.concurrent.Promises;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import org.apache.commons.compress.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLocalTemporaryFileStore
implements LocalTemporaryFileStore {
    private static final Logger log = LoggerFactory.getLogger(DefaultLocalTemporaryFileStore.class);
    private static final String PREFIX = "temp";
    private static final String SUFFIX = "";
    private final File temporaryDirectory;
    private final PathTraversalChecker pathTraversalChecker;

    public DefaultLocalTemporaryFileStore(File rootTemporaryDirectory, PathTraversalChecker pathTraversalChecker) {
        this.temporaryDirectory = rootTemporaryDirectory;
        this.pathTraversalChecker = pathTraversalChecker;
    }

    @Override
    public TemporaryAttachmentId createTemporaryFile(@Nonnull InputStream inputStream) {
        return this.copyStreamToFile(inputStream, (Option<Long>)Option.none());
    }

    @Override
    public TemporaryAttachmentId createTemporaryFile(@Nonnull InputStream inputStream, long size) {
        return this.copyStreamToFile(inputStream, (Option<Long>)Option.some((Object)size));
    }

    private TemporaryAttachmentId copyStreamToFile(InputStream inputStream, Option<Long> optionalSize) {
        try {
            File tempFile = File.createTempFile(PREFIX, SUFFIX, this.temporaryDirectory);
            TemporaryAttachmentId temporaryAttachmentId = this.copyStreamToFileWithCleanupOnFail(inputStream, tempFile, optionalSize);
            return temporaryAttachmentId;
        }
        catch (Exception e) {
            throw new AttachmentWriteException("Could not save attachment data from stream.", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)inputStream);
        }
    }

    private TemporaryAttachmentId copyStreamToFileWithCleanupOnFail(InputStream inputStream, File temporaryFile, Option<Long> optionalSize) throws Exception {
        try {
            this.copyStreamToFile(inputStream, temporaryFile, optionalSize);
            String temporaryFileId = temporaryFile.getName();
            return TemporaryAttachmentId.fromString((String)temporaryFileId);
        }
        catch (Exception e) {
            this.deleteTemporaryFile(temporaryFile);
            throw e;
        }
    }

    private void copyStreamToFile(InputStream inputStream, File temporaryFile, Option<Long> optionalSize) throws IOException {
        if (optionalSize.isDefined()) {
            this.copyStreamToFileWithSizeCheck(inputStream, temporaryFile, (Long)optionalSize.get());
        } else {
            FileUtils.copyFile((InputStream)inputStream, (File)temporaryFile, (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyStreamToFileWithSizeCheck(InputStream inputStream, File temporaryFile, long size) throws IOException {
        LimitedOutputStream limitedOutputStream = this.getLimitedOutputStreamToFile(temporaryFile, size);
        try {
            IOUtils.copy((InputStream)inputStream, (OutputStream)limitedOutputStream);
        }
        finally {
            IOUtils.closeQuietly((Closeable)inputStream);
            IOUtils.closeQuietly((Closeable)limitedOutputStream);
        }
        this.checkFileNotSmallerThanExpected(temporaryFile, size);
    }

    private LimitedOutputStream getLimitedOutputStreamToFile(File temporaryFile, long size) throws FileNotFoundException {
        FileOutputStream fileOutputStream = new FileOutputStream(temporaryFile, true);
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            return new LimitedOutputStream(bufferedOutputStream, size);
        }
        catch (RuntimeException e) {
            IOUtils.closeQuietly((Closeable)fileOutputStream);
            throw e;
        }
    }

    private void checkFileNotSmallerThanExpected(File temporaryFile, long expectedSize) {
        long fileSize = temporaryFile.length();
        if (fileSize < expectedSize) {
            throw new NotEnoughDataIOException("Expected to get {" + expectedSize + "} of data, but got only {" + fileSize + "}");
        }
    }

    private File getTempFileById(String temporaryAttachmentId) {
        return new File(this.temporaryDirectory, temporaryAttachmentId);
    }

    @Override
    public Either<Exception, File> getTemporaryAttachmentFile(TemporaryAttachmentId temporaryAttachmentId) {
        String tempId = temporaryAttachmentId.toStringId();
        File tempFileById = this.getTempFileById(tempId);
        return (Either)this.pathTraversalChecker.validateFileInSecureDirectory(tempFileById, this.temporaryDirectory).fold(() -> Either.right((Object)tempFileById), Either::left);
    }

    @Override
    public Promise<Unit> deleteTemporaryAttachment(TemporaryAttachmentId temporaryAttachmentId) {
        String tempId = temporaryAttachmentId.toStringId();
        File temporaryAttachmentFile = new File(this.temporaryDirectory, tempId);
        Option<Exception> exception = this.pathTraversalChecker.validateFileInSecureDirectory(temporaryAttachmentFile, this.temporaryDirectory);
        if (exception.isDefined()) {
            return Promises.rejected((Throwable)((Throwable)exception.get()));
        }
        if (temporaryAttachmentFile.exists()) {
            this.deleteTemporaryFile(temporaryAttachmentFile);
        }
        return Promises.promise((Object)Unit.VALUE);
    }

    private void deleteTemporaryFile(File temporaryAttachmentFile) {
        if (!temporaryAttachmentFile.delete()) {
            log.info("Failed to delete temporary attachment: {}", (Object)temporaryAttachmentFile.getAbsolutePath());
        }
    }
}

