/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.changehistory;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.entity.property.JsonEntityPropertyManager;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.changehistory.ChangeHistory;
import com.atlassian.jira.issue.changehistory.ChangeHistoryBatch;
import com.atlassian.jira.issue.changehistory.ChangeHistoryItem;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ComponentLocator;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.query.Query;
import com.atlassian.query.order.SortOrder;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityFieldMap;
import org.ofbiz.core.entity.EntityFindOptions;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultChangeHistoryManager
implements ChangeHistoryManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultChangeHistoryManager.class);
    private final IssueManager issueManager;
    private final OfBizDelegator ofBizDelegator;
    private final PermissionManager permissionManager;
    private final ComponentLocator componentLocator;
    private final UserManager userManager;
    private final JsonEntityPropertyManager jsonEntityPropertyManager;
    private static final String ISSUE_GV = "issue";
    private static final String CREATED_GV = "created";
    private static final String FIELD_GV = "field";
    private static final String OLD_STRING_GV = "oldstring";
    private static final String OLD_VALUE_GV = "oldvalue";
    private static final String NEW_STRING_GV = "newstring";
    private static final String NEW_VALUE_GV = "newvalue";
    private static final String ISSUEID_FIELD = "issueid";
    private static final List<String> FIELDS_TO_SELECT = ImmutableList.of((Object)"issueid");
    public static final String HISTORY_METADATA_KEY = "history_metadata";

    public DefaultChangeHistoryManager(IssueManager issueManager, OfBizDelegator ofBizDelegator, PermissionManager permissionManager, ComponentLocator componentLocator, UserManager userManager, JsonEntityPropertyManager jsonEntityPropertyManager) {
        this.issueManager = issueManager;
        this.userManager = userManager;
        this.ofBizDelegator = ofBizDelegator;
        this.permissionManager = permissionManager;
        this.componentLocator = componentLocator;
        this.jsonEntityPropertyManager = jsonEntityPropertyManager;
    }

    @Nullable
    public ChangeHistory getChangeHistoryById(Long changeGroupId) {
        Assertions.notNull((String)"changeGroupId", (Object)changeGroupId);
        GenericValue changeHistoryGV = this.ofBizDelegator.findById("ChangeGroup", changeGroupId);
        return changeHistoryGV == null ? null : new ChangeHistory(changeHistoryGV, this.issueManager, this.userManager);
    }

    public List<ChangeHistory> getChangeHistories(Issue issue) {
        return this.getAllChangeHistories((Iterable<Issue>)ImmutableList.of((Object)issue));
    }

    @Nonnull
    public List<ChangeHistory> getChangeHistoriesSince(@Nonnull Issue issue, @Nonnull Date since) {
        Assertions.notNull((String)ISSUE_GV, (Object)issue);
        Assertions.notNull((String)"since", (Object)since);
        EntityExpr issueCondition = new EntityExpr(ISSUE_GV, EntityOperator.EQUALS, (Object)issue.getId());
        EntityExpr dateCondition = new EntityExpr(CREATED_GV, EntityOperator.GREATER_THAN, (Object)new Timestamp(since.getTime()));
        EntityConditionList finalCondition = new EntityConditionList(Arrays.asList(issueCondition, dateCondition), EntityOperator.AND);
        List changeHistoriesSinceDate = this.ofBizDelegator.findByCondition("ChangeGroup", (EntityCondition)finalCondition, null, (List)ImmutableList.of((Object)"created DESC", (Object)"id ASC"));
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)changeHistoriesSinceDate, (Function)new Function<GenericValue, ChangeHistory>(){

            public ChangeHistory apply(@Nullable GenericValue genericValue) {
                return genericValue != null ? new ChangeHistory(genericValue, DefaultChangeHistoryManager.this.issueManager, DefaultChangeHistoryManager.this.userManager) : null;
            }
        }));
    }

    public List<ChangeHistory> getChangeHistoriesForUser(Issue issue, ApplicationUser remoteUser) {
        return this.getAllChangeHistories(Collections.singletonList(issue));
    }

    public List<ChangeHistory> getChangeHistoriesForUser(Iterable<Issue> issues, ApplicationUser remoteUser) {
        return this.getAllChangeHistories(issues);
    }

    public List<ChangeHistory> getChangeHistoriesForUser(Iterable<Issue> issues, ApplicationUser remoteUser, Integer limit) {
        return this.getAllChangeHistories(issues, limit);
    }

    private List<ChangeHistory> getAllChangeHistories(Iterable<Issue> issues, Integer limit) {
        Objects.requireNonNull(issues, "issues");
        return ChangeHistoryBatch.createBatchForIssue(issues, this.ofBizDelegator, this.issueManager, this.userManager, limit).asList();
    }

    private List<ChangeHistory> getAllChangeHistories(Iterable<Issue> issues) {
        Objects.requireNonNull(issues, "issues");
        return ChangeHistoryBatch.createBatchForIssue(issues, this.ofBizDelegator, this.issueManager, this.userManager, null).asList();
    }

    public List<ChangeHistory> getChangeItemsWithFieldsForIssues(Iterable<Issue> issues, Iterable<String> fieldNames) {
        Assertions.notNull(issues);
        return ChangeHistoryBatch.createBatchForIssues(issues, this.ofBizDelegator, this.issueManager, this.userManager, fieldNames).asList();
    }

    public List<ChangeItemBean> getChangeItemsForField(Issue issue, String changeItemFieldName) {
        Assertions.notNull((String)ISSUE_GV, (Object)issue);
        Assertions.notBlank((String)"changeItemFieldName", (String)changeItemFieldName);
        return this.getChangeItemsForFieldSinceDate(issue, changeItemFieldName, null);
    }

    @Nonnull
    public List<ChangeItemBean> getChangeItemsForField(@Nonnull Issue issue, String changeItemFieldName, @Nonnull Date since) {
        Assertions.notBlank((String)"changeItemFieldName", (String)changeItemFieldName);
        Assertions.notNull((String)"since", (Object)since);
        return this.getChangeItemsForFieldSinceDate(issue, changeItemFieldName, since);
    }

    public List<ChangeHistoryItem> getAllChangeItems(Issue issue) {
        Assertions.notNull((String)ISSUE_GV, (Object)issue);
        Project project = issue.getProjectObject();
        if (issue.getId() == null || project == null) {
            return Collections.emptyList();
        }
        List changeItemsGVs = this.ofBizDelegator.findByAnd("ChangeGroupChangeItemView", (Map)ImmutableMap.of((Object)ISSUE_GV, (Object)issue.getId()), (List)ImmutableList.of((Object)"created ASC", (Object)"changeitemid ASC"));
        HashMap fieldsPerChangeGroup = Maps.newHashMap();
        ArrayList builders = Lists.newArrayList();
        for (GenericValue changeItemGV : changeItemsGVs) {
            ChangeHistoryItem.Builder builder;
            Long changeGroupId = changeItemGV.getLong("changegroupid");
            String fieldName = changeItemGV.getString(FIELD_GV);
            HashMap<String, ChangeHistoryItem.Builder> buildersPerField = (HashMap<String, ChangeHistoryItem.Builder>)fieldsPerChangeGroup.get(changeGroupId);
            if (buildersPerField == null) {
                buildersPerField = new HashMap<String, ChangeHistoryItem.Builder>();
                fieldsPerChangeGroup.put(changeGroupId, buildersPerField);
            }
            if (buildersPerField.containsKey(fieldName)) {
                builder = (ChangeHistoryItem.Builder)buildersPerField.get(fieldName);
                builder.changedFrom(changeItemGV.getString(OLD_STRING_GV), changeItemGV.getString(OLD_VALUE_GV));
                builder.to(changeItemGV.getString(NEW_STRING_GV), changeItemGV.getString(NEW_VALUE_GV));
                continue;
            }
            builder = new ChangeHistoryItem.Builder().withId(changeItemGV.getLong("changeitemid")).inChangeGroup(changeGroupId).inProject(project.getId()).forIssue(issue.getId(), issue.getKey()).field(changeItemGV.getString(FIELD_GV)).on(changeItemGV.getTimestamp(CREATED_GV)).changedFrom(changeItemGV.getString(OLD_STRING_GV), changeItemGV.getString(OLD_VALUE_GV)).to(changeItemGV.getString(NEW_STRING_GV), changeItemGV.getString(NEW_VALUE_GV)).byUser(changeItemGV.getString("author"));
            buildersPerField.put(fieldName, builder);
            builders.add(builder);
        }
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)builders, (Function)new Function<ChangeHistoryItem.Builder, ChangeHistoryItem>(){

            public ChangeHistoryItem apply(ChangeHistoryItem.Builder builder) {
                return builder.build();
            }
        }));
    }

    public Collection<String> getPreviousIssueKeys(Long issueId) {
        Set issueKeys = this.issueManager.getAllIssueKeys(issueId);
        MutableIssue issue = this.issueManager.getIssueObject(issueId);
        return ImmutableSet.copyOf((Iterable)Iterables.filter((Iterable)issueKeys, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)issue.getKey()))));
    }

    public Collection<Issue> findUserHistory(ApplicationUser remoteUser, Collection<String> userkeys, int maxResults) {
        Collection projectObjects = this.permissionManager.getProjects(ProjectPermissions.BROWSE_PROJECTS, remoteUser);
        ArrayList<Long> projectIds = new ArrayList<Long>(projectObjects.size());
        for (Project project : projectObjects) {
            projectIds.add(project.getId());
        }
        return this.doFindUserHistory(remoteUser, userkeys, projectIds, maxResults, null);
    }

    public Collection<Issue> findUserHistory(ApplicationUser remoteUser, Collection<String> userkeys, Collection<Project> projects, int maxResults) {
        return this.findUserHistory(remoteUser, userkeys, projects, maxResults, null);
    }

    public Collection<Issue> findUserHistory(ApplicationUser remoteUser, Collection<String> userkeys, Collection<Project> projects, int maxResults, Date oldestUpdateTime) {
        ApplicationUser user = remoteUser;
        ArrayList<Long> filteredProjectIds = new ArrayList<Long>(projects.size());
        for (Project project : projects) {
            if (!this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, project, user)) continue;
            filteredProjectIds.add(project.getId());
        }
        return this.doFindUserHistory(remoteUser, userkeys, filteredProjectIds, maxResults, oldestUpdateTime);
    }

    @Nullable
    private OfBizListIterator getAllChangeItemsContainingValueAndString(String field) {
        EntityExpr condition = new EntityExpr((EntityCondition)new EntityFieldMap((Map)ImmutableMap.of((Object)FIELD_GV, (Object)field), EntityOperator.AND), EntityOperator.AND, (EntityCondition)new EntityConditionList((List)ImmutableList.of((Object)new EntityExpr((EntityCondition)new EntityExpr(OLD_VALUE_GV, EntityOperator.NOT_EQUAL, null), EntityOperator.AND, (EntityCondition)new EntityExpr(OLD_STRING_GV, EntityOperator.NOT_EQUAL, null)), (Object)new EntityExpr((EntityCondition)new EntityExpr(NEW_VALUE_GV, EntityOperator.NOT_EQUAL, null), EntityOperator.AND, (EntityCondition)new EntityExpr(NEW_STRING_GV, EntityOperator.NOT_EQUAL, null))), EntityOperator.OR));
        try {
            return this.ofBizDelegator.findListIteratorByCondition("ChangeItem", (EntityCondition)condition, null, (Collection)ImmutableList.of((Object)OLD_STRING_GV, (Object)OLD_VALUE_GV, (Object)NEW_STRING_GV, (Object)NEW_VALUE_GV), (List)ImmutableList.of((Object)"asc"), null);
        }
        catch (DataAccessException e) {
            log.error("Unable to retrieve values for " + field, (Throwable)e);
            return null;
        }
    }

    public void removeAllChangeItems(Issue issue) {
        ImmutableMap params = ImmutableMap.of((Object)ISSUE_GV, (Object)issue.getId());
        List changeGroups = this.ofBizDelegator.findByAnd("ChangeGroup", (Map)params);
        for (GenericValue changeGroup : changeGroups) {
            Long changeGroupId = changeGroup.getLong("id");
            this.ofBizDelegator.removeByAnd("ChangeItem", (Map)ImmutableMap.of((Object)"group", (Object)changeGroupId));
            this.jsonEntityPropertyManager.deleteByEntity(EntityPropertyType.CHANGE_HISTORY_PROPERTY.getDbEntityName(), changeGroupId);
        }
        this.ofBizDelegator.removeByAnd("ChangeGroup", (Map)params);
    }

    private Map<String, String> collectFieldValues(OfBizListIterator genericValuesIterator) {
        MapBuilder builder = MapBuilder.newBuilder();
        for (GenericValue gv : genericValuesIterator) {
            if (StringUtils.isNotBlank((CharSequence)gv.getString(OLD_STRING_GV)) && StringUtils.isNotBlank((CharSequence)gv.getString(OLD_VALUE_GV))) {
                builder.add((Object)gv.getString(OLD_STRING_GV).toLowerCase(), (Object)gv.getString(OLD_VALUE_GV).toLowerCase());
            }
            if (!StringUtils.isNotBlank((CharSequence)gv.getString(NEW_STRING_GV)) || !StringUtils.isNotBlank((CharSequence)gv.getString(NEW_VALUE_GV))) continue;
            builder.add((Object)gv.getString(NEW_STRING_GV).toLowerCase(), (Object)gv.getString(NEW_VALUE_GV).toLowerCase());
        }
        return builder.toMap();
    }

    Collection<Issue> doFindUserHistory(ApplicationUser remoteUser, Collection<String> userkeys, Collection<Long> projects, int maxResults, Date oldestUpdateTime) {
        SearchResults searchResults;
        if (projects.isEmpty()) {
            return Collections.emptyList();
        }
        JqlClauseBuilder builder = JqlQueryBuilder.newBuilder().where().defaultAnd();
        if (oldestUpdateTime != null) {
            builder.updatedAfter(oldestUpdateTime);
        }
        if (userkeys == null) {
            builder.project().in(projects.toArray(new Long[projects.size()])).endWhere().orderBy().updatedDate(SortOrder.DESC);
        } else {
            Collection<Long> issueIds = this.findMostRecentlyUpdatedIssueIds(maxResults, userkeys, projects, remoteUser);
            if (issueIds.isEmpty()) {
                return Collections.emptyList();
            }
            builder.issue().in(issueIds.toArray(new Long[issueIds.size()])).endWhere().orderBy().updatedDate(SortOrder.DESC);
        }
        Query query = builder.buildQuery();
        SearchService searchService = (SearchService)this.componentLocator.getComponentInstanceOfType(SearchService.class);
        try {
            searchResults = searchService.search(remoteUser, query, new PagerFilter(maxResults));
        }
        catch (SearchException e) {
            log.error("Error running query '" + query + "'");
            return Collections.emptyList();
        }
        List issues = searchResults.getResults();
        Comparator<Issue> comparator = new Comparator<Issue>(){

            @Override
            public int compare(Issue o1, Issue o2) {
                return o1.getCreated().compareTo(o2.getCreated());
            }
        };
        return ImmutableSortedSet.copyOf((Comparator)comparator, (Collection)issues).asList();
    }

    private Collection<Long> findMostRecentlyUpdatedIssueIds(int maxResults, Collection<String> userkeys, Collection<Long> projects, ApplicationUser remoteUser) {
        return this.findMostRecentlyUpdatedIssueIdsByUsers(projects, userkeys, maxResults);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Long> findMostRecentlyUpdatedIssueIdsByUsers(Collection<Long> projects, @Nonnull Collection<String> userkeys, int maxResults) {
        LinkedHashSet<Long> issueIds = new LinkedHashSet<Long>();
        OfBizListIterator changeGroupIssueViewIt = null;
        OfBizListIterator actionIssueViewIt = null;
        try {
            EntityConditionList entityCondition = new EntityConditionList((List)ImmutableList.of((Object)new EntityExpr("project", EntityOperator.IN, projects), (Object)new EntityExpr("author", EntityOperator.IN, userkeys)), EntityOperator.AND);
            EntityFindOptions entityFindOptions = EntityFindOptions.findOptions().maxResults(maxResults);
            changeGroupIssueViewIt = this.ofBizDelegator.findListIteratorByCondition("ChangeGroupIssueView", (EntityCondition)entityCondition, null, FIELDS_TO_SELECT, (List)ImmutableList.of((Object)"created DESC"), entityFindOptions);
            issueIds.addAll(this.extractIssueIds(maxResults, changeGroupIssueViewIt));
            actionIssueViewIt = this.ofBizDelegator.findListIteratorByCondition("ActionIssueView", (EntityCondition)entityCondition, null, FIELDS_TO_SELECT, (List)ImmutableList.of((Object)"created DESC"), entityFindOptions);
            issueIds.addAll(this.extractIssueIds(maxResults, actionIssueViewIt));
            LinkedHashSet<Long> linkedHashSet = issueIds;
            return linkedHashSet;
        }
        finally {
            if (actionIssueViewIt != null) {
                actionIssueViewIt.close();
            }
            if (changeGroupIssueViewIt != null) {
                changeGroupIssueViewIt.close();
            }
        }
    }

    private Set<Long> extractIssueIds(int maxResults, OfBizListIterator iterator) {
        LinkedHashSet<Long> issueIds = new LinkedHashSet<Long>();
        GenericValue issueIdGV = iterator.next();
        for (int issuesLeft = maxResults; issueIdGV != null && issuesLeft > 0; --issuesLeft) {
            issueIds.add(issueIdGV.getLong(ISSUEID_FIELD));
            issueIdGV = iterator.next();
        }
        return issueIds;
    }

    private List<ChangeItemBean> getChangeItemsForFieldSinceDate(Issue issue, String changeItemFieldName, Date since) {
        if (issue.getId() == null) {
            return Collections.emptyList();
        }
        ArrayList<EntityExpr> conditions = new ArrayList<EntityExpr>(Arrays.asList(new EntityExpr(ISSUE_GV, EntityOperator.EQUALS, (Object)issue.getId()), new EntityExpr(FIELD_GV, EntityOperator.EQUALS, (Object)changeItemFieldName)));
        if (since != null) {
            conditions.add(new EntityExpr(CREATED_GV, EntityOperator.GREATER_THAN, (Object)new Timestamp(since.getTime())));
        }
        EntityConditionList finalCondition = new EntityConditionList(conditions, EntityOperator.AND);
        List changeItemsForFieldGVs = this.ofBizDelegator.findByCondition("ChangeGroupChangeItemView", (EntityCondition)finalCondition, null, (List)ImmutableList.of((Object)"created ASC", (Object)"changeitemid ASC"));
        ArrayList<ChangeItemBean> changeItemsForField = new ArrayList<ChangeItemBean>(changeItemsForFieldGVs.size());
        for (GenericValue changeItemGV : changeItemsForFieldGVs) {
            changeItemsForField.add(new ChangeItemBean(changeItemGV.getString("fieldtype"), changeItemGV.getString(FIELD_GV), changeItemGV.getString(OLD_VALUE_GV), changeItemGV.getString(OLD_STRING_GV), changeItemGV.getString(NEW_VALUE_GV), changeItemGV.getString(NEW_STRING_GV), changeItemGV.getTimestamp(CREATED_GV)));
        }
        return changeItemsForField;
    }
}

