/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.manager.xml;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.core.Caching;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AllowlistedXStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(AllowlistedXStream.class);
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Set<String> extensions = new HashSet<String>();
    private final XStream xstream;

    AllowlistedXStream(XStream xstream) {
        this.xstream = xstream;
    }

    Object fromXML(String xml) {
        try {
            this.lock.readLock().lock();
            Object object = this.xstream.fromXML(xml);
            return object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    void extendAllowlist(Set<String> classes) {
        if (classes.isEmpty()) {
            return;
        }
        try {
            this.lock.writeLock().lock();
            Set newExtensions = classes.stream().map(String::trim).filter(cs -> !cs.isEmpty()).filter(cs -> !this.extensions.contains(cs)).collect(Collectors.toCollection(LinkedHashSet::new));
            if (!newExtensions.isEmpty()) {
                this.xstream.allowTypes(newExtensions.toArray(new String[0]));
                this.extensions.addAll(newExtensions);
                if (this.xstream.getMapper() instanceof Caching) {
                    ((Caching)this.xstream.getMapper()).flushCache();
                }
                LOGGER.info("XStream allowlist was extended with:{}- {}", (Object)System.lineSeparator(), (Object)String.join((CharSequence)(System.lineSeparator() + "- "), newExtensions));
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

