/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.manager.xml;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.issue.customfields.manager.xml.AllowlistedXStream;
import com.atlassian.jira.security.serialization.XmlPluginAllowlistProvider;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.event.events.PluginModuleEnabledEvent;
import com.atlassian.plugin.event.events.PluginUpgradedEvent;
import java.util.Collection;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;

public class XStreamAllowlistExtensionListener
implements Startable {
    private final WeakHashMap<AllowlistedXStream, Boolean> instances = new WeakHashMap();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final EventPublisher eventPublisher;

    public XStreamAllowlistExtensionListener(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    void register(AllowlistedXStream instance) {
        this.lock.writeLock().lock();
        try {
            this.instances.put(instance, true);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @EventListener
    public void onPluginUpgraded(PluginUpgradedEvent event) {
        for (AllowlistedXStream xstream : this.getInstances()) {
            xstream.extendAllowlist(event.getPlugin().getModuleDescriptorsByModuleClass(XmlPluginAllowlistProvider.class).stream().map(ModuleDescriptor::getModule).map(XmlPluginAllowlistProvider::getAllowlistedClasses).flatMap(Collection::stream).collect(Collectors.toSet()));
        }
    }

    @EventListener
    public void onModuleEnabled(PluginModuleEnabledEvent event) {
        for (AllowlistedXStream xstream : this.getInstances()) {
            if (!XmlPluginAllowlistProvider.class.isAssignableFrom(event.getModule().getModuleClass())) continue;
            XmlPluginAllowlistProvider provider = (XmlPluginAllowlistProvider)event.getModule().getModule();
            xstream.extendAllowlist(provider.getAllowlistedClasses());
        }
    }

    private Set<AllowlistedXStream> getInstances() {
        this.lock.readLock().lock();
        try {
            Set<AllowlistedXStream> set = this.instances.keySet();
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

