/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.fields.AbstractOrderableField;
import com.atlassian.jira.issue.fields.DateField;
import com.atlassian.jira.issue.fields.HideableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.RestAwareField;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.util.MessagedResult;
import com.atlassian.jira.issue.util.IssueChangeHolder;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.rest.Dates;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.bean.BulkEditBean;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import webwork.action.Action;

public class ArchivedDateSystemField
extends AbstractOrderableField<Date>
implements HideableField,
RestAwareField,
DateField {
    private final DateTimeFormatterFactory dateTimeFormatterFactory;

    public ArchivedDateSystemField(DateTimeFormatterFactory dateTimeFormatterFactory, VelocityTemplatingEngine templatingEngine, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, PermissionManager permissionManager) {
        super("archiveddate", "issue.field.archived.date", templatingEngine, applicationProperties, authenticationContext, permissionManager);
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
    }

    @Override
    protected Object getRelevantParams(Map<String, String[]> params) {
        return null;
    }

    public String getCreateHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map displayParameters) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String getEditHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map displayParameters) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, Map displayParameters) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, Date value, Map displayParameters) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isShown(Issue issue) {
        return issue.isArchived();
    }

    public void populateDefaults(Map<String, Object> fieldValuesHolder, Issue issue) {
    }

    public void populateFromIssue(Map<String, Object> fieldValuesHolder, Issue issue) {
    }

    public void validateParams(OperationContext operationContext, ErrorCollection errorCollectionToAddTo, I18nHelper i18n, Issue issue, FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem) {
    }

    @Nullable
    public Date getDefaultValue(Issue issue) {
        return null;
    }

    public void createValue(Issue issue, Date value) {
    }

    public void updateValue(FieldLayoutItem fieldLayoutItem, Issue issue, ModifiedValue modifiedValue, IssueChangeHolder issueChangeHolder) {
    }

    public void updateIssue(FieldLayoutItem fieldLayoutItem, MutableIssue issue, Map fieldValueHolder) {
    }

    public void removeValueFromIssueObject(MutableIssue issue) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean canRemoveValueFromIssueObject(Issue issue) {
        return false;
    }

    public MessagedResult needsMove(Collection originalIssues, Issue targetIssue, FieldLayoutItem targetFieldLayoutItem) {
        return new MessagedResult(false);
    }

    public void populateForMove(Map<String, Object> fieldValuesHolder, Issue originalIssue, Issue targetIssue) {
    }

    public boolean hasValue(Issue issue) {
        return issue.isArchived();
    }

    public String availableForBulkEdit(BulkEditBean bulkEditBean) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Date getValueFromParams(Map params) throws FieldValidationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void populateParamsFromString(Map<String, Object> fieldValuesHolder, String stringValue, Issue issue) throws FieldValidationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        return new FieldTypeInfo(null, null);
    }

    public JsonType getJsonSchema() {
        return JsonTypeBuilder.system((String)"datetime", (String)"archiveddate");
    }

    public FieldJsonRepresentation getJsonFromIssue(Issue issue, boolean renderedVersionRequested, @Nullable FieldLayoutItem fieldLayoutItem) {
        Date archived = this.getArchivedDate(issue);
        FieldJsonRepresentation fieldJsonRepresentation = new FieldJsonRepresentation(new JsonData((Object)Dates.asTimeString((Date)archived)));
        if (renderedVersionRequested && archived != null) {
            fieldJsonRepresentation.setRenderedData(new JsonData((Object)this.dateTimeFormatterFactory.formatter().forLoggedInUser().format(archived)));
        }
        return fieldJsonRepresentation;
    }

    private Date getArchivedDate(Issue issue) {
        Timestamp archived = issue.getArchivedDate();
        if (archived == null) {
            return Optional.ofNullable(issue.getProjectObject()).map(Project::getArchivedDate).orElse(null);
        }
        return archived;
    }
}

