/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.renderer.comment;

import com.atlassian.jira.issue.fields.renderer.comment.CommentFieldRenderer;
import com.atlassian.jira.plugin.comment.CommentFieldRendererModuleDescriptor;
import com.atlassian.jira.plugin.webfragment.model.CommentHelper;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.web.descriptors.WeightedDescriptor;
import com.atlassian.plugin.web.descriptors.WeightedDescriptorComparator;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Options;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class DefaultCommentFieldRenderer
implements CommentFieldRenderer {
    private final Ordering<CommentFieldRendererModuleDescriptor> commentFieldRendererModuleDescriptorOrdering;
    private final PluginAccessor pluginAccessor;

    public DefaultCommentFieldRenderer(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
        this.commentFieldRendererModuleDescriptorOrdering = Ordering.from((Comparator)new Comparator<CommentFieldRendererModuleDescriptor>(){
            WeightedDescriptorComparator comparator = new WeightedDescriptorComparator();

            @Override
            public int compare(CommentFieldRendererModuleDescriptor moduleDescriptor1, CommentFieldRendererModuleDescriptor moduleDescriptor2) {
                int compareResult = this.comparator.compare((WeightedDescriptor)moduleDescriptor2, (WeightedDescriptor)moduleDescriptor1);
                return compareResult != 0 ? compareResult : moduleDescriptor1.getCompleteKey().compareToIgnoreCase(moduleDescriptor2.getCompleteKey());
            }
        });
    }

    @Override
    public String getIssuePageEditHtml(final Map<String, Object> context, CommentHelper commentHelper) {
        return this.renderCommentFields(new DescriptorToHtmlFunction(){

            public Option<String> apply(CommentFieldRendererModuleDescriptor moduleDescriptor) {
                return moduleDescriptor.getIssuePageEditHtml(context);
            }
        }, commentHelper);
    }

    @Override
    public String getIssuePageViewHtml(final Map<String, Object> context, CommentHelper commentHelper) {
        return this.renderCommentFields(new DescriptorToHtmlFunction(){

            public Option<String> apply(CommentFieldRendererModuleDescriptor moduleDescriptor) {
                return moduleDescriptor.getIssuePageViewHtml(context);
            }
        }, commentHelper);
    }

    @Override
    public String getFieldEditHtml(final Map<String, Object> context, CommentHelper commentHelper) {
        return this.renderCommentFields(new DescriptorToHtmlFunction(){

            public Option<String> apply(CommentFieldRendererModuleDescriptor moduleDescriptor) {
                return moduleDescriptor.getFieldEditHtml(context);
            }
        }, commentHelper);
    }

    @Override
    public String getFieldViewHtml(final Map<String, Object> context, CommentHelper commentHelper) {
        return this.renderCommentFields(new DescriptorToHtmlFunction(){

            public Option<String> apply(CommentFieldRendererModuleDescriptor moduleDescriptor) {
                return moduleDescriptor.getFieldViewHtml(context);
            }
        }, commentHelper);
    }

    @Override
    public String getHeaderViewHtml(Map<String, Object> context, CommentHelper commentHelper) {
        return this.renderCommentFields(moduleDescriptor -> moduleDescriptor.getHeaderViewHtml(context), commentHelper);
    }

    private String renderCommentFields(DescriptorToHtmlFunction descriptorToHtmlFunction, final CommentHelper commentHelper) {
        List descriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(CommentFieldRendererModuleDescriptor.class);
        List descriptorsOrderedByWeight = this.commentFieldRendererModuleDescriptorOrdering.sortedCopy((Iterable)descriptors);
        Option commentFieldToRender = (Option)Iterables.getFirst((Iterable)Options.filterNone((Iterable)descriptorsOrderedByWeight.stream().filter(SafePluginPointAccess.safe((Predicate)new com.google.common.base.Predicate<CommentFieldRendererModuleDescriptor>(){

            public boolean apply(CommentFieldRendererModuleDescriptor moduleDescriptor) {
                return moduleDescriptor.getCondition() == null || moduleDescriptor.getCondition().shouldDisplay(commentHelper.getContextParams());
            }
        })).map(SafePluginPointAccess.safe((java.util.function.Function)((Object)descriptorToHtmlFunction))).collect(Collectors.toList())), (Object)Option.none());
        return (String)commentFieldToRender.getOrError((Supplier)new Supplier<String>(){

            @Override
            public String get() {
                throw new IllegalStateException("There should be at least one comment field renderer, which can render the comments");
            }
        });
    }

    private static interface DescriptorToHtmlFunction
    extends Function<CommentFieldRendererModuleDescriptor, Option<String>> {
    }
}

