/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.renderer.wiki.embedded;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.attachments.RendererAttachment;
import com.atlassian.renderer.attachments.RendererAttachmentManager;
import com.atlassian.renderer.embedded.EmbeddedImage;
import com.atlassian.renderer.embedded.EmbeddedImageRenderer;
import com.atlassian.renderer.embedded.EmbeddedResource;
import java.util.Map;

public class JiraEmbeddedImageRenderer
extends EmbeddedImageRenderer {
    public JiraEmbeddedImageRenderer(RendererAttachmentManager attachmentManager) {
        super(attachmentManager);
    }

    protected String writeImage(String imageTag, Map<Object, Object> imageParams, RenderContext context, EmbeddedResource resource) {
        EmbeddedImage image = (EmbeddedImage)resource;
        boolean isThumbNail = image.isThumbNail();
        if (isThumbNail && !image.isExternal()) {
            try {
                RendererAttachment attachment = this.getAttachment(context, resource);
                long attachmentId = attachment.getId();
                String attachmentSrc = attachment.getSrc();
                String attachmentName = attachment.getFileName();
                String wrappedImageTag = "<a id=\"" + attachmentId + "_thumb\" href=\"" + attachmentSrc + "\" title=\"" + attachmentName + "\" file-preview-type=\"image\" file-preview-id=\"" + attachmentId + "\" file-preview-title=\"" + attachmentName + "\">" + imageTag + "</a>";
                return super.writeImage(wrappedImageTag, imageParams, context, resource);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return super.writeImage(imageTag, imageParams, context, resource);
    }
}

