/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.renderer.wiki.embedded;

import com.atlassian.jira.issue.attachment.TemporaryWebAttachment;
import com.atlassian.jira.issue.attachment.TemporaryWebAttachmentManager;
import com.atlassian.jira.issue.fields.renderer.wiki.embedded.ConditionalEmbeddedRenderer;
import com.atlassian.jira.util.URLCodec;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.attachments.RendererAttachmentManager;
import com.atlassian.renderer.embedded.EmbeddedImage;
import com.atlassian.renderer.embedded.EmbeddedImageRenderer;
import com.atlassian.renderer.embedded.EmbeddedResource;
import com.atlassian.renderer.v2.RenderUtils;
import com.atlassian.renderer.v2.components.HtmlEscaper;
import com.atlassian.renderer.v2.macro.basic.validator.MacroParameterValidationException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import org.joda.time.ReadableInstant;

public class JiraTemporaryAttachmentRenderer
extends EmbeddedImageRenderer
implements ConditionalEmbeddedRenderer {
    private final TemporaryWebAttachmentManager temporaryWebAttachmentManager;

    public JiraTemporaryAttachmentRenderer(RendererAttachmentManager attachmentManager, TemporaryWebAttachmentManager temporaryWebAttachmentManager) {
        super(attachmentManager);
        this.temporaryWebAttachmentManager = temporaryWebAttachmentManager;
    }

    public String renderResource(EmbeddedResource resource, RenderContext context) {
        EmbeddedImage image = (EmbeddedImage)resource;
        Optional<TemporaryWebAttachment> attachment = this.getTemporaryAttachment(resource, context);
        return this.renderTemporaryAttachment(image, context, attachment);
    }

    private String renderTemporaryAttachment(EmbeddedImage image, RenderContext context, Optional<TemporaryWebAttachment> temporaryWebAttachmentOptional) {
        String encodedFilename;
        String encodedAttachmentId;
        String encodedFormToken;
        if (!temporaryWebAttachmentOptional.isPresent()) {
            return null;
        }
        TemporaryWebAttachment temporaryWebAttachment = temporaryWebAttachmentOptional.get();
        HashMap<Object, Object> imageParams = new HashMap<Object, Object>(image.getProperties());
        if (image.isThumbNail()) {
            imageParams.put("class", "thumbnail");
        }
        String formToken = (String)context.getParam((Object)"atlassian-renderer-form-token");
        try {
            encodedFormToken = URLCodec.encode((String)formToken, (String)context.getCharacterEncoding());
            encodedAttachmentId = URLCodec.encode((String)temporaryWebAttachment.getTemporaryAttachmentId().toStringId(), (String)context.getCharacterEncoding());
            encodedFilename = URLCodec.encode((String)image.getFilename(), (String)context.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException uee) {
            encodedFormToken = "";
            encodedAttachmentId = "";
            encodedFilename = "";
        }
        StringBuilder imageUrl = new StringBuilder().append(context.getSiteRoot()).append("/secure/temporaryattachment/").append(encodedFormToken).append("/").append(encodedAttachmentId).append("_").append(encodedFilename);
        try {
            return context.addRenderedContent((Object)this.writeImage("<img src=\"" + HtmlEscaper.escapeAll((String)imageUrl.toString(), (boolean)true) + "\" " + this.outputParameters(imageParams) + "/>", imageParams, context, (EmbeddedResource)image));
        }
        catch (MacroParameterValidationException ex) {
            return context.addRenderedContent((Object)RenderUtils.error((String)ex.getMessage()));
        }
    }

    @Override
    public boolean shouldRenderResource(EmbeddedResource resource, RenderContext context) {
        if (!(resource instanceof EmbeddedImage)) {
            return false;
        }
        EmbeddedImage image = (EmbeddedImage)resource;
        if (image.isInternal()) {
            Optional<TemporaryWebAttachment> temporaryAttachment = this.getTemporaryAttachment(resource, context);
            return temporaryAttachment.isPresent();
        }
        return false;
    }

    private Optional<TemporaryWebAttachment> getTemporaryAttachment(EmbeddedResource resource, RenderContext context) {
        String formToken = (String)context.getParam((Object)"atlassian-renderer-form-token");
        if (Objects.nonNull(formToken)) {
            return this.temporaryWebAttachmentManager.getTemporaryWebAttachmentsByFormToken(formToken).stream().filter(attachment -> Objects.equals(attachment.getFilename(), resource.getFilename())).sorted((first, second) -> second.getCreated().compareTo((ReadableInstant)first.getCreated())).findFirst();
        }
        return Optional.empty();
    }
}

