/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.renderer.wiki.links;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.jira.util.URLCodec;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.links.BaseLink;
import com.atlassian.renderer.links.GenericLinkParser;
import com.opensymphony.util.TextUtils;
import java.io.UnsupportedEncodingException;

public class JiraUserProfileLink
extends BaseLink {
    private ApplicationUser user;
    private String username;

    public JiraUserProfileLink(GenericLinkParser parser, RenderContext context, boolean showFullName) {
        super(parser);
        if (TextUtils.stringSet((String)parser.getNotLinkBody()) && parser.getNotLinkBody().startsWith("~")) {
            try {
                this.username = parser.getNotLinkBody().substring(1);
                this.user = UserUtils.getUser((String)this.username);
                this.linkBody = this.user != null && this.user.getDisplayName() != null && showFullName ? this.user.getDisplayName() : this.username;
                this.url = this.buildProfileUrl(context, this.username);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getLinkAttributes() {
        if (this.user != null) {
            return super.getLinkAttributes() + " class=\"user-hover\" rel=\"" + TextUtils.htmlEncode((String)this.user.getName()) + "\"";
        }
        return super.getLinkAttributes() + " class=\"user-hover\" rel=\"" + TextUtils.htmlEncode((String)this.username) + "\"";
    }

    private String buildProfileUrl(RenderContext context, String username) throws UnsupportedEncodingException {
        String encodedUsername = URLCodec.encode((String)username, (String)context.getCharacterEncoding());
        return context.getBaseUrl() + "/secure/ViewProfile.jspa?name=" + encodedUsername;
    }

    public ApplicationUser getUser() {
        return this.user;
    }
}

