/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.renderer.wiki.resolvers;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.fields.renderer.wiki.links.JiraUserProfileLink;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.links.ContentLinkResolver;
import com.atlassian.renderer.links.GenericLinkParser;
import com.atlassian.renderer.links.Link;
import com.atlassian.renderer.links.UnresolvedLink;
import java.text.ParseException;

public class UserProfileLinkResolver
implements ContentLinkResolver {
    private final JiraAuthenticationContext jiraAuthenticationContext = ComponentAccessor.getJiraAuthenticationContext();
    private final GlobalPermissionManager globalPermissionManager = ComponentAccessor.getGlobalPermissionManager();

    public Link createContentLink(RenderContext context, GenericLinkParser parser) throws ParseException {
        if (parser.getNotLinkBody().startsWith("~")) {
            Object forceFullUsername = context.getParam((Object)"atlassian-renderer-mentions-full-usernames");
            ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
            if (forceFullUsername instanceof Boolean && ((Boolean)forceFullUsername).booleanValue() || this.globalPermissionManager.hasPermission(GlobalPermissionKey.USER_PICKER, user)) {
                JiraUserProfileLink profileLink = new JiraUserProfileLink(parser, context, true);
                if (profileLink.getUser() == null) {
                    return new UnresolvedLink(parser.getOriginalLinkText());
                }
                return profileLink;
            }
            return new JiraUserProfileLink(parser, context, user != null);
        }
        return null;
    }
}

