/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.screen.analytics;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.issue.field.screen.AbstractFieldScreenFieldEvent;
import com.atlassian.jira.event.issue.field.screen.AbstractFieldScreenTabEvent;
import com.atlassian.jira.event.issue.field.screen.FieldScreenFieldAddedEvent;
import com.atlassian.jira.event.issue.field.screen.FieldScreenFieldMovedEvent;
import com.atlassian.jira.event.issue.field.screen.FieldScreenFieldRemovedEvent;
import com.atlassian.jira.event.issue.field.screen.FieldScreenFieldShownWhenEmptyEvent;
import com.atlassian.jira.event.issue.field.screen.FieldScreenTabAddedEvent;
import com.atlassian.jira.event.issue.field.screen.FieldScreenTabMovedEvent;
import com.atlassian.jira.event.issue.field.screen.FieldScreenTabRemovedEvent;
import com.atlassian.jira.event.issue.field.screen.FieldScreenTabRenamedEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.issue.fields.screen.ProjectFieldScreenHelper;
import com.atlassian.jira.issue.fields.screen.analytics.ScreenFieldEditingEvent;
import com.atlassian.jira.issue.fields.screen.analytics.ScreenTabEditingEvent;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.ProjectPermissionHelper;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import java.util.List;

public class ScreenAnalytics
implements Startable {
    private final EventPublisher eventPublisher;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final ProjectFieldScreenHelper projectFieldScreenHelper;
    private final GlobalPermissionManager permissionManager;
    private final ProjectPermissionHelper projectPermissionHelper;

    public ScreenAnalytics(EventPublisher eventPublisher, JiraAuthenticationContext jiraAuthenticationContext, ProjectFieldScreenHelper projectFieldScreenHelper, GlobalPermissionManager permissionManager, ProjectPermissionHelper projectPermissionHelper) {
        this.eventPublisher = eventPublisher;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.projectFieldScreenHelper = projectFieldScreenHelper;
        this.permissionManager = permissionManager;
        this.projectPermissionHelper = projectPermissionHelper;
    }

    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onFieldScreenFieldAddedEvent(FieldScreenFieldAddedEvent event) {
        this.publishFieldAnalytics(event, ScreenFieldEditingEvent.Type.ADD);
    }

    @EventListener
    public void onFieldScreenFieldMovedEvent(FieldScreenFieldMovedEvent event) {
        this.publishFieldAnalytics(event, ScreenFieldEditingEvent.Type.MOVE);
    }

    @EventListener
    public void onFieldScreenFieldRemovedEvent(FieldScreenFieldRemovedEvent event) {
        this.publishFieldAnalytics(event, ScreenFieldEditingEvent.Type.REMOVE);
    }

    @EventListener
    public void onFieldScreenTabAddedEvent(FieldScreenTabAddedEvent event) {
        this.publishTabAnalytics(event, ScreenTabEditingEvent.Type.ADD);
    }

    @EventListener
    public void onFieldScreenTabMovedEvent(FieldScreenTabMovedEvent event) {
        this.publishTabAnalytics(event, ScreenTabEditingEvent.Type.MOVE);
    }

    @EventListener
    public void onFieldScreenTabRemovedEvent(FieldScreenTabRemovedEvent event) {
        this.publishTabAnalytics(event, ScreenTabEditingEvent.Type.REMOVE);
    }

    @EventListener
    public void onFieldScreenTabRenamedEvent(FieldScreenTabRenamedEvent event) {
        this.publishTabAnalytics(event, ScreenTabEditingEvent.Type.RENAME);
    }

    @EventListener
    public void onFieldScreenFieldShownWhenEmptyEvent(FieldScreenFieldShownWhenEmptyEvent event) {
        this.publishFieldAnalytics(event, ScreenFieldEditingEvent.Type.MARK_AS_SHOWN_WHEN_EMPTY);
    }

    private void publishFieldAnalytics(AbstractFieldScreenFieldEvent event, ScreenFieldEditingEvent.Type type) {
        List<Project> allProjectsForFieldScreen = this.projectFieldScreenHelper.getAllProjectsForFieldScreen(event.getTab().getFieldScreen());
        this.eventPublisher.publish((Object)new ScreenFieldEditingEvent(event.getTab(), this.isGlobalAdmin(), Long.valueOf(allProjectsForFieldScreen.size()), allProjectsForFieldScreen.size() == 1 ? allProjectsForFieldScreen.get(0).getId() : null, event.getAffectedField(), type, this.projectPermissionHelper.hasExtPermission(allProjectsForFieldScreen)));
    }

    private void publishTabAnalytics(AbstractFieldScreenTabEvent event, ScreenTabEditingEvent.Type type) {
        List<Project> allProjectsForFieldScreen = this.projectFieldScreenHelper.getAllProjectsForFieldScreen(event.getTab().getFieldScreen());
        this.eventPublisher.publish((Object)new ScreenTabEditingEvent(event.getTab(), this.isGlobalAdmin(), Long.valueOf(allProjectsForFieldScreen.size()), allProjectsForFieldScreen.size() == 1 ? allProjectsForFieldScreen.get(0).getId() : null, type, this.projectPermissionHelper.hasExtPermission(allProjectsForFieldScreen)));
    }

    private boolean isGlobalAdmin() {
        return this.permissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, this.jiraAuthenticationContext.getLoggedInUser());
    }
}

