/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.usage;

import com.atlassian.jira.issue.fields.usage.IssueEventProcessingStatsLogger;
import com.atlassian.jira.util.stats.MutableLongStats;
import com.google.common.base.Stopwatch;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIssueEventProcessingStatsLogger
implements IssueEventProcessingStatsLogger {
    public static final IssueEventProcessingStatsLogger NOOP = new NoopLogger();
    private static final long STATS_PERIOD_MILLIS = TimeUnit.MINUTES.toMillis(5L);
    private static final Logger log = LoggerFactory.getLogger(DefaultIssueEventProcessingStatsLogger.class);
    private final Stopwatch lastPrintStats = Stopwatch.createStarted();
    private final Map<String, IssueEventProcessingStats> loggedStats = new ConcurrentHashMap<String, IssueEventProcessingStats>();
    private final String statsGroupName;

    public DefaultIssueEventProcessingStatsLogger(String statsGroupName) {
        this.statsGroupName = statsGroupName;
    }

    @Override
    public void wrap(String name, Runnable op) {
        this.loggedStats.computeIfAbsent(name, IssueEventProcessingStats::new).wrap(op);
        this.printStatsNotToOften();
    }

    @Override
    public <T> T wrap(String name, Supplier<T> op) {
        T result = this.loggedStats.computeIfAbsent(name, IssueEventProcessingStats::new).wrap(op);
        this.printStatsNotToOften();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void printStatsNotToOften() {
        if (!this.canPrintStats()) return;
        Class<DefaultIssueEventProcessingStatsLogger> clazz = DefaultIssueEventProcessingStatsLogger.class;
        synchronized (DefaultIssueEventProcessingStatsLogger.class) {
            if (!this.canPrintStats()) return;
            this.loggedStats.values().forEach(s -> {
                log.debug("{} Durations for '{}' total stats - in millis:{} , in micros: {} ", new Object[]{this.statsGroupName, ((IssueEventProcessingStats)s).statsName, ((IssueEventProcessingStats)s).totalDurations.get(), ((IssueEventProcessingStats)s).totalMicrosDurations.get()});
                log.debug("{} Durations for '{}' snapshot stats - in millis:{} , in micros: {} ", new Object[]{this.statsGroupName, ((IssueEventProcessingStats)s).statsName, ((IssueEventProcessingStats)s).snapshotDurations.get(), ((IssueEventProcessingStats)s).snapshotMicrosDurations.get()});
                ((IssueEventProcessingStats)s).snapshotDurations.reset();
                ((IssueEventProcessingStats)s).snapshotMicrosDurations.reset();
                this.lastPrintStats.reset().start();
            });
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private boolean canPrintStats() {
        return this.lastPrintStats.elapsed(TimeUnit.MILLISECONDS) > STATS_PERIOD_MILLIS;
    }

    private static final class NoopLogger
    implements IssueEventProcessingStatsLogger {
        private NoopLogger() {
        }

        @Override
        public void wrap(String name, Runnable op) {
            op.run();
        }

        @Override
        public <T> T wrap(String name, Supplier<T> op) {
            return op.get();
        }
    }

    static class IssueEventProcessingStats {
        static final long[] MILLIS_DISTRIBUTION = new long[]{0L, 1L, 5L, 10L, 50L, 100L, 500L, 1000L, 5000L, 10000L};
        private final MutableLongStats snapshotDurations = new MutableLongStats(MILLIS_DISTRIBUTION);
        private final MutableLongStats totalDurations = new MutableLongStats(MILLIS_DISTRIBUTION);
        private final MutableLongStats totalMicrosDurations = new MutableLongStats(new long[0]);
        private final MutableLongStats snapshotMicrosDurations = new MutableLongStats(new long[0]);
        private final String statsName;

        public IssueEventProcessingStats(String statsName) {
            this.statsName = statsName;
        }

        public void wrap(Runnable op) {
            this.wrap(() -> {
                op.run();
                return null;
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T wrap(Supplier<T> op) {
            Instant start = Instant.now();
            Stopwatch stopwatch = Stopwatch.createStarted();
            try {
                T t = op.get();
                return t;
            }
            finally {
                long duration = ChronoUnit.MILLIS.between(start, Instant.now());
                this.snapshotMicrosDurations.accept(stopwatch.elapsed(TimeUnit.MICROSECONDS));
                this.totalMicrosDurations.accept(stopwatch.elapsed(TimeUnit.MICROSECONDS));
                this.snapshotDurations.accept(duration);
                this.totalDurations.accept(duration);
            }
        }
    }
}

