/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.instrumentation.operations.OpTimer;
import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.auditing.handlers.ReindexingAuditHandler;
import com.atlassian.jira.bc.issue.worklog.TimeTrackingConfiguration;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.IndexTaskContext;
import com.atlassian.jira.config.ReindexMessage;
import com.atlassian.jira.config.ReindexMessageManager;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.config.util.IndexPathManager;
import com.atlassian.jira.config.util.IndexingConfiguration;
import com.atlassian.jira.entity.WithId;
import com.atlassian.jira.event.ListenerManager;
import com.atlassian.jira.event.listeners.search.IssueIndexListener;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.index.AccumulatingResultBuilder;
import com.atlassian.jira.index.Index;
import com.atlassian.jira.index.IssueIndexHelper;
import com.atlassian.jira.index.ManagedIndexSearcher;
import com.atlassian.jira.index.UnmanagedIndexSearcher;
import com.atlassian.jira.index.ha.IndexesRestoredEvent;
import com.atlassian.jira.index.request.AffectedIndex;
import com.atlassian.jira.index.settings.IndexingLanguageSetting;
import com.atlassian.jira.instrumentation.Instrumentation;
import com.atlassian.jira.instrumentation.InstrumentationName;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.index.BackgroundIndexListener;
import com.atlassian.jira.issue.index.IndexDeactivatedEvent;
import com.atlassian.jira.issue.index.IndexDirectoryFactory;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IndexReconciler;
import com.atlassian.jira.issue.index.IndexingShutdownEvent;
import com.atlassian.jira.issue.index.IndexingTimers;
import com.atlassian.jira.issue.index.InternalIndexingService;
import com.atlassian.jira.issue.index.IssueBatcherFactory;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.index.IssueIndexer;
import com.atlassian.jira.issue.index.IssueIndexingParams;
import com.atlassian.jira.issue.index.IssuesBatcher;
import com.atlassian.jira.issue.index.JiraAnalyzer;
import com.atlassian.jira.issue.index.ReindexAllCancelledEvent;
import com.atlassian.jira.issue.index.ReindexAllCompletedEvent;
import com.atlassian.jira.issue.index.ReindexAllStartedEvent;
import com.atlassian.jira.issue.index.ReindexIssuesCompletedEvent;
import com.atlassian.jira.issue.index.ReindexIssuesStartedEvent;
import com.atlassian.jira.issue.index.SearchUnavailableException;
import com.atlassian.jira.issue.index.SearcherCache;
import com.atlassian.jira.issue.index.ThreadLocalSearcherCache;
import com.atlassian.jira.issue.index.exception.CannotGetIndexLockException;
import com.atlassian.jira.issue.managers.ArchivingDao;
import com.atlassian.jira.issue.managers.DefaultArchivingDao;
import com.atlassian.jira.issue.util.DatabaseIssuesIterable;
import com.atlassian.jira.issue.util.IssueGVsIssueIterable;
import com.atlassian.jira.issue.util.IssueObjectIssuesIterable;
import com.atlassian.jira.issue.util.IssuesIterable;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.archiving.ArchivingLicenseCheck;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.task.context.Contexts;
import com.atlassian.jira.util.collect.EnclosedIterable;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.thread.JiraThreadLocalUtils;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.core.LifecycleAwareSchedulerService;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopFieldDocs;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityFieldMap;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIndexManager
implements IssueIndexManager,
InternalIndexingService {
    private static final Logger log = LoggerFactory.getLogger(DefaultIndexManager.class);
    public static final Analyzer ANALYZER_FOR_SEARCHING = JiraAnalyzer.ANALYZER_FOR_SEARCHING;
    public static final Analyzer ANALYZER_FOR_INDEXING = JiraAnalyzer.ANALYZER_FOR_INDEXING;
    @ClusterSafe(value="Indexes are local to each node")
    private final IndexLocks indexLock = new IndexLocks();
    private final IssueIndexer issueIndexer;
    private final IndexPathManager indexPathManager;
    private final IndexingConfiguration indexConfig;
    private final ReindexMessageManager reindexMessageManager;
    private final EventPublisher eventPublisher;
    private final ListenerManager listenerManager;
    private final ProjectManager projectManager;
    private final IssueManager issueManager;
    private final TaskManager taskManager;
    private final OfBizDelegator ofBizDelegator;
    private final ArchivingDao archivingDao;
    private final SearcherCache searcherCache;
    private final TimeTrackingConfiguration timeTrackingConfiguration;
    private final IndexingLanguageSetting indexingLanguageSetting;
    private final ReindexingAuditHandler reindexingAuditHandler;
    private final ArchivingLicenseCheck archivingLicenseCheck;
    private final FeatureManager featureManager;
    private final ThreadLocal<Boolean> indexingHeld = new ThreadLocal();
    private final ThreadLocal<Map<String, Issue>> heldIssues = ThreadLocal.withInitial(HashMap::new);
    static final String ISSUE_REINDEX_LEGACY_MODE_SYSTEM_PROPERTY = "com.atlassian.jira.issue.reindex.legacy.mode";
    private static final String ISSUE_REINDEX_LEGACY_MODE_DEFAULT_VALUE = Boolean.FALSE.toString();
    private final boolean issueReindexLegacyMode = Boolean.parseBoolean(JiraSystemProperties.getInstance().getProperty("com.atlassian.jira.issue.reindex.legacy.mode", ISSUE_REINDEX_LEGACY_MODE_DEFAULT_VALUE));
    private final AtomicLong reindexIssueAllCounter = new AtomicLong();
    private static final int REINDEX_ISSUE_ALL_COUNTER_INFO_LOG = 1000;

    public Analyzer getAnalyzerForSearching() {
        return ANALYZER_FOR_SEARCHING;
    }

    public Analyzer getAnalyzerForIndexing() {
        return ANALYZER_FOR_INDEXING;
    }

    public DefaultIndexManager(IndexingConfiguration indexProperties, IssueIndexer issueIndexer, IndexPathManager indexPath, ReindexMessageManager reindexMessageManager, EventPublisher eventPublisher, ListenerManager listenerManager, ProjectManager projectManager, IssueManager issueManager, TaskManager taskManager, OfBizDelegator ofBizDelegator, ArchivingDao archivingDao, SearcherCache searcherCache, TimeTrackingConfiguration timeTrackingConfiguration, IndexingLanguageSetting indexingLanguageSetting, ReindexingAuditHandler reindexingAuditHandler, ArchivingLicenseCheck archivingLicenseCheck, FeatureManager featureManager) {
        this.issueManager = issueManager;
        this.taskManager = taskManager;
        this.ofBizDelegator = ofBizDelegator;
        this.archivingDao = archivingDao;
        this.searcherCache = (SearcherCache)Assertions.notNull((String)"searcherCache", (Object)searcherCache);
        this.timeTrackingConfiguration = timeTrackingConfiguration;
        this.eventPublisher = (EventPublisher)Assertions.notNull((String)"eventPublisher", (Object)eventPublisher);
        this.indexConfig = (IndexingConfiguration)Assertions.notNull((String)"indexProperties", (Object)indexProperties);
        this.issueIndexer = (IssueIndexer)Assertions.notNull((String)"issueIndexer", (Object)issueIndexer);
        this.indexPathManager = (IndexPathManager)Assertions.notNull((String)"indexPath", (Object)indexPath);
        this.reindexMessageManager = (ReindexMessageManager)Assertions.notNull((String)"reindexMessageManager", (Object)reindexMessageManager);
        this.listenerManager = listenerManager;
        this.projectManager = projectManager;
        this.indexingLanguageSetting = indexingLanguageSetting;
        this.reindexingAuditHandler = reindexingAuditHandler;
        this.archivingLicenseCheck = archivingLicenseCheck;
        this.featureManager = featureManager;
        log.info(String.format("Legacy mode for reIndex(issue): %s=%b", ISSUE_REINDEX_LEGACY_MODE_SYSTEM_PROPERTY, this.issueReindexLegacyMode));
    }

    public void deactivate() {
        this.listenerManager.deleteListener(IssueIndexListener.class);
        this.indexConfig.disableIndex();
        this.issueIndexer.shutdown();
        DefaultIndexManager.flushThreadLocalSearchers();
        this.eventPublisher.publish((Object)new IndexDeactivatedEvent());
    }

    public long activate(Context context) {
        return this.activate(context, true);
    }

    public long activate(Context context, boolean reindex) {
        Assertions.notNull((String)"context", (Object)context);
        if (this.isIndexAvailable()) {
            throw new IllegalStateException("Cannot enable indexing as it is already enabled.");
        }
        if (log.isDebugEnabled()) {
            log.debug("Activating indexes in '" + this.indexPathManager.getIndexRootPath() + "'.");
        }
        this.listenerManager.createListener("Issue Index Listener", IssueIndexListener.class);
        this.indexConfig.enableIndex();
        if (reindex) {
            return this.reIndexAll(context);
        }
        return 0L;
    }

    public boolean isIndexAvailable() {
        return this.indexConfig.isIndexAvailable();
    }

    public long reIndexAll() throws IndexException {
        return this.reIndexAll(Contexts.nullContext());
    }

    public long reIndexAll(Context context) {
        return this.reIndexAll(context, false);
    }

    public long reIndexAll(Context context, boolean useBackgroundIndexing) {
        return this.reIndexAll(context, useBackgroundIndexing, true);
    }

    public long reIndexAll(Context context, boolean useBackgroundIndexing, boolean notifyCluster) {
        IssueIndexingParams indexingParams = useBackgroundIndexing ? IssueIndexingParams.INDEX_ISSUE_ONLY : IssueIndexingParams.INDEX_ALL;
        return this.reIndexAll(context, useBackgroundIndexing, indexingParams, notifyCluster);
    }

    public long reIndexAll(Context context, boolean useBackgroundIndexing, boolean reIndexComments, boolean reIndexChangeHistory, boolean notifyCluster) {
        IssueIndexingParams indexingInBackgroundParams = IssueIndexingParams.builder().setComments(reIndexComments).setChangeHistory(reIndexChangeHistory).build();
        IssueIndexingParams issueIndexingParams = useBackgroundIndexing ? indexingInBackgroundParams : IssueIndexingParams.INDEX_ALL;
        return this.reIndexAll(context, useBackgroundIndexing, issueIndexingParams, notifyCluster);
    }

    public long reIndexAll(Context context, IssueIndexingParams issueIndexingParams) {
        return this.reIndexAll(context, false, issueIndexingParams, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long reIndexAll(Context context, boolean useBackgroundIndexing, IssueIndexingParams issueIndexingParams, boolean notifyCluster) {
        Assertions.notNull((String)"context", (Object)context);
        context.setName("Issue");
        IssueIndexingParams filterReindexAllIndexingParams = useBackgroundIndexing ? this.filterBackgroundReindexAllIndexingParams(issueIndexingParams) : issueIndexingParams;
        if (!filterReindexAllIndexingParams.isIndex()) {
            return -1L;
        }
        log.info("ReindexAll in {}: {}", (Object)(useBackgroundIndexing ? "background" : "foreground"), (Object)filterReindexAllIndexingParams);
        long startTime = System.currentTimeMillis();
        ReindexMessage message = this.reindexMessageManager.getMessageObject();
        this.reindexingAuditHandler.handleReindexingStarted(useBackgroundIndexing);
        this.eventPublisher.publish((Object)new ReindexAllStartedEvent(useBackgroundIndexing, notifyCluster, filterReindexAllIndexingParams, message, this.indexingLanguageSetting.getValue()));
        if (useBackgroundIndexing) {
            if (!this.getIndexLock()) {
                return -1L;
            }
            try {
                this.doBackgroundReindex(context, filterReindexAllIndexingParams);
            }
            catch (InterruptedException e) {
                this.reindexingAuditHandler.handleBackgroundReindexingCancelled(startTime);
                this.eventPublisher.publish((Object)new ReindexAllCancelledEvent());
                long l = -1L;
                return l;
            }
            finally {
                this.releaseIndexLock();
                DefaultIndexManager.flushThreadLocalSearchers();
            }
        } else if (!this.withReindexLock(() -> this.doStopTheWorldReindex(context, filterReindexAllIndexingParams))) {
            return -1L;
        }
        if (message != null) {
            this.reindexMessageManager.clearMessageForTimestamp(message.getTime());
        }
        long duration = System.currentTimeMillis() - startTime;
        long indexDirectorySize = FileUtils.sizeOfDirectory((File)new File(this.indexPathManager.getIndexRootPath()));
        log.info("ReindexAll took: {} ms in the {}, index size is {}", new Object[]{duration, useBackgroundIndexing ? "background" : "foreground", FileUtils.byteCountToDisplaySize((long)indexDirectorySize)});
        long issueCount = this.issueManager.getIssueCount();
        long activeIssueCount = this.archivingDao.getActiveIssueCount();
        long archivedIssueCount = issueCount - activeIssueCount;
        this.reindexingAuditHandler.handleReindexingCompleted(startTime, duration, useBackgroundIndexing, issueCount, archivedIssueCount);
        this.eventPublisher.publish((Object)new ReindexAllCompletedEvent(startTime, duration, useBackgroundIndexing, notifyCluster, filterReindexAllIndexingParams, Long.valueOf(issueCount), Long.valueOf(archivedIssueCount), indexDirectorySize));
        this.eventPublisher.publish((Object)IndexesRestoredEvent.INSTANCE);
        return duration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean withReindexLock(Runnable runnable) {
        if (!this.indexLock.writeLock.tryLock()) {
            try {
                Thread firstReader = this.indexLock.getBlocker();
                if (null != firstReader) {
                    String threadInfo = this.getThreadInfo(firstReader);
                    log.error("Failed to acquire the write lock. Thread which is holding the lock has been found: {}", (Object)threadInfo);
                } else {
                    log.error("Failed to acquire the write lock but no threads are holding the lock");
                }
            }
            catch (Exception e) {
                log.error("Failed to acquire the write lock but could not obtain the 'firstReader' thread which is holding the lock", (Throwable)e);
            }
            finally {
                String threadInfo = this.getThreadInfo(Thread.currentThread());
                log.error("Failed to acquire the write lock, current thread: " + threadInfo);
            }
            return false;
        }
        try {
            runnable.run();
        }
        finally {
            this.indexLock.writeLock.unlock();
            DefaultIndexManager.flushThreadLocalSearchers();
        }
        return true;
    }

    private String getThreadInfo(Thread thread) {
        StringBuilder sb = new StringBuilder();
        sb.append("thread [name=").append(thread.getName()).append(", id=").append(thread.getId()).append("]\n").append(Arrays.toString(thread.getStackTrace()));
        return sb.toString();
    }

    public long reIndexAllIssuesInBackground(Context context) {
        return this.reIndexAll(context, true, IssueIndexingParams.INDEX_ISSUE_ONLY, true);
    }

    public long reIndexIssuesInBackground(Context context, IssueIndexingParams issueIndexingParams) {
        return this.reIndexAll(context, true, issueIndexingParams, true);
    }

    public long reIndexIssues(Collection<GenericValue> issues) throws IndexException {
        return this.reIndexIssues(new IssueGVsIssueIterable(issues, this.getIssueFactory()), Contexts.nullContext());
    }

    protected long reIndexIssues(Collection<GenericValue> issues, IssueIndexingParams issueIndexingParams) throws IndexException {
        return this.reIndexIssues(new IssueGVsIssueIterable(issues, this.getIssueFactory()), Contexts.nullContext(), issueIndexingParams);
    }

    public long reIndexIssueObjects(Collection<? extends Issue> issueObjects) throws IndexException {
        return this.reIndexIssueObjects(issueObjects, IssueIndexingParams.INDEX_ALL);
    }

    public long reIndexIssueObjects(Collection<? extends Issue> issueObjects, boolean reIndexComments, boolean reIndexChangeHistory) throws IndexException {
        IssueIndexingParams issueIndexingParams = IssueIndexingParams.builder().setComments(reIndexComments).setChangeHistory(reIndexChangeHistory).build();
        return this.reIndexIssueObjects(issueObjects, issueIndexingParams);
    }

    public long reIndexIssueObjects(Collection<? extends Issue> issueObjects, IssueIndexingParams issueIndexingParams) throws IndexException {
        Collection genericValues = CollectionUtils.collect(issueObjects, (Transformer)IssueFactory.TO_GENERIC_VALUE);
        return this.reIndexIssues(genericValues, issueIndexingParams);
    }

    public long reIndexIssueObjects(Collection<? extends Issue> issueObjects, boolean reIndexComments, boolean reIndexChangeHistory, boolean shouldReplicate) {
        IssueIndexingParams issueIndexingParams = IssueIndexingParams.builder().setComments(reIndexComments).setChangeHistory(reIndexChangeHistory).build();
        return this.reIndexIssueObjects(issueObjects, issueIndexingParams, shouldReplicate);
    }

    public long reIndexIssueObjects(Collection<? extends Issue> issueObjects, IssueIndexingParams issueIndexingParams, boolean shouldReplicate) {
        return this.reIndexIssues((IssuesIterable)new IssueObjectIssuesIterable(issueObjects), Contexts.nullContext(), issueIndexingParams, shouldReplicate);
    }

    public void deIndex(Project project, boolean shouldReplicate) {
        if (project == null) {
            return;
        }
        try {
            this.executeWithIndexLock(() -> this.issueIndexer.deIndexProject(project, shouldReplicate));
            log.info("Deindexed project {} ({})", (Object)project.getName(), (Object)project.getKey());
        }
        catch (CannotGetIndexLockException e) {
            log.error("Could not deindex project {} ({})", new Object[]{project.getName(), project.getKey(), e});
        }
    }

    public void deIndexComments(Set<WithId> commentsToDeIndex, boolean shouldReplicate) {
        this.deIndexEntitiesById(commentsToDeIndex, ids -> this.issueIndexer.deindexComments((Collection<? extends WithId>)ids, Contexts.nullContext(), shouldReplicate));
    }

    public void deIndexWorklogs(Set<WithId> worklogsToDeIndex, boolean shouldReplicate) {
        this.deIndexEntitiesById(worklogsToDeIndex, ids -> this.issueIndexer.deindexWorklogs((Collection<? extends WithId>)ids, Contexts.nullContext(), shouldReplicate));
    }

    public void reIndex(Issue issue) throws IndexException {
        if (this.issueReindexLegacyMode) {
            if (log.isTraceEnabled()) {
                log.trace("reIndex(issue) re-indexing issue and all related entities. For issues with a large amount of comments and worklogs this may cause serious performance problems.", new Throwable());
            }
            this.reIndex(issue, IssueIndexingParams.INDEX_ALL);
        } else {
            if (log.isTraceEnabled()) {
                log.trace("reIndex(issue) re-indexing issue only. Legacy mode can be turned on by setting system property: -D{}=true. It is not recommended unless you are certain that some plugins/integrations require it to work properly", (Object)ISSUE_REINDEX_LEGACY_MODE_SYSTEM_PROPERTY);
            }
            this.reIndex(issue, IssueIndexingParams.INDEX_ISSUE_WITH_HISTORY);
        }
    }

    public void reIndex(Issue issue, boolean reIndexComments, boolean reIndexChangeHistory) {
        IssueIndexingParams issueIndexingParams = IssueIndexingParams.builder().setComments(reIndexComments).setChangeHistory(reIndexChangeHistory).build();
        this.reIndex(issue, issueIndexingParams);
    }

    public void reIndex(Issue issue, IssueIndexingParams issueIndexingParams) {
        if (issueIndexingParams == IssueIndexingParams.INDEX_ALL) {
            this.reindexIssueAllCounter.incrementAndGet();
            if (this.reindexIssueAllCounter.get() % 1000L == 1L) {
                log.info("reIndex(issue, INDEX_ALL) called, counter: {}. Will be logging every: {} occurrence. Turn logging to: TRACE to log every call with stack trace. Legacy mode for reIndex(issue): {}={}", new Object[]{this.reindexIssueAllCounter.get(), 1000, ISSUE_REINDEX_LEGACY_MODE_SYSTEM_PROPERTY, this.issueReindexLegacyMode});
            } else {
                log.trace("reIndex(issue, INDEX_ALL) called, counter: {}. Legacy mode for reIndex(issue): {}={}", new Object[]{this.reindexIssueAllCounter.get(), ISSUE_REINDEX_LEGACY_MODE_SYSTEM_PROPERTY, this.issueReindexLegacyMode});
            }
        }
        List<Issue> issues = Collections.singletonList(issue);
        this.reIndexIssueObjects(issues, issueIndexingParams, true);
    }

    public void reIndex(GenericValue issueGV) throws IndexException {
        if ("Issue".equals(issueGV.getEntityName())) {
            ArrayList genericValues = Lists.newArrayList((Object[])new GenericValue[]{issueGV});
            this.reIndexIssues(genericValues);
        } else {
            log.error("Entity is not an issue {}", (Object)issueGV.getEntityName());
        }
    }

    public void hold() {
        this.indexingHeld.set(Boolean.TRUE);
    }

    public boolean isHeld() {
        return this.indexingHeld.get() != null && this.indexingHeld.get() != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long release() throws IndexException {
        this.indexingHeld.set(Boolean.FALSE);
        try {
            Map<String, Issue> queue = this.heldIssues.get();
            if (queue.size() > 0) {
                IssueObjectIssuesIterable issuesIterable = new IssueObjectIssuesIterable(queue.values());
                long l = this.reIndexIssues(issuesIterable, Contexts.nullContext());
                return l;
            }
            long l = 0L;
            return l;
        }
        finally {
            this.heldIssues.remove();
            this.indexingHeld.remove();
        }
    }

    public long reIndexIssues(IssuesIterable issuesIterable, Context context) throws IndexException {
        return this.reIndexIssues(issuesIterable, context, IssueIndexingParams.INDEX_ALL);
    }

    public long reIndexIssues(IssuesIterable issuesIterable, Context context, boolean reIndexComments, boolean reIndexChangeHistory) throws IndexException {
        IssueIndexingParams issueIndexingParams = IssueIndexingParams.builder().setComments(reIndexComments).setChangeHistory(reIndexChangeHistory).build();
        return this.reIndexIssues(issuesIterable, context, issueIndexingParams);
    }

    public long reIndexIssues(IssuesIterable issuesIterable, Context context, IssueIndexingParams issueIndexingParams) {
        return this.reIndexIssues(issuesIterable, context, issueIndexingParams, true);
    }

    /*
     * Loose catch block
     */
    public long reIndexIssues(IssuesIterable issuesIterable, Context context, IssueIndexingParams issueIndexingParams, boolean shouldReplicate) {
        Throwable throwable = null;
        try (Ticker ignored = Timers.start((String)"DefaultIssueManager.reIndexIssues");){
            if (this.isHeld()) {
                Map<String, Issue> queue = this.heldIssues.get();
                issuesIterable.foreach(element -> queue.put(element.getKey(), (Issue)element));
                long l = 0L;
                return l;
            }
            Assertions.notNull((String)"issues", (Object)issuesIterable);
            Assertions.notNull((String)"context", (Object)context);
            this.eventPublisher.publish((Object)new ReindexIssuesStartedEvent());
            try {
                long totalTime = this.executeWithIndexLock(() -> this.issueIndexer.reindexIssues((EnclosedIterable<Issue>)issuesIterable, context, issueIndexingParams, true, shouldReplicate));
                log.debug("Reindexed {} issues in {}ms.", (Object)issuesIterable.size(), (Object)totalTime);
                this.eventPublisher.publish((Object)new ReindexIssuesCompletedEvent(totalTime));
                long l = totalTime;
                return l;
            }
            catch (CannotGetIndexLockException e) {
                long l;
                block21: {
                    block22: {
                        log.error("Could not reindex: {}", (Object)issuesIterable, (Object)e);
                        l = -1L;
                        if (ignored == null) break block21;
                        if (throwable == null) break block22;
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block21;
                    }
                    ignored.close();
                }
                return l;
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    throw throwable4;
                }
            }
        }
    }

    public long reIndexComments(Collection<Comment> comments) throws IndexException {
        return this.reIndexComments(comments, Contexts.nullContext());
    }

    public long reIndexComments(Collection<Comment> comments, Context context) throws IndexException {
        return this.reIndexComments(comments, context, true);
    }

    public long reIndexComments(Collection<Comment> comments, Context context, boolean shouldReplicate) throws IndexException {
        Supplier<Index.Result> resultSupplier = () -> this.issueIndexer.reindexComments(comments, context, shouldReplicate);
        return this.reIndexRelatedEntity(comments, context, shouldReplicate, AffectedIndex.COMMENT, resultSupplier);
    }

    private int getCommentCount() {
        EntityFieldMap condition = new EntityFieldMap((Map)FieldMap.build((String)"type", (Object)"comment"), EntityOperator.AND);
        List commentCount = this.ofBizDelegator.findByCondition("ActionCount", (EntityCondition)condition, (Collection)ImmutableList.of((Object)"count"));
        if (commentCount != null && commentCount.size() == 1) {
            GenericValue commentCountGV = (GenericValue)commentCount.get(0);
            return commentCountGV.getLong("count").intValue();
        }
        throw new DataAccessException("Unable to access the count for the Action table");
    }

    public long reIndexWorklogs(Collection<Worklog> worklogs) throws IndexException {
        return this.reIndexWorklogs(worklogs, Contexts.nullContext());
    }

    public long reIndexWorklogs(Collection<Worklog> worklogs, Context context) throws IndexException {
        return this.reIndexWorklogs(worklogs, context, true);
    }

    public long reIndexWorklogs(Collection<Worklog> worklogs, Context context, boolean shouldReplicate) throws IndexException {
        Supplier<Index.Result> resultSupplier = () -> this.issueIndexer.reindexWorklogs(worklogs, context, shouldReplicate);
        return this.reIndexRelatedEntity(worklogs, context, shouldReplicate, AffectedIndex.WORKLOG, resultSupplier);
    }

    private int getWorklogCount() {
        return (int)this.ofBizDelegator.getCount("Worklog");
    }

    private <T extends WithId> long reIndexRelatedEntity(Collection<T> entities, Context context, boolean shouldReplicate, AffectedIndex affectedIndex, Supplier<Index.Result> reindexSupplier) throws IndexException {
        Assertions.notNull((String)"entities", entities);
        Assertions.notNull((String)"context", (Object)context);
        this.eventPublisher.publish((Object)new ReindexIssuesStartedEvent());
        try {
            long totalTime = this.executeWithIndexLock(reindexSupplier);
            log.debug("Reindexed {} entities in {}ms.", (Object)entities.size(), (Object)totalTime);
            this.eventPublisher.publish((Object)new ReindexIssuesCompletedEvent(totalTime));
            return totalTime;
        }
        catch (CannotGetIndexLockException e) {
            log.error("Could not reindex: {}", entities, (Object)e);
            return -1L;
        }
    }

    /*
     * Exception decompiling
     */
    public boolean isIndexConsistent() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Instant getLatestIndexDate() {
        ManagedIndexSearcher searcher = this.getIssueSearcher();
        try {
            TopFieldDocs topDocs = searcher.search((Query)new MatchAllDocsQuery(), 1, new Sort(new SortField("updated", SortField.Type.LONG, true)));
            if (topDocs.scoreDocs == null || topDocs.scoreDocs.length == 0) {
                log.info("No documents found in Issue index. Searcher used: {}", (Object)searcher);
                return null;
            }
            int docID = topDocs.scoreDocs[0].doc;
            Document doc = searcher.doc(docID, (Set)ImmutableSet.of((Object)"issue_id", (Object)"key", (Object)"created", (Object)"updated", (Object)"version"));
            IndexableField updatedField = doc.getField("updated");
            if (updatedField == null) {
                log.info("No value for field '{}' of latest updated issue found in issue index: {}", (Object)"updated", (Object)this.issueDocumentToString(doc));
                return null;
            }
            return this.epochMillisStringToInstant(updatedField.stringValue());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private String issueDocumentToString(Document document) {
        String rawDate = document.get("created");
        String sb = "[issueId=" + document.get("issue_id") + ", issueKey=" + document.get("key") + ", issueCreated(raw)=" + rawDate + ", issueCreated(asDate)=" + this.epochMillisStringToInstant(rawDate) + ", issueVersion=" + document.get("version") + "]";
        return sb;
    }

    @Nullable
    private Instant epochMillisStringToInstant(String field) {
        if (field == null) {
            return null;
        }
        try {
            long date = Long.parseLong(field);
            return Instant.ofEpochMilli(date);
        }
        catch (NumberFormatException e) {
            log.trace("failed parsing date from{}", (Object)field);
            return null;
        }
    }

    private boolean checkIfIndexIsSearchable(String name, UnmanagedIndexSearcher searcher) {
        int actualCount = searcher.getIndexReader().numDocs();
        log.debug("checkIfIndexIsSearchable: {}; actualCount={}", (Object)name, (Object)actualCount);
        return actualCount >= 0;
    }

    public int size() {
        return (int)this.archivingDao.getActiveIssueCount();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public long optimize() {
        if (!this.isIndexAvailable()) {
            return 0L;
        }
        if (!this.getIndexLock()) {
            return -1L;
        }
        try {
            long l = this.optimize0();
            return l;
        }
        finally {
            this.releaseIndexLock();
        }
    }

    @GuardedBy(value="index read lock")
    private long optimize0() {
        long startTime = System.currentTimeMillis();
        this.issueIndexer.optimize().await();
        return System.currentTimeMillis() - startTime;
    }

    public void deIndex(WithId issueWithId) throws IndexException {
        this.deIndexIssueObjectsById(Sets.newHashSet((Object[])new WithId[]{issueWithId}), true);
    }

    private void deIndexEntitiesById(Set<? extends WithId> entities, Function<Set<WithId>, Index.Result> deindexOperation) {
        Set cleanedIds;
        Set set = cleanedIds = Objects.isNull(entities) ? Collections.emptySet() : entities.stream().filter(Objects::nonNull).map(id -> id).filter(id -> Objects.nonNull(id.getId())).collect(Collectors.toSet());
        if (cleanedIds.isEmpty()) {
            return;
        }
        try {
            this.executeWithIndexLock(() -> (Index.Result)deindexOperation.apply(cleanedIds));
        }
        catch (CannotGetIndexLockException e) {
            log.error("Could not deindex: {}", cleanedIds.iterator().next(), (Object)e);
        }
    }

    public void deIndexIssueObjectsById(Set<? extends WithId> issuesToDelete, boolean shouldReplicate) {
        this.deIndexEntitiesById(issuesToDelete, ids -> this.issueIndexer.deindexIssues((Collection<? extends WithId>)ids, Contexts.nullContext(), shouldReplicate));
    }

    public void deIndex(GenericValue entity) throws IndexException {
        if (!"Issue".equals(entity.getEntityName())) {
            log.error("Entity is not an issue {}", (Object)entity.getEntityName());
            return;
        }
        this.deIndex((Issue)this.getIssueFactory().getIssue(entity));
    }

    @Override
    public void conditionalUpdateWithVersion(IndexDirectoryFactory.Name indexName, Document document) {
        this.executeWithIndexLock(() -> this.issueIndexer.conditionalUpdateWithVersion(indexName, document));
    }

    @Override
    public void conditionalUpdateWithVersion(Document issueDocument, Collection<Document> commentDocuments, Collection<Document> changeHistoryDocuments, Collection<Document> worklogDocuments) {
        this.executeWithIndexLock(() -> this.issueIndexer.conditionalUpdateWithVersion(issueDocument, commentDocuments, changeHistoryDocuments, worklogDocuments));
    }

    @Override
    public void unconditionallyReindexIssuesAndRelatedEntitiesLocally(Collection<Issue> issueObjects) {
        this.executeWithIndexLock(() -> this.issueIndexer.reindexIssues((EnclosedIterable<Issue>)new IssueObjectIssuesIterable(issueObjects), Contexts.nullContext(), IssueIndexingParams.INDEX_ALL, false, false));
    }

    private long executeWithIndexLock(Supplier<Index.Result> supplier) {
        if (!this.getIndexLock()) {
            throw new CannotGetIndexLockException();
        }
        OpTimer opTimer = Instrumentation.pullTimer(InstrumentationName.ISSUE_INDEX_WRITES);
        try {
            this.await(supplier.get());
        }
        finally {
            this.releaseIndexLock();
            DefaultIndexManager.flushThreadLocalSearchers();
        }
        opTimer.end();
        return opTimer.snapshot().getMillisecondsTaken();
    }

    private void await(Index.Result result) {
        try (Ticker ignored = IndexingTimers.WAIT_FOR_LUCENE.start(new String[0]);){
            this.obtain(result::await);
        }
    }

    @VisibleForTesting
    void releaseIndexLock() {
        this.indexLock.readLock.unlock();
    }

    @VisibleForTesting
    boolean getIndexLock() {
        return this.indexLock.readLock.tryLock();
    }

    private boolean obtain(Awaitable waitFor) {
        try {
            if (waitFor.await(this.indexConfig.getIndexLockWaitTime(), TimeUnit.MILLISECONDS)) {
                return true;
            }
        }
        catch (InterruptedException ie) {
            log.error("Wait attempt interrupted.", (Throwable)new IndexException("Wait attempt interrupted.", (Exception)ie));
            return false;
        }
        String errorMessage = "Wait attempt timed out - waited " + this.indexConfig.getIndexLockWaitTime() + " milliseconds";
        log.error(errorMessage, (Throwable)new IndexException(errorMessage));
        return false;
    }

    public String getPluginsRootPath() {
        return this.indexPathManager.getPluginIndexRootPath();
    }

    public List<String> getExistingPluginsPaths() {
        String[] listing;
        File pluginRootPath = new File(this.getPluginsRootPath());
        if (pluginRootPath.exists() && pluginRootPath.isDirectory() && pluginRootPath.canRead() && (listing = pluginRootPath.list()) != null) {
            ArrayList<String> subdirs = new ArrayList<String>(listing.length);
            for (String element : listing) {
                File f = new File(pluginRootPath, element);
                if (!f.exists() || !f.canRead() || !f.isDirectory()) continue;
                subdirs.add(f.getAbsolutePath());
            }
            return Collections.unmodifiableList(subdirs);
        }
        return Collections.emptyList();
    }

    public ManagedIndexSearcher getIssueSearcher() {
        return this.getEntitySearcher(IndexDirectoryFactory.Name.ISSUE);
    }

    public ManagedIndexSearcher getCommentSearcher() {
        return this.getEntitySearcher(IndexDirectoryFactory.Name.COMMENT);
    }

    public ManagedIndexSearcher getChangeHistorySearcher() {
        return this.getEntitySearcher(IndexDirectoryFactory.Name.CHANGE_HISTORY);
    }

    public ManagedIndexSearcher getWorklogSearcher() {
        return this.getEntitySearcher(IndexDirectoryFactory.Name.WORKLOG);
    }

    @Override
    public ManagedIndexSearcher getEntitySearcher(IndexDirectoryFactory.Name index) {
        if (!this.getIndexLock()) {
            throw new SearchUnavailableException(null, this.indexConfig.isIndexAvailable());
        }
        try {
            ManagedIndexSearcher managedIndexSearcher = this.searcherCache.getSearcher(index);
            return managedIndexSearcher;
        }
        finally {
            this.releaseIndexLock();
        }
    }

    @Override
    public void reindexIssuesBatchMode(Collection<Long> issuesIdsToReindex, Context context, IssueIndexingParams params) throws IndexException {
        IssuesBatcher batcher = this.getIssueBatcherFactory().getBatcher(issuesIdsToReindex);
        if (!this.withReindexLock(JiraThreadLocalUtils.wrap(() -> this.issueIndexer.reindexIssuesBatchMode(batcher, context, params)))) {
            throw new IndexException("Failed to acquire reindex lock");
        }
    }

    public Collection<String> getAllIndexPaths() {
        ArrayList<String> paths = new ArrayList<String>();
        paths.addAll(this.issueIndexer.getIndexPaths());
        paths.addAll(this.getExistingPluginsPaths());
        return Collections.unmodifiableList(paths);
    }

    public void shutdown() {
        this.eventPublisher.publish((Object)new IndexingShutdownEvent());
        DefaultIndexManager.flushThreadLocalSearchers();
        this.issueIndexer.shutdown();
    }

    IssueFactory getIssueFactory() {
        return (IssueFactory)ComponentAccessor.getComponentOfType(IssueFactory.class);
    }

    IssueBatcherFactory getIssueBatcherFactory() {
        return (IssueBatcherFactory)ComponentAccessor.getComponent(IssueBatcherFactory.class);
    }

    public String toString() {
        return "DefaultIndexManager: paths: " + this.getAllIndexPaths();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doBackgroundReindex(Context context, IssueIndexingParams issueIndexingParams) throws InterruptedException {
        StopWatch watch = new StopWatch();
        watch.start();
        IssueIndexHelper issueIndexHelper = new IssueIndexHelper(this.issueManager, this.issueIndexer, this.getIssueFactory());
        long[] indexedIssues = issueIndexHelper.getAllIssueIds();
        IndexReconciler reconciler = new IndexReconciler(indexedIssues);
        AccumulatingResultBuilder resultBuilder = new AccumulatingResultBuilder();
        log.info("Reindexing {} issues in the background.", (Object)indexedIssues.length);
        TaskDescriptor currentTaskDescriptor = this.taskManager.getLiveTask(new IndexTaskContext());
        BackgroundIndexListener backgroundIndexListener = new BackgroundIndexListener();
        this.eventPublisher.register((Object)backgroundIndexListener);
        try {
            IssuesBatcher batcher = this.getIssueBatcherFactory().getBatcher(reconciler);
            for (IssuesIterable batchOfIssues : batcher) {
                TaskDescriptor taskDescriptor = this.taskManager.getTask(currentTaskDescriptor.getTaskId());
                if (taskDescriptor != null && taskDescriptor.isCancelled()) break;
                resultBuilder.add(this.issueIndexer.reindexIssues((EnclosedIterable<Issue>)batchOfIssues, context, issueIndexingParams, true, false));
            }
            resultBuilder.toResult().await();
        }
        finally {
            this.eventPublisher.unregister((Object)backgroundIndexListener);
            log.info("{} issues reindexed in the background, in {} millis.", (Object)indexedIssues.length, (Object)watch.getTime());
            watch.split();
            issueIndexHelper.fixupConcurrentlyIndexedIssues(context, resultBuilder, backgroundIndexListener, issueIndexingParams);
            log.info("{} concurrently modified issues reindexed in {} millis.", (Object)backgroundIndexListener.getTotalModifications(), (Object)(watch.getTime() - watch.getSplitTime()));
            watch.split();
        }
        TaskDescriptor taskDescriptor = this.taskManager.getTask(currentTaskDescriptor.getTaskId());
        if (taskDescriptor != null && taskDescriptor.isCancelled()) {
            log.info("Background reindex cancelled.");
            throw new InterruptedException();
        }
        issueIndexHelper.fixupIndexCorruptions(resultBuilder, reconciler);
        log.info("Reindexing {} issues in the background completed in {} millis", (Object)this.getEntitySearcher(IndexDirectoryFactory.Name.ISSUE).getIndexReader().numDocs(), (Object)watch.getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="external index write lock")
    private void doStopTheWorldReindex(Context context, IssueIndexingParams issueIndexingParams) {
        LifecycleAwareSchedulerService schedulerService = (LifecycleAwareSchedulerService)ComponentAccessor.getComponent(LifecycleAwareSchedulerService.class);
        boolean restartScheduler = false;
        try {
            try {
                if (schedulerService.getState() == LifecycleAwareSchedulerService.State.STARTED) {
                    schedulerService.standby();
                    restartScheduler = true;
                }
            }
            catch (SchedulerServiceException e) {
                log.warn("Unable to place the scheduler service in standby mode during reindex", (Throwable)e);
            }
            this.indexConfig.disableIndex();
            this.issueIndexer.deleteIndexes(issueIndexingParams);
            this.doIndexIssuesInBatchMode(context, issueIndexingParams);
            this.optimize0();
        }
        finally {
            this.indexConfig.enableIndex();
            if (restartScheduler) {
                try {
                    schedulerService.start();
                }
                catch (SchedulerServiceException e) {
                    log.error("Unable to restart the scheduler after reindex", (Throwable)e);
                }
            }
        }
    }

    @GuardedBy(value="external index write lock")
    private void doIndexIssuesInBatchMode(Context context, IssueIndexingParams issueIndexingParams) {
        IssuesBatcher batcher;
        if (this.featureManager.isEnabled(JiraFeatureFlagRegistrar.DB_FILTER_OUT_ARCHIVE_ISSUES_DURING_FULL_REINDEX) && this.archivingLicenseCheck.isLicensedForIssueArchiving()) {
            batcher = this.getIssueBatcherFactory().getBatcher(DefaultArchivingDao.getIsNotArchivedIssueExpression());
            log.debug("Issue batcher with active issues only condition will be used during the reindex.");
        } else {
            batcher = this.getIssueBatcherFactory().getBatcher();
        }
        this.issueIndexer.indexIssuesBatchMode(batcher, context, issueIndexingParams);
    }

    private static void flushThreadLocalSearchers() {
        ThreadLocalSearcherCache.internalCloseSearchers();
    }

    private IssueIndexingParams filterBackgroundReindexAllIndexingParams(@Nonnull IssueIndexingParams issueIndexingParams) {
        return IssueIndexingParams.builder((IssueIndexingParams)issueIndexingParams).setComments(issueIndexingParams.isIndexComments() && this.shouldCommentsBeReindexed()).setWorklogs(issueIndexingParams.isIndexWorklogs() && this.shouldWorklogsBeReindexed()).build();
    }

    private boolean shouldCommentsBeReindexed() {
        return this.getCommentCount() > 0;
    }

    private boolean shouldWorklogsBeReindexed() {
        return this.timeTrackingConfiguration.enabled() && this.getWorklogCount() > 0;
    }

    private final class IndexLock {
        private final Lock lock;

        private IndexLock(Lock lock) {
            this.lock = (Lock)Assertions.notNull((String)"lock", (Object)lock);
        }

        public boolean tryLock() {
            return DefaultIndexManager.this.obtain(this.lock::tryLock);
        }

        public void unlock() {
            this.lock.unlock();
        }
    }

    private class IndexLocks {
        private final ReadWriteLock indexLock = new ReentrantReadWriteLock();
        final IndexLock readLock = new IndexLock(this.indexLock.readLock());
        final IndexLock writeLock = new IndexLock(this.indexLock.writeLock());

        private IndexLocks() {
        }

        public Thread getBlocker() {
            try {
                Field syncField = this.indexLock.getClass().getDeclaredField("sync");
                syncField.setAccessible(true);
                Object sync = syncField.get(this.indexLock);
                Field f = sync.getClass().getSuperclass().getDeclaredField("firstReader");
                f.setAccessible(true);
                return (Thread)f.get(sync);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
    }

    class ProjectBatcher
    implements IssuesBatcher {
        private final OfBizDelegator delegator;
        private final ImmutableList<Project> projects;
        private final IssueFactory issueFactory;

        @VisibleForTesting
        ProjectBatcher(OfBizDelegator delegator, IssueFactory issueFactory) {
            this.delegator = delegator;
            this.issueFactory = issueFactory;
            this.projects = ImmutableList.copyOf((Collection)DefaultIndexManager.this.projectManager.getProjectObjects());
        }

        @Override
        public Iterator<IssuesIterable> iterator() {
            return new ProjectsIterator();
        }

        class ProjectsIterator
        extends AbstractIterator<IssuesIterable> {
            private final UnmodifiableIterator<Project> projectsIt;

            ProjectsIterator() {
                this.projectsIt = ProjectBatcher.this.projects.iterator();
            }

            protected IssuesIterable computeNext() {
                if (!this.projectsIt.hasNext()) {
                    return (IssuesIterable)this.endOfData();
                }
                Project project = (Project)this.projectsIt.next();
                EntityExpr condition = new EntityExpr("project", EntityOperator.EQUALS, (Object)project.getId());
                return new DatabaseIssuesIterable(ProjectBatcher.this.delegator, ProjectBatcher.this.issueFactory, (EntityCondition)condition);
            }
        }
    }

    private static interface Awaitable {
        public boolean await(long var1, TimeUnit var3) throws InterruptedException;
    }
}

