/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexableField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentScrubber
implements Consumer<Document> {
    private static final Logger log = LoggerFactory.getLogger(DocumentScrubber.class);
    private static final int LUCENE_MAX_FIELD_SIZE = 32766;

    @Override
    public void accept(Document document) {
        Set<IndexableField> tooLargeFields = document.getFields().stream().filter(this::canBeProblematic).filter(this::exceedsMaxLength).collect(Collectors.toSet());
        tooLargeFields.forEach(field -> {
            document.removeField(field.name());
            log.error("A document contained a potential immense term in field " + field.name() + ". The field has been removed from the document.");
            if (log.isTraceEnabled()) {
                log.trace("Document details: " + document.toString());
            }
        });
    }

    private boolean exceedsMaxLength(IndexableField indexableField) {
        return indexableField.stringValue() != null && indexableField.stringValue().length() > 32766 || indexableField.binaryValue() != null && indexableField.binaryValue().length > 32766;
    }

    private boolean canBeProblematic(IndexableField indexableField) {
        return !indexableField.fieldType().tokenized() || indexableField.fieldType().docValuesType() != DocValuesType.NONE;
    }
}

