/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.issue.index.IssueIndexingParams;
import com.atlassian.jira.util.stats.LastValueSerializableStats;
import com.atlassian.jira.util.stats.ManagedStats;
import com.atlassian.jira.util.stats.MutableLongStats;
import com.atlassian.jira.util.stats.TopNSerializableStatsWithFrequencies;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface IndexingLimitsStats
extends ManagedStats {
    public static final String STATS_NAME = "INDEXING-LIMITS";

    public void settingMaxCommentsIndexed(int var1);

    public void settingMaxWorklogsIndexed(int var1);

    public void settingsChangeHistory(int var1, boolean var2);

    public void indexWithRelated(IssueIndexingParams var1);

    public void comments(int var1, boolean var2, String var3);

    public void worklogs(int var1, boolean var2, String var3);

    public void changeHistory(int var1, boolean var2, String var3);

    public void changeHistoryFiltering(long var1, long var3, long var5);

    public static IndexingLimitsStats create() {
        return new MutableIndexingLimitsStats();
    }

    public static class NoOpIndexingLimitsStats
    implements IndexingLimitsStats {
        @Override
        public void settingMaxCommentsIndexed(int maxCommentsIndexed) {
        }

        @Override
        public void settingMaxWorklogsIndexed(int maxWorklogsIndexed) {
        }

        @Override
        public void settingsChangeHistory(int maxChangeHistoryIndexed, boolean shouldFilterOutUnsupportedFields) {
        }

        @Override
        public void indexWithRelated(IssueIndexingParams issueIndexingParams) {
        }

        @Override
        public void comments(int numberOfComments, boolean limited, String issueKey) {
        }

        @Override
        public void worklogs(int numberOfWorklogs, boolean limited, String issueKey) {
        }

        @Override
        public void changeHistory(int numberOfChangeHistoryGroups, boolean limited, String issueKey) {
        }

        @Override
        public void changeHistoryFiltering(long itemsBeforeFiltering, long itemsAfterFiltering, long groupsBeforeFiltering) {
        }

        public String getStatsName() {
            return null;
        }
    }

    public static class MutableIndexingLimitsStats
    implements IndexingLimitsStats {
        private static final Logger log = LoggerFactory.getLogger(MutableIndexingLimitsStats.class);
        private static final String SYSTEM_PROPERTY_NAME_PREFIX = "com.atlassian.jira.issue.index.limits.stats.max.issue";
        private static final int MAX_NUMBER_OF_ISSUE_KEYS_STORED = JiraSystemProperties.getInstance().getInteger("com.atlassian.jira.issue.index.limits.stats.max.issue.stored", Integer.valueOf(1000));
        private static final int MAX_NUMBER_OF_ISSUE_KEYS_PRINTED = JiraSystemProperties.getInstance().getInteger("com.atlassian.jira.issue.index.limits.stats.max.issue.printed", Integer.valueOf(10));
        private static final int MAX_ISSUE_KEY_LENGTH_IN_TOP_N = 20;
        Settings settings = new Settings();
        AtomicInteger indexIssueWithRelated = new AtomicInteger();
        AtomicInteger indexComments = new AtomicInteger();
        AtomicInteger indexWorklogs = new AtomicInteger();
        AtomicInteger indexChangeHistory = new AtomicInteger();
        AtomicInteger indexAll = new AtomicInteger();
        AtomicInteger numberOfTimesCommentsLimited = new AtomicInteger();
        AtomicInteger numberOfTimesWorklogsLimited = new AtomicInteger();
        AtomicInteger numberOfTimesChangeHistoryLimited = new AtomicInteger();
        MutableLongStats numberOfComments = new MutableLongStats(new long[]{0L, 1L, 10L, 100L, 500L, 1000L, 10000L, 20000L, 50000L});
        MutableLongStats numberOfWorklogs = new MutableLongStats(new long[]{0L, 1L, 10L, 100L, 500L, 1000L, 10000L, 20000L, 50000L});
        MutableLongStats numberOfChangeHistory = new MutableLongStats(new long[]{0L, 1L, 10L, 100L, 500L, 1000L, 10000L, 20000L, 50000L});
        Filtering filtering = new Filtering();
        TopNSerializableStatsWithFrequencies<String> topIssuesWithLimitedComments = new TopNSerializableStatsWithFrequencies(MAX_NUMBER_OF_ISSUE_KEYS_STORED, MAX_NUMBER_OF_ISSUE_KEYS_PRINTED, 20);
        TopNSerializableStatsWithFrequencies<String> topIssuesWithLimitedWorklogs = new TopNSerializableStatsWithFrequencies(MAX_NUMBER_OF_ISSUE_KEYS_STORED, MAX_NUMBER_OF_ISSUE_KEYS_PRINTED, 20);
        TopNSerializableStatsWithFrequencies<String> topIssuesWithLimitedChangeHistory = new TopNSerializableStatsWithFrequencies(MAX_NUMBER_OF_ISSUE_KEYS_STORED, MAX_NUMBER_OF_ISSUE_KEYS_PRINTED, 20);

        public String getStatsName() {
            return IndexingLimitsStats.STATS_NAME;
        }

        @Override
        public void settingMaxCommentsIndexed(int maxCommentsIndexed) {
            this.settings.maxCommentsIndexed.store((Object)maxCommentsIndexed);
        }

        @Override
        public void settingMaxWorklogsIndexed(int maxWorklogsIndexed) {
            this.settings.maxWorklogsIndexed.store((Object)maxWorklogsIndexed);
        }

        @Override
        public void settingsChangeHistory(int maxChangeHistoryIndexed, boolean shouldFilterOutUnsupportedFields) {
            this.settings.maxChangeHistoryIndexed.store((Object)maxChangeHistoryIndexed);
            this.settings.shouldFilterOutUnsupportedFields.store((Object)shouldFilterOutUnsupportedFields);
        }

        @Override
        public void indexWithRelated(IssueIndexingParams issueIndexingParams) {
            if (issueIndexingParams.isIndexIssues()) {
                this.indexIssueWithRelated.incrementAndGet();
            }
            if (issueIndexingParams.isIndexComments()) {
                this.indexComments.incrementAndGet();
            }
            if (issueIndexingParams.isIndexWorklogs()) {
                this.indexWorklogs.incrementAndGet();
            }
            if (issueIndexingParams.isIndexChangeHistory()) {
                this.indexChangeHistory.incrementAndGet();
            }
            if (issueIndexingParams.isIndexAll()) {
                this.indexAll.incrementAndGet();
            }
        }

        @Override
        public void comments(int numberOfComments, boolean limited, String issueKey) {
            this.numberOfComments.accept((long)numberOfComments);
            if (limited) {
                this.numberOfTimesCommentsLimited.incrementAndGet();
                this.topIssuesWithLimitedComments.store((Object)issueKey);
                log.trace("Limiting indexing comments for issue: {numberOfComments:{}, limit:{}, issue:{}}", new Object[]{numberOfComments, this.settings.maxCommentsIndexed.getValueForSerialization(), issueKey});
            }
        }

        @Override
        public void worklogs(int numberOfWorklogs, boolean limited, String issueKey) {
            this.numberOfWorklogs.accept((long)numberOfWorklogs);
            if (limited) {
                this.numberOfTimesWorklogsLimited.incrementAndGet();
                this.topIssuesWithLimitedWorklogs.store((Object)issueKey);
                log.trace("Limiting indexing worklogs for issue: {numberOfWorklogs:{}, limit:{}, issue:{}}", new Object[]{numberOfWorklogs, this.settings.maxWorklogsIndexed.getValueForSerialization(), issueKey});
            }
        }

        @Override
        public void changeHistory(int numberOfChangeHistoryGroups, boolean limited, String issueKey) {
            this.numberOfChangeHistory.accept((long)numberOfChangeHistoryGroups);
            if (limited) {
                this.numberOfTimesChangeHistoryLimited.incrementAndGet();
                this.topIssuesWithLimitedChangeHistory.store((Object)issueKey);
                log.trace("Limiting indexing change history for issue: {numberOfChangeHistory:{}, limit:{}, issue:{}}", new Object[]{numberOfChangeHistoryGroups, this.settings.maxChangeHistoryIndexed.getValueForSerialization(), issueKey});
            }
        }

        @Override
        public void changeHistoryFiltering(long itemsBeforeFiltering, long itemsAfterFiltering, long groupsBeforeFiltering) {
            this.filtering.numberOfChangeHistoryItemsBeforeFiltering.accept(itemsBeforeFiltering);
            this.filtering.numberOfChangeHistoryItemsAfterFiltering.accept(itemsAfterFiltering);
            this.filtering.numberOfChangeHistoryBeforeFiltering.accept(groupsBeforeFiltering);
        }

        static class Settings {
            final LastValueSerializableStats<Integer> maxCommentsIndexed = new LastValueSerializableStats();
            final LastValueSerializableStats<Integer> maxWorklogsIndexed = new LastValueSerializableStats();
            final LastValueSerializableStats<Integer> maxChangeHistoryIndexed = new LastValueSerializableStats();
            final LastValueSerializableStats<Boolean> shouldFilterOutUnsupportedFields = new LastValueSerializableStats();

            Settings() {
            }
        }

        static class Filtering {
            MutableLongStats numberOfChangeHistoryBeforeFiltering = new MutableLongStats(new long[]{0L, 1L, 10L, 100L, 500L, 1000L, 10000L, 20000L, 50000L});
            MutableLongStats numberOfChangeHistoryItemsBeforeFiltering = new MutableLongStats(new long[]{0L, 1L, 10L, 100L, 500L, 1000L, 10000L, 20000L, 50000L});
            MutableLongStats numberOfChangeHistoryItemsAfterFiltering = new MutableLongStats(new long[]{0L, 1L, 10L, 100L, 500L, 1000L, 10000L, 20000L, 50000L});

            Filtering() {
            }
        }
    }
}

