/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.jira.config.util.IndexingConfiguration;
import com.atlassian.jira.index.ManagedIndexSearcher;
import com.atlassian.jira.index.ManagedIndexSearcherFactory;
import com.atlassian.jira.index.UnmanagedIndexSearcher;
import com.atlassian.jira.issue.index.IndexDirectoryFactory;
import com.atlassian.jira.issue.index.IssueIndexer;
import com.atlassian.jira.issue.index.SearchUnavailableException;
import com.atlassian.jira.issue.index.SearcherCache;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import org.apache.log4j.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadLocalSearcherCache
implements SearcherCache {
    private static final Logger log = LoggerFactory.getLogger(ThreadLocalSearcherCache.class);
    private final IssueIndexer issueIndexer;
    private final IndexingConfiguration indexingConfiguration;
    private static ThreadLocal<AtomicInteger> searcherContextExists = ThreadLocal.withInitial(() -> new AtomicInteger(0));

    public ThreadLocalSearcherCache(IssueIndexer issueIndexer, IndexingConfiguration indexingConfiguration) {
        this.issueIndexer = issueIndexer;
        this.indexingConfiguration = indexingConfiguration;
    }

    @Override
    @Nonnull
    public ManagedIndexSearcher getSearcher(IndexDirectoryFactory.Name index) {
        return Cache.getCache().retrieveEntitySearcher(this.issueIndexer, this.indexingConfiguration, index);
    }

    public static void startSearcherContext() {
        if (searcherContextExists.get().incrementAndGet() > 1 && log.isTraceEnabled()) {
            log.trace("Nested search context, level: {}, ", (Object)searcherContextExists.get().get(), (Object)new Throwable());
        }
    }

    public static void stopAndCloseSearcherContext() {
        if (ThreadLocalSearcherCache.tryStopSearcherContext()) {
            ThreadLocalSearcherCache.internalCloseSearchers();
        }
    }

    public static void checkClosed(boolean forceClose) {
        if (searcherContextExists.get().get() > 0) {
            log.warn(String.format("%s context should be: %d but is: %d. You can investigate who is responsible for not closing the context by setting the log level to: %s for: %s", ThreadLocalSearcherCache.class.getSimpleName(), 0, searcherContextExists.get().get(), Level.TRACE, ThreadLocalSearcherCache.class.getCanonicalName()));
            if (forceClose) {
                log.warn("Force-closing context");
                searcherContextExists.get().set(1);
                ThreadLocalSearcherCache.stopAndCloseSearcherContext();
            } else {
                log.warn("Not force-closing context");
            }
        }
    }

    @Deprecated
    public static void stopSearcherContext() {
        ThreadLocalSearcherCache.tryStopSearcherContext();
    }

    private static boolean tryStopSearcherContext() {
        if (searcherContextExists.get().get() == 0) {
            log.warn("Trying to stop an already stopped search context", new Throwable());
            return true;
        }
        return searcherContextExists.get().decrementAndGet() == 0;
    }

    public static boolean inSearcherContext() {
        return searcherContextExists.get().get() > 0;
    }

    public static void internalCloseSearchers() {
        Cache.getCache().closeSearchers();
    }

    static Cache getCache() {
        return Cache.getCache();
    }

    static class Cache {
        private static final ThreadLocal<Cache> THREAD_LOCAL = ThreadLocal.withInitial(() -> new Cache());
        private final Map<IndexDirectoryFactory.Name, UnmanagedIndexSearcher> entitySearchers = new EnumMap<IndexDirectoryFactory.Name, UnmanagedIndexSearcher>(IndexDirectoryFactory.Name.class);

        private Cache() {
        }

        static Cache getCache() {
            return THREAD_LOCAL.get();
        }

        ManagedIndexSearcher retrieveEntitySearcher(IssueIndexer issueIndexer, IndexingConfiguration indexingConfiguration, IndexDirectoryFactory.Name index) {
            if (!this.entitySearchers.containsKey((Object)index)) {
                try {
                    UnmanagedIndexSearcher unmanagedIndexSearcher = issueIndexer.openEntitySearcher(index);
                    this.entitySearchers.put(index, unmanagedIndexSearcher);
                }
                catch (RuntimeException e) {
                    throw new SearchUnavailableException(e, indexingConfiguration.isIndexAvailable());
                }
            }
            return ManagedIndexSearcherFactory.createFrom(this.entitySearchers.get((Object)index));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void closeSearchers() {
            try {
                Iterator<Map.Entry<IndexDirectoryFactory.Name, UnmanagedIndexSearcher>> entryIterator = this.entitySearchers.entrySet().iterator();
                while (entryIterator.hasNext()) {
                    Map.Entry<IndexDirectoryFactory.Name, UnmanagedIndexSearcher> searcher = entryIterator.next();
                    try {
                        this.closeSearcher(searcher.getValue());
                    }
                    catch (Exception e) {
                        log.error("Error while resetting searcher: " + (Object)((Object)searcher.getKey()) + " message: " + e.getMessage(), (Throwable)e);
                    }
                    finally {
                        entryIterator.remove();
                    }
                }
            }
            finally {
                THREAD_LOCAL.remove();
            }
        }

        private void closeSearcher(UnmanagedIndexSearcher searcher) {
            if (searcher != null) {
                searcher.close();
            }
        }
    }
}

