/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.analyzer;

import com.atlassian.jira.issue.index.analyzer.TextAnalyzer;
import com.google.common.base.Function;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.cjk.CJKBigramFilter;
import org.apache.lucene.analysis.cjk.CJKWidthFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;

public class CJKAnalyzer
extends TextAnalyzer {
    private final Function<TokenStream, TokenStream> stopWordFilter;

    public CJKAnalyzer(boolean indexing, Function<TokenStream, TokenStream> stopWordFilter) {
        super(indexing);
        this.stopWordFilter = stopWordFilter;
    }

    @Override
    public final Analyzer.TokenStreamComponents createComponents(String fieldName) {
        StandardTokenizer tokenizer;
        StandardTokenizer result = tokenizer = new StandardTokenizer();
        result = new CJKWidthFilter((TokenStream)result);
        result = new CJKBigramFilter((TokenStream)result);
        result = new LowerCaseFilter((TokenStream)result);
        result = this.wrapStreamForIndexing((TokenStream)result);
        result = (TokenStream)this.stopWordFilter.apply((Object)result);
        return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)result);
    }
}

