/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.impl.AbstractCustomFieldIndexer;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.Date;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateCustomFieldIndexer
extends AbstractCustomFieldIndexer {
    private static final Logger log = LoggerFactory.getLogger(DateCustomFieldIndexer.class);
    private final CustomField customField;
    private final boolean skipIndexingNull;

    public DateCustomFieldIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField, boolean skipIndexingNull) {
        super(fieldVisibilityManager, (CustomField)Assertions.notNull((String)"customField", (Object)customField));
        this.customField = customField;
        this.skipIndexingNull = skipIndexingNull;
    }

    public DateCustomFieldIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField) {
        this(fieldVisibilityManager, customField, false);
    }

    public void addDocumentFieldsSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue, true);
    }

    public void addDocumentFieldsNotSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue, false);
    }

    public Boolean skipsIndexingNull() {
        return this.skipIndexingNull;
    }

    private void addDocumentFields(Document doc, Issue issue, boolean searchable) {
        Object value = this.customField.getValue(issue);
        String sortDateFieldName = "sort_" + this.getDocumentFieldId();
        if (value instanceof Date) {
            Date date = (Date)value;
            if (date.getTime() >= 0L) {
                if (searchable) {
                    doc.add((IndexableField)new LongPoint(this.getDocumentFieldId(), new long[]{date.getTime()}));
                    doc.add((IndexableField)new NumericDocValuesField(this.getDocumentFieldId(), date.getTime()));
                }
                doc.add((IndexableField)new StoredField(this.getDocumentFieldId(), date.getTime()));
            } else {
                log.warn("Unable to index custom date field '" + this.customField.getName() + "(" + this.customField.getId() + ") with value: " + date.getTime());
            }
            doc.add((IndexableField)new LongPoint(sortDateFieldName, new long[]{date.getTime()}));
            doc.add((IndexableField)new NumericDocValuesField(sortDateFieldName, date.getTime()));
        } else if (value == null && !this.skipIndexingNull) {
            doc.add((IndexableField)new LongPoint(sortDateFieldName, new long[]{Long.MAX_VALUE}));
            doc.add((IndexableField)new NumericDocValuesField(sortDateFieldName, Long.MAX_VALUE));
        }
    }
}

