/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.managers;

import com.atlassian.cache.Supplier;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.plugin.JiraPluginCacheResetEvent;
import com.atlassian.jira.plugin.customfield.CustomFieldTypeModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.util.List;
import java.util.stream.Collectors;

public class CustomFieldSearcherManager {
    private final ResettableLazyReference<List<CustomFieldSearcher>> customFieldSearcherPluginsRef = CustomFieldSearcherManager.fromSupplier(() -> pluginAccessor.getEnabledModulesByClass(CustomFieldSearcher.class));

    public CustomFieldSearcherManager(PluginAccessor pluginAccessor, EventPublisher eventPublisher) {
        eventPublisher.register((Object)this);
    }

    private static <T> ResettableLazyReference<T> fromSupplier(final Supplier<T> supplier) {
        return new ResettableLazyReference<T>(){

            protected T create() throws Exception {
                return supplier.get();
            }
        };
    }

    public List<CustomFieldSearcher> getSearchersValidFor(CustomFieldType customFieldType) {
        return ((List)this.customFieldSearcherPluginsRef.get()).stream().filter(searcher -> this.isSearcherValidFor((CustomFieldSearcher)searcher, customFieldType)).collect(Collectors.toList());
    }

    private boolean isSearcherValidFor(CustomFieldSearcher searcher, CustomFieldType customFieldType) {
        CustomFieldTypeModuleDescriptor customFieldTypeDescriptor = customFieldType.getDescriptor();
        return searcher.getDescriptor().getValidCustomFieldKeys().contains(customFieldType.getKey()) || customFieldTypeDescriptor.getValidSearcherKeys().contains(searcher.getDescriptor().getCompleteKey());
    }

    @EventListener
    public void onJiraPluginCacheResetEvent(JiraPluginCacheResetEvent event) {
        this.customFieldSearcherPluginsRef.reset();
    }
}

