/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.priority;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.util.json.JSONTokener;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class PrioritySchemeMigrateRequestHelper {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final UserPropertyManager userPropertyManager;
    private static final String MIGRATE_PRIORITY_SCHEME_USER_PROPERTY_KEY = "jira.migratepriorityscheme";

    public PrioritySchemeMigrateRequestHelper(JiraAuthenticationContext jiraAuthenticationContext, UserPropertyManager userPropertyManager) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.userPropertyManager = userPropertyManager;
    }

    public void clearMigratePrioritySchemeRequest() {
        PropertySet propertySet = this.getPropertySet();
        propertySet.setText(MIGRATE_PRIORITY_SCHEME_USER_PROPERTY_KEY, null);
    }

    public Optional<MigratePrioritySchemeRequest> getMigratePrioritySchemeRequest() {
        PropertySet propertySet = this.getPropertySet();
        String migratePrioritySchemeJson = propertySet.getText(MIGRATE_PRIORITY_SCHEME_USER_PROPERTY_KEY);
        if (StringUtils.isBlank((CharSequence)migratePrioritySchemeJson)) {
            return Optional.empty();
        }
        return MigratePrioritySchemeRequest.fromJSON(migratePrioritySchemeJson);
    }

    public void storeMigratePrioritySchemeRequest(MigratePrioritySchemeRequest request) {
        PropertySet propertySet = this.getPropertySet();
        propertySet.setText(MIGRATE_PRIORITY_SCHEME_USER_PROPERTY_KEY, request.toJSON().toString());
    }

    private PropertySet getPropertySet() {
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        return this.userPropertyManager.getPropertySet(user);
    }

    public static class MigratePrioritySchemeRequest {
        @JsonProperty
        public final Collection<Long> projects;
        @JsonProperty
        public final long targetSchemeId;
        @JsonProperty
        public final boolean isEditingScheme;

        public MigratePrioritySchemeRequest(Collection<Long> projects, Long targetSchemeId, boolean isEditingScheme) {
            this.projects = projects;
            this.targetSchemeId = targetSchemeId;
            this.isEditingScheme = isEditingScheme;
        }

        public JSONObject toJSON() {
            try {
                JSONObject json = new JSONObject();
                JSONArray jsonProjects = new JSONArray();
                this.projects.forEach(arg_0 -> ((JSONArray)jsonProjects).put(arg_0));
                json.put("projects", (Object)jsonProjects);
                json.put("targetSchemeId", this.targetSchemeId);
                json.put("isEditingScheme", this.isEditingScheme);
                return json;
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }

        public static Optional<MigratePrioritySchemeRequest> fromJSON(JSONObject json) {
            try {
                JSONArray projectKeys = json.getJSONArray("projects");
                ImmutableList.Builder idList = ImmutableList.builder();
                for (int i = 0; i < projectKeys.length(); ++i) {
                    idList.add((Object)projectKeys.getLong(i));
                }
                return Optional.of(new MigratePrioritySchemeRequest((Collection<Long>)idList.build(), json.getLong("targetSchemeId"), json.getBoolean("isEditingScheme")));
            }
            catch (JSONException e) {
                return Optional.empty();
            }
        }

        public static Optional<MigratePrioritySchemeRequest> fromJSON(String s) {
            try {
                return MigratePrioritySchemeRequest.fromJSON(new JSONObject(new JSONTokener(s)));
            }
            catch (JSONException e) {
                return Optional.empty();
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MigratePrioritySchemeRequest that = (MigratePrioritySchemeRequest)o;
            return this.targetSchemeId == that.targetSchemeId && this.isEditingScheme == that.isEditingScheme && Objects.equals(this.projects, that.projects);
        }

        public int hashCode() {
            return Objects.hash(this.projects, this.targetSchemeId, this.isEditingScheme);
        }
    }
}

