/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers;

import com.atlassian.jira.issue.search.searchers.IssueSearcher;
import com.atlassian.jira.issue.search.searchers.SearcherGroupType;
import com.atlassian.jira.issue.search.searchers.impl.AffectedVersionsSearcher;
import com.atlassian.jira.issue.search.searchers.impl.AssigneeSearcher;
import com.atlassian.jira.issue.search.searchers.impl.CommentQuerySearcher;
import com.atlassian.jira.issue.search.searchers.impl.ComponentsSearcher;
import com.atlassian.jira.issue.search.searchers.impl.CreatedDateSearcher;
import com.atlassian.jira.issue.search.searchers.impl.DescriptionQuerySearcher;
import com.atlassian.jira.issue.search.searchers.impl.DueDateSearcher;
import com.atlassian.jira.issue.search.searchers.impl.EnvironmentQuerySearcher;
import com.atlassian.jira.issue.search.searchers.impl.FixForVersionsSearcher;
import com.atlassian.jira.issue.search.searchers.impl.IssueTypeSearcher;
import com.atlassian.jira.issue.search.searchers.impl.LabelsSearcher;
import com.atlassian.jira.issue.search.searchers.impl.PrioritySearcher;
import com.atlassian.jira.issue.search.searchers.impl.ProjectSearcher;
import com.atlassian.jira.issue.search.searchers.impl.ReporterSearcher;
import com.atlassian.jira.issue.search.searchers.impl.ResolutionDateSearcher;
import com.atlassian.jira.issue.search.searchers.impl.ResolutionSearcher;
import com.atlassian.jira.issue.search.searchers.impl.StatusSearcher;
import com.atlassian.jira.issue.search.searchers.impl.SummaryQuerySearcher;
import com.atlassian.jira.issue.search.searchers.impl.TextQuerySearcher;
import com.atlassian.jira.issue.search.searchers.impl.UpdatedDateSearcher;
import com.atlassian.jira.issue.search.searchers.impl.WorkRatioSearcher;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public final class SearcherComparatorFactory {
    private static final Map<SearcherGroupType, SearcherComparator> COMPARATOR_MAP = new MapBuilder().add(SearcherGroupType.TEXT, TextQuerySearcher.class, SummaryQuerySearcher.class, DescriptionQuerySearcher.class, EnvironmentQuerySearcher.class, CommentQuerySearcher.class).add(SearcherGroupType.CONTEXT, ProjectSearcher.class, IssueTypeSearcher.class).add(SearcherGroupType.PROJECT, FixForVersionsSearcher.class, ComponentsSearcher.class, AffectedVersionsSearcher.class).add(SearcherGroupType.ISSUE, ReporterSearcher.class, AssigneeSearcher.class, StatusSearcher.class, ResolutionSearcher.class, PrioritySearcher.class, LabelsSearcher.class).add(SearcherGroupType.DATE, CreatedDateSearcher.class, UpdatedDateSearcher.class, DueDateSearcher.class, ResolutionDateSearcher.class).add(SearcherGroupType.WORK, WorkRatioSearcher.class).add(SearcherGroupType.CUSTOM, new Class[0]).toImmutableMap();

    public static Comparator<IssueSearcher<?>> getSearcherComparator(SearcherGroupType searcherGroupType) {
        return COMPARATOR_MAP.get(searcherGroupType);
    }

    static final class SearcherComparator
    implements Comparator<IssueSearcher<?>> {
        private final List<Class<? extends IssueSearcher<?>>> orderList;

        @SafeVarargs
        SearcherComparator(Class<? extends IssueSearcher<?>> ... orderList) {
            this.orderList = ImmutableList.copyOf((Object[])orderList);
        }

        @Override
        public int compare(IssueSearcher<?> o1, IssueSearcher<?> o2) {
            int o1position = this.indexOf(o1);
            int o2position = this.indexOf(o2);
            if (o1position == -1) {
                if (o2position == -1) {
                    return 0;
                }
                return 1;
            }
            if (o2position == -1) {
                return -1;
            }
            return o1position - o2position;
        }

        private int indexOf(IssueSearcher<?> searcher) {
            return this.orderList.indexOf(searcher.getClass());
        }
    }

    static class MapBuilder {
        private ImmutableMap.Builder<SearcherGroupType, SearcherComparator> map = ImmutableMap.builder();

        MapBuilder() {
        }

        @SafeVarargs
        public final MapBuilder add(SearcherGroupType searcherGroupType, Class<? extends IssueSearcher<?>> ... classes) {
            this.map.put((Object)searcherGroupType, (Object)new SearcherComparator(classes));
            return this;
        }

        public Map<SearcherGroupType, SearcherComparator> toImmutableMap() {
            return this.map.build();
        }
    }
}

