/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.transformer;

import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.searchers.transformer.FieldFlagOperandRegistry;
import com.atlassian.jira.issue.search.searchers.transformer.NavigatorStructureChecker;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.search.searchers.util.DefaultIndexedInputHelper;
import com.atlassian.jira.issue.search.searchers.util.IndexedInputHelper;
import com.atlassian.jira.issue.transport.ActionParams;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.issue.util.transformers.JiraTransformers;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.resolver.IndexInfoResolver;
import com.atlassian.jira.jql.resolver.ProjectIndexInfoResolver;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserProjectHistoryManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.query.Query;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.TerminalClauseImpl;
import com.atlassian.query.operand.MultiValueOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operand.SingleValueOperand;
import com.atlassian.query.operator.Operator;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;

public class ProjectSearchInputTransformer
implements SearchInputTransformer {
    private final FieldFlagOperandRegistry fieldFlagOperandRegistry;
    private final JqlOperandResolver operandResolver;
    private final ProjectIndexInfoResolver projectIndexInfoResolver;
    private final ProjectManager projectManager;
    private final UserProjectHistoryManager projectHistoryManager;
    private final JiraAuthenticationContext authenticationContext;

    public ProjectSearchInputTransformer(ProjectIndexInfoResolver projectIndexInfoResolver, JqlOperandResolver operandResolver, FieldFlagOperandRegistry fieldFlagOperandRegistry, ProjectManager projectManager, UserProjectHistoryManager projectHistoryManager, JiraAuthenticationContext authenticationContext) {
        this.fieldFlagOperandRegistry = fieldFlagOperandRegistry;
        this.operandResolver = operandResolver;
        this.projectIndexInfoResolver = projectIndexInfoResolver;
        this.projectManager = projectManager;
        this.projectHistoryManager = projectHistoryManager;
        this.authenticationContext = authenticationContext;
    }

    public void populateFromParams(ApplicationUser user, FieldValuesHolder fieldValuesHolder, ActionParams actionParams) {
        String url;
        String[] params = actionParams.getValuesForKey(url = SystemSearchConstants.forProject().getUrlParameter());
        fieldValuesHolder.put((Object)url, params == null ? null : Sets.newLinkedHashSet(Arrays.asList(params)));
    }

    public void validateParams(ApplicationUser user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, I18nHelper i18nHelper, ErrorCollection errors) {
    }

    public void populateFromQuery(ApplicationUser user, FieldValuesHolder fieldValuesHolder, Query query, SearchContext searchContext) {
        Set<String> uncleanedValues = this.getNavigatorValuesAsStrings(user, query);
        ArrayList<String> values = new ArrayList<String>(uncleanedValues);
        CollectionUtils.transform(values, (Transformer)JiraTransformers.NULL_SWAP);
        fieldValuesHolder.put((Object)SystemSearchConstants.forProject().getUrlParameter(), values);
        this.setProjectIdInSession(uncleanedValues);
    }

    public boolean doRelevantClausesFitFilterForm(ApplicationUser user, Query query, SearchContext searchContext) {
        return this.createNavigatorStructureChecker().checkSearchRequest(query);
    }

    public Set<String> getIdValuesAsStrings(ApplicationUser searcher, Query query) {
        IndexedInputHelper helper = this.createIndexedInputHelper();
        return helper.getAllIndexValuesForMatchingClauses(searcher, SystemSearchConstants.forProject().getJqlClauseNames(), query);
    }

    private Set<String> getNavigatorValuesAsStrings(ApplicationUser searcher, Query query) {
        IndexedInputHelper helper = this.createIndexedInputHelper();
        return helper.getAllNavigatorValuesForMatchingClauses(searcher, SystemSearchConstants.forProject().getJqlClauseNames(), query);
    }

    public Clause getSearchClause(ApplicationUser user, FieldValuesHolder fieldValuesHolder) {
        List projects = (List)fieldValuesHolder.get((Object)SystemSearchConstants.forProject().getUrlParameter());
        if (projects == null || projects.isEmpty()) {
            return null;
        }
        ArrayList operands = Lists.newArrayListWithCapacity((int)projects.size());
        for (String idStr : projects) {
            if (idStr.equals("-1")) continue;
            operands.add(user == null ? new SingleValueOperand(idStr) : this.getProjectOperandForIdString(idStr));
        }
        if (operands.size() == 1) {
            return new TerminalClauseImpl(SystemSearchConstants.forProject().getJqlClauseNames().getPrimaryName(), Operator.EQUALS, (Operand)operands.get(0));
        }
        return new TerminalClauseImpl(SystemSearchConstants.forProject().getJqlClauseNames().getPrimaryName(), Operator.IN, (Operand)new MultiValueOperand((Collection)operands));
    }

    private SingleValueOperand getProjectOperandForIdString(String idStr) {
        try {
            Long id = new Long(idStr);
            Project project = this.projectManager.getProjectObj(id);
            SingleValueOperand o = project == null ? new SingleValueOperand(id) : new SingleValueOperand(project.getKey());
            return o;
        }
        catch (NumberFormatException e) {
            return new SingleValueOperand(idStr);
        }
    }

    void setProjectIdInSession(Set<String> selectedProjectIds) {
        Project project;
        String idStr;
        Long id;
        if (selectedProjectIds != null && selectedProjectIds.size() == 1 && (id = this.getValueAsLong(idStr = selectedProjectIds.iterator().next())) != null && (project = this.projectManager.getProjectObj(id)) != null) {
            this.projectHistoryManager.addProjectToHistory(this.authenticationContext.getUser(), project);
        }
    }

    NavigatorStructureChecker createNavigatorStructureChecker() {
        return new NavigatorStructureChecker(SystemSearchConstants.forProject().getJqlClauseNames(), false, this.fieldFlagOperandRegistry, this.operandResolver);
    }

    IndexedInputHelper createIndexedInputHelper() {
        return new DefaultIndexedInputHelper((IndexInfoResolver)this.projectIndexInfoResolver, this.operandResolver, this.fieldFlagOperandRegistry);
    }

    private Long getValueAsLong(String value) {
        try {
            return new Long(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

