/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.util;

import com.atlassian.jira.issue.search.util.LuceneQueryModifier;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;

public class DefaultLuceneQueryModifier
implements LuceneQueryModifier {
    @Override
    public Query getModifiedQuery(Query originalQuery) {
        Assertions.notNull((String)"originalQuery", (Object)originalQuery);
        if (originalQuery instanceof BooleanQuery) {
            return this.transformBooleanQuery((BooleanQuery)originalQuery);
        }
        if (originalQuery instanceof BoostQuery) {
            BoostQuery originalBoostQuery = (BoostQuery)originalQuery;
            return DefaultLuceneQueryModifier.copyBoost(this.getModifiedQuery(originalBoostQuery.getQuery()), (Query)originalBoostQuery);
        }
        return originalQuery;
    }

    private Query transformBooleanQuery(BooleanQuery originalQuery) {
        QueryBucket queryBucket = new QueryBucket(originalQuery);
        if (queryBucket.containsOnlyNot()) {
            return this.handleOnlyNot(queryBucket);
        }
        if (queryBucket.containsMust()) {
            return this.handleContainsMust(queryBucket);
        }
        if (queryBucket.containsShould()) {
            return this.handleContainsShould(queryBucket);
        }
        return new BooleanQuery.Builder().build();
    }

    private Query handleContainsShould(QueryBucket queryBucket) {
        Preconditions.checkArgument((!queryBucket.containsMust() ? 1 : 0) != 0);
        BooleanQuery.Builder query = new BooleanQuery.Builder();
        BooleanQuery originalQuery = queryBucket.getOriginalBooleanQuery();
        query.setMinimumNumberShouldMatch(originalQuery.getMinimumNumberShouldMatch());
        for (Query shouldQuery : queryBucket.getShouldQueries()) {
            query.add(this.getModifiedQuery(shouldQuery), BooleanClause.Occur.SHOULD);
        }
        for (Query origNotQuery : queryBucket.getNotQueries()) {
            BooleanQuery.Builder notWithMatchAll = new BooleanQuery.Builder();
            Query notQuery = origNotQuery instanceof BoostQuery ? ((BoostQuery)origNotQuery).getQuery() : origNotQuery;
            notWithMatchAll.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.FILTER);
            if (notQuery instanceof BooleanQuery) {
                notWithMatchAll.setMinimumNumberShouldMatch(((BooleanQuery)notQuery).getMinimumNumberShouldMatch());
                notQuery = this.setMinimumNumberShouldMatch((BooleanQuery)notQuery, 0);
            }
            notWithMatchAll.add(this.getModifiedQuery(notQuery), BooleanClause.Occur.MUST_NOT);
            query.add(DefaultLuceneQueryModifier.copyBoost((Query)notWithMatchAll.build(), origNotQuery), BooleanClause.Occur.SHOULD);
        }
        return DefaultLuceneQueryModifier.copyBoost((Query)query.build(), (Query)originalQuery);
    }

    private Query setMinimumNumberShouldMatch(BooleanQuery originalQuery, int minimumNumberShouldMatch) {
        BooleanQuery.Builder modifiedQuery = new BooleanQuery.Builder();
        for (BooleanClause clause : originalQuery.clauses()) {
            modifiedQuery.add(clause);
        }
        modifiedQuery.setMinimumNumberShouldMatch(minimumNumberShouldMatch);
        return modifiedQuery.build();
    }

    private Query handleContainsMust(QueryBucket queryBucket) {
        BooleanQuery.Builder query = new BooleanQuery.Builder();
        BooleanQuery originalBooleanQuery = queryBucket.getOriginalBooleanQuery();
        query.setMinimumNumberShouldMatch(originalBooleanQuery.getMinimumNumberShouldMatch());
        List booleanClauses = originalBooleanQuery.clauses();
        for (BooleanClause booleanClause : booleanClauses) {
            Query subQuery = booleanClause.getQuery();
            BooleanClause.Occur subOccur = booleanClause.getOccur();
            query.add(this.getModifiedQuery(subQuery), subOccur);
        }
        return query.build();
    }

    private Query handleOnlyNot(QueryBucket queryBucket) {
        BooleanQuery.Builder query = new BooleanQuery.Builder();
        BooleanQuery originalQuery = queryBucket.getOriginalBooleanQuery();
        query.setMinimumNumberShouldMatch(originalQuery.getMinimumNumberShouldMatch());
        query.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.FILTER);
        for (Query notQuery : queryBucket.getNotQueries()) {
            query.add(this.getModifiedQuery(notQuery), BooleanClause.Occur.MUST_NOT);
        }
        return DefaultLuceneQueryModifier.copyBoost((Query)query.build(), (Query)originalQuery);
    }

    private static Query copyBoost(Query toQuery, Query fromQuery) {
        float boost;
        if (fromQuery instanceof BoostQuery && (boost = ((BoostQuery)fromQuery).getBoost()) != 1.0f) {
            return new BoostQuery(toQuery, boost);
        }
        return toQuery;
    }

    private static class QueryBucket {
        private final List<Query> notQueries;
        private final List<Query> mustQueries;
        private final List<Query> shouldQueries;
        private final BooleanQuery booleanQuery;

        public QueryBucket(BooleanQuery booleanQuery) {
            this.booleanQuery = booleanQuery;
            this.notQueries = new ArrayList<Query>();
            this.mustQueries = new ArrayList<Query>();
            this.shouldQueries = new ArrayList<Query>();
            this.init(booleanQuery.clauses());
        }

        public BooleanQuery getOriginalBooleanQuery() {
            return this.booleanQuery;
        }

        public boolean containsOnlyNot() {
            return !this.notQueries.isEmpty() && this.mustQueries.isEmpty() && this.shouldQueries.isEmpty();
        }

        public boolean containsMust() {
            return !this.mustQueries.isEmpty();
        }

        public boolean containsShould() {
            return !this.shouldQueries.isEmpty();
        }

        public List<Query> getNotQueries() {
            return this.notQueries;
        }

        public List<Query> getShouldQueries() {
            return this.shouldQueries;
        }

        private void init(List<BooleanClause> booleanClauses) {
            block5: for (BooleanClause booleanClause : booleanClauses) {
                BooleanClause.Occur clauseOccur = booleanClause.getOccur();
                Query clauseQuery = booleanClause.getQuery();
                switch (clauseOccur) {
                    case MUST_NOT: {
                        this.notQueries.add(clauseQuery);
                        continue block5;
                    }
                    case MUST: 
                    case FILTER: {
                        this.mustQueries.add(clauseQuery);
                        continue block5;
                    }
                    case SHOULD: {
                        this.shouldQueries.add(clauseQuery);
                        continue block5;
                    }
                }
                throw new AssertionError((Object)("Unknown occur: " + clauseOccur));
            }
        }
    }
}

