/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.statistics;

import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.issue.statistics.ComponentStatisticsManager;
import com.atlassian.jira.issue.statistics.StatisticsManager;
import com.atlassian.jira.project.Project;
import com.atlassian.query.Query;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;

public class ComponentStatisticsManagerImpl
implements ComponentStatisticsManager {
    private StatisticsManager statisticsManager;
    private ProjectComponentManager projectComponentManager;

    public ComponentStatisticsManagerImpl(StatisticsManager statisticsManager, ProjectComponentManager projectComponentManager) {
        this.statisticsManager = statisticsManager;
        this.projectComponentManager = projectComponentManager;
    }

    public Map<Project, Map<ProjectComponent, Integer>> getProjectsWithComponentsWithIssueCount(Optional<Query> query) {
        Map<Project, Map<ProjectComponent, Integer>> result = this.statisticsManager.getProjectsWithItemsWithIssueCount(query, component -> component.getProjectId(), "components");
        for (Project project : result.keySet()) {
            Collection componentsInProject = this.projectComponentManager.findAllForProject(project.getId());
            Map<ProjectComponent, Integer> componentToCount = result.get(project);
            for (ProjectComponent component2 : componentsInProject) {
                if (componentToCount.containsKey(component2)) continue;
                componentToCount.put(component2, 0);
            }
        }
        return result;
    }
}

