/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.status;

import com.atlassian.jira.issue.status.SimpleStatus;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.issue.status.category.StatusCategory;
import com.atlassian.jira.util.I18nHelper;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import java.util.Objects;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class SimpleStatusImpl
implements SimpleStatus {
    private final String id;
    private final String name;
    private final String description;
    private final StatusCategory statusCategory;
    private final String iconUrl;

    public SimpleStatusImpl(String id, String name, String description, StatusCategory statusCategory, String iconUrl) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.statusCategory = statusCategory;
        this.iconUrl = iconUrl;
    }

    public SimpleStatusImpl(Status status) {
        this(status.getId(), status.getNameTranslation(), status.getDescTranslation(), status.getStatusCategory(), status.getCompleteIconUrl());
    }

    public SimpleStatusImpl(Status status, I18nHelper i18nHelper) {
        this(status.getId(), status.getNameTranslation(i18nHelper), status.getDescTranslation(i18nHelper), status.getStatusCategory(), status.getCompleteIconUrl());
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public StatusCategory getStatusCategory() {
        return this.statusCategory;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimpleStatusImpl)) {
            return false;
        }
        SimpleStatusImpl that = (SimpleStatusImpl)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.statusCategory, that.statusCategory) && Objects.equals(this.iconUrl, that.iconUrl);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.description, this.statusCategory, this.iconUrl);
    }
}

