/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.tabpanels;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.issue.tabpanels.ActionExpanderFactory;
import com.atlassian.jira.issue.tabpanels.TabExpanderAction;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanelModuleDescriptor;
import com.atlassian.jira.plugin.issuetabpanel.TabPanelOrder;
import com.atlassian.jira.template.soy.SoyTemplateRendererProvider;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class ActionExpanderFactoryImpl
implements ActionExpanderFactory,
Startable {
    private static final Logger log = LoggerFactory.getLogger(ActionExpanderFactoryImpl.class);
    private final SoyTemplateRendererProvider templateRendererProvider;
    private SoyTemplateRenderer soyTemplateRenderer;

    public ActionExpanderFactoryImpl(SoyTemplateRendererProvider soyTemplateRendererProvider) {
        this.templateRendererProvider = soyTemplateRendererProvider;
    }

    public void start() throws Exception {
        this.soyTemplateRenderer = this.templateRendererProvider.getRenderer();
    }

    public TabExpanderAction.ShowNewer getNewerActionsExpander(IssueTabPanelModuleDescriptor moduleDescriptor, String issueKey, Date fromDate, TabPanelOrder order) {
        Map params = MapBuilder.newBuilder().add((Object)"expanderText", (Object)moduleDescriptor.getLoadNewerLabel()).add((Object)"expanderShowAllText", (Object)moduleDescriptor.getLoadAllNewerLabel()).toMap();
        return new TabExpanderAction.ShowNewer(this.soyTemplateRenderer, this.extendParams(params, issueKey, this.getDateFormatted(fromDate), order, moduleDescriptor));
    }

    public TabExpanderAction.ShowOlder getOlderActionsExpander(IssueTabPanelModuleDescriptor moduleDescriptor, String issueKey, Date fromDate, TabPanelOrder order) {
        Map params = MapBuilder.newBuilder().add((Object)"expanderText", (Object)moduleDescriptor.getLoadOlderLabel()).add((Object)"expanderShowAllText", (Object)moduleDescriptor.getLoadAllOlderLabel()).toMap();
        return new TabExpanderAction.ShowOlder(this.soyTemplateRenderer, this.extendParams(params, issueKey, this.getDateFormatted(fromDate), order, moduleDescriptor));
    }

    private Map<String, Object> extendParams(Map<String, Object> params, String issueKey, String lastItemFromDate, TabPanelOrder order, IssueTabPanelModuleDescriptor moduleDescriptor) {
        String orderString = order == TabPanelOrder.OLDEST_FIRST ? "asc" : "desc";
        return MapBuilder.newBuilder(params).add((Object)"issueKey", (Object)issueKey).add((Object)"fromDate", (Object)lastItemFromDate).add((Object)"actionOrder", (Object)orderString).add((Object)"panelKey", (Object)moduleDescriptor.getCompleteKey()).add((Object)"tabType", (Object)moduleDescriptor.getKey()).toMap();
    }

    @VisibleForTesting
    protected String getDateFormatted(Date date) {
        String formatted = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(date);
        try {
            return URLEncoder.encode(formatted, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("Failed to format the date", (Throwable)e);
            return formatted;
        }
    }
}

