/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.util;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchQuery;
import com.atlassian.jira.issue.statistics.util.FieldDocumentHitCollector;
import com.atlassian.jira.issue.util.AggregateTimeTrackingBean;
import com.atlassian.jira.issue.util.AggregateTimeTrackingCalculator;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.Query;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Collector;

public class DocumentIssueAggregateTimeTrackingCalculator
implements AggregateTimeTrackingCalculator {
    private final JiraAuthenticationContext context;
    private final SearchProvider searchProvider;
    private final LuceneFieldSorter remainingEstimateSorter;
    private final LuceneFieldSorter originalEstimateSorter;
    private final LuceneFieldSorter timeSpentSorter;

    public DocumentIssueAggregateTimeTrackingCalculator(JiraAuthenticationContext context, SearchProvider searchProvider, FieldManager fieldManager) {
        this.context = context;
        this.searchProvider = searchProvider;
        this.originalEstimateSorter = this.getSorter(fieldManager, "timeoriginalestimate");
        this.timeSpentSorter = this.getSorter(fieldManager, "timespent");
        this.remainingEstimateSorter = this.getSorter(fieldManager, "timeestimate");
    }

    LuceneFieldSorter getSorter(FieldManager fieldManager, String field) {
        return fieldManager.getNavigableField(field).getSorter();
    }

    public AggregateTimeTrackingBean getAggregates(Issue issue) {
        if (issue == null) {
            throw new IllegalArgumentException("The issue must not be null");
        }
        AggregateTimeTrackingBean aggregateBean = new AggregateTimeTrackingBean(issue.getOriginalEstimate(), issue.getEstimate(), issue.getTimeSpent(), 0);
        if (issue.isSubTask()) {
            return aggregateBean;
        }
        Query query = this.getSubTaskClause(issue.getId()).buildQuery();
        AggregateHitCollector collector = new AggregateHitCollector(aggregateBean, this.remainingEstimateSorter, this.originalEstimateSorter, this.timeSpentSorter);
        try {
            this.searchProvider.search(SearchQuery.create((Query)query, (ApplicationUser)this.getUser()), (Collector)collector);
            aggregateBean.setSubTaskCount(collector.getInvocationCount());
        }
        catch (SearchException e) {
            throw new RuntimeException(e);
        }
        return aggregateBean;
    }

    ApplicationUser getUser() {
        return this.context.getUser();
    }

    JqlClauseBuilder getSubTaskClause(Long issueId) {
        return JqlQueryBuilder.newBuilder().where().issueParent().eq(issueId);
    }

    static class AggregateHitCollector
    extends FieldDocumentHitCollector {
        private final AggregateTimeTrackingBean aggregateBean;
        final LuceneFieldSorter originalEstimateSorter;
        final LuceneFieldSorter timeSpentSorter;
        final LuceneFieldSorter remainingEstimateSorter;
        final Set<String> fieldsToLoad;
        int invocationCount = 0;

        public AggregateHitCollector(AggregateTimeTrackingBean bean, LuceneFieldSorter remainingEstimateSorter, LuceneFieldSorter originalEstimateSorter, LuceneFieldSorter timeSpentSorter) {
            this.aggregateBean = bean;
            this.originalEstimateSorter = originalEstimateSorter;
            this.timeSpentSorter = timeSpentSorter;
            this.remainingEstimateSorter = remainingEstimateSorter;
            this.fieldsToLoad = ImmutableSet.of((Object)timeSpentSorter.getDocumentConstant(), (Object)originalEstimateSorter.getDocumentConstant(), (Object)remainingEstimateSorter.getDocumentConstant());
        }

        protected Set<String> getFieldsToLoad() {
            return this.fieldsToLoad;
        }

        public void collect(Document d) {
            Long timeSpent = this.getValueFromDocument(d, this.timeSpentSorter);
            Long remainingEstimate = this.getValueFromDocument(d, this.remainingEstimateSorter);
            Long originalEstimate = this.getValueFromDocument(d, this.originalEstimateSorter);
            this.aggregateBean.setTimeSpent(AggregateTimeTrackingBean.addAndPreserveNull((Long)this.aggregateBean.getTimeSpent(), (Long)timeSpent));
            this.aggregateBean.setRemainingEstimate(AggregateTimeTrackingBean.addAndPreserveNull((Long)this.aggregateBean.getRemainingEstimate(), (Long)remainingEstimate));
            this.aggregateBean.setOriginalEstimate(AggregateTimeTrackingBean.addAndPreserveNull((Long)this.aggregateBean.getOriginalEstimate(), (Long)originalEstimate));
            this.aggregateBean.bumpGreatestSubTaskEstimate(originalEstimate, remainingEstimate, originalEstimate);
            ++this.invocationCount;
        }

        Long getValueFromDocument(Document d, LuceneFieldSorter sorter) {
            return (Long)sorter.getValueFromLuceneField(this.getRawDocumentValue(d, sorter.getDocumentConstant()));
        }

        String getRawDocumentValue(Document d, String documentConstant) {
            return d.get(documentConstant);
        }

        public int getInvocationCount() {
            return this.invocationCount;
        }

        public boolean needsScores() {
            return false;
        }
    }
}

