/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.util.streamingretrievers;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.jira.database.DatabaseAccessor;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.database.QueryDslUtils;
import com.atlassian.jira.issue.util.streamingretrievers.BaseStreamingRetriever;
import com.atlassian.jira.model.querydsl.ActionDTO;
import com.atlassian.jira.model.querydsl.QAction;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public class StreamingActionDTORetriever
extends BaseStreamingRetriever<Long, String, ActionDTO> {
    private final QueryDslAccessor qdslAccessor;
    private final DatabaseAccessor dbAccessor;

    public StreamingActionDTORetriever(QueryDslAccessor qdslAccessor, DatabaseAccessor dbAccessor) {
        this.qdslAccessor = qdslAccessor;
        this.dbAccessor = dbAccessor;
    }

    @Override
    public Stream<List<ActionDTO>> stream(String bodySubstring, int batchSize) {
        return super.stream(bodySubstring, batchSize);
    }

    @Override
    protected List<Long> getEntityIds(String bodySubstring) {
        return this.qdslAccessor.executeQuery(con -> ((SQLQuery)((SQLQuery)((SQLQuery)con.newSqlQuery().select(QAction.ACTION.id).from((Expression)QAction.ACTION)).where((Predicate)QueryDslUtils.safeContainsIgnoreCase(this.dbAccessor.getDatabaseVendor(), QAction.ACTION.body, bodySubstring))).orderBy(QAction.ACTION.issue.asc())).fetch());
    }

    @Override
    protected List<ActionDTO> getEntitiesBatchByIds(List<Long> idsBatch) {
        return this.qdslAccessor.executeQuery(con -> ((SQLQuery)((SQLQuery)((SQLQuery)con.newSqlQuery().select((Expression)QAction.ACTION).from((Expression)QAction.ACTION)).where((Predicate)QAction.ACTION.id.in((Collection)idsBatch))).orderBy(QAction.ACTION.issue.asc())).fetch());
    }
}

