/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.builder;

import com.atlassian.jira.jql.builder.ConditionBuilder;
import com.atlassian.jira.jql.builder.DefaultValueBuilder;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.ValueBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.operand.EmptyOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operator.Operator;
import java.util.Collection;
import java.util.Date;

class DefaultConditionBuilder
implements ConditionBuilder {
    private final JqlClauseBuilder builder;
    private final String clauseName;

    DefaultConditionBuilder(String clauseName, JqlClauseBuilder builder) {
        this.builder = (JqlClauseBuilder)Assertions.notNull((String)"builder", (Object)builder);
        this.clauseName = (String)Assertions.notNull((String)"clauseName", (Object)clauseName);
    }

    public ValueBuilder eq() {
        return new DefaultValueBuilder(this.builder, this.clauseName, Operator.EQUALS);
    }

    public JqlClauseBuilder eq(String value) {
        return this.builder.addStringCondition(this.clauseName, Operator.EQUALS, value);
    }

    public JqlClauseBuilder eq(Long value) {
        return this.builder.addNumberCondition(this.clauseName, Operator.EQUALS, value);
    }

    public JqlClauseBuilder eq(Date date) {
        return this.builder.addDateCondition(this.clauseName, Operator.EQUALS, date);
    }

    public JqlClauseBuilder eq(Operand operand) {
        return this.builder.addCondition(this.clauseName, Operator.EQUALS, operand);
    }

    public JqlClauseBuilder eqEmpty() {
        return this.builder.addCondition(this.clauseName, Operator.EQUALS, (Operand)EmptyOperand.EMPTY);
    }

    public JqlClauseBuilder eqFunc(String funcName) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.EQUALS, funcName);
    }

    public JqlClauseBuilder eqFunc(String funcName, String ... args) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.EQUALS, funcName, args);
    }

    public JqlClauseBuilder eqFunc(String funcName, Collection<String> args) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.EQUALS, funcName, args);
    }

    public ValueBuilder notEq() {
        return new DefaultValueBuilder(this.builder, this.clauseName, Operator.NOT_EQUALS);
    }

    public JqlClauseBuilder notEq(String value) {
        return this.builder.addStringCondition(this.clauseName, Operator.NOT_EQUALS, value);
    }

    public JqlClauseBuilder notEq(Long value) {
        return this.builder.addNumberCondition(this.clauseName, Operator.NOT_EQUALS, value);
    }

    public JqlClauseBuilder notEq(Operand operand) {
        return this.builder.addCondition(this.clauseName, Operator.NOT_EQUALS, operand);
    }

    public JqlClauseBuilder notEq(Date date) {
        return this.builder.addDateCondition(this.clauseName, Operator.NOT_EQUALS, date);
    }

    public JqlClauseBuilder notEqEmpty() {
        return this.builder.addCondition(this.clauseName, Operator.NOT_EQUALS, (Operand)EmptyOperand.EMPTY);
    }

    public JqlClauseBuilder notEqFunc(String funcName) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.NOT_EQUALS, funcName);
    }

    public JqlClauseBuilder notEqFunc(String funcName, String ... args) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.NOT_EQUALS, funcName, args);
    }

    public JqlClauseBuilder notEqFunc(String funcName, Collection<String> args) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.NOT_EQUALS, funcName, args);
    }

    public ValueBuilder like() {
        return new DefaultValueBuilder(this.builder, this.clauseName, Operator.LIKE);
    }

    public JqlClauseBuilder like(String value) {
        return this.builder.addStringCondition(this.clauseName, Operator.LIKE, value);
    }

    public JqlClauseBuilder like(Long value) {
        return this.builder.addNumberCondition(this.clauseName, Operator.LIKE, value);
    }

    public JqlClauseBuilder like(Operand operand) {
        return this.builder.addCondition(this.clauseName, Operator.LIKE, operand);
    }

    public JqlClauseBuilder like(Date date) {
        return this.builder.addDateCondition(this.clauseName, Operator.LIKE, date);
    }

    public JqlClauseBuilder likeFunc(String funcName) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.LIKE, funcName);
    }

    public JqlClauseBuilder likeFunc(String funcName, String ... args) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.LIKE, funcName, args);
    }

    public JqlClauseBuilder likeFunc(String funcName, Collection<String> args) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.LIKE, funcName, args);
    }

    public ValueBuilder notLike() {
        return new DefaultValueBuilder(this.builder, this.clauseName, Operator.NOT_LIKE);
    }

    public JqlClauseBuilder notLike(String value) {
        return this.builder.addStringCondition(this.clauseName, Operator.NOT_LIKE, value);
    }

    public JqlClauseBuilder notLike(Long value) {
        return this.builder.addNumberCondition(this.clauseName, Operator.NOT_LIKE, value);
    }

    public JqlClauseBuilder notLike(Operand operand) {
        return this.builder.addCondition(this.clauseName, Operator.NOT_LIKE, operand);
    }

    public JqlClauseBuilder notLike(Date date) {
        return this.builder.addDateCondition(this.clauseName, Operator.NOT_LIKE, date);
    }

    public JqlClauseBuilder notLikeFunc(String funcName) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.NOT_LIKE, funcName);
    }

    public JqlClauseBuilder notLikeFunc(String funcName, String ... args) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.NOT_LIKE, funcName, args);
    }

    public JqlClauseBuilder notLikeFunc(String funcName, Collection<String> args) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.NOT_LIKE, funcName, args);
    }

    public ValueBuilder is() {
        return new DefaultValueBuilder(this.builder, this.clauseName, Operator.IS);
    }

    public JqlClauseBuilder isEmpty() {
        return this.builder.addCondition(this.clauseName, Operator.IS, (Operand)EmptyOperand.EMPTY);
    }

    public ValueBuilder isNot() {
        return new DefaultValueBuilder(this.builder, this.clauseName, Operator.IS_NOT);
    }

    public JqlClauseBuilder isNotEmpty() {
        return this.builder.addCondition(this.clauseName, Operator.IS_NOT, (Operand)EmptyOperand.EMPTY);
    }

    public ValueBuilder lt() {
        return new DefaultValueBuilder(this.builder, this.clauseName, Operator.LESS_THAN);
    }

    public JqlClauseBuilder lt(String value) {
        return this.builder.addStringCondition(this.clauseName, Operator.LESS_THAN, value);
    }

    public JqlClauseBuilder lt(Long value) {
        return this.builder.addNumberCondition(this.clauseName, Operator.LESS_THAN, value);
    }

    public JqlClauseBuilder lt(Operand operand) {
        return this.builder.addCondition(this.clauseName, Operator.LESS_THAN, operand);
    }

    public JqlClauseBuilder lt(Date date) {
        return this.builder.addDateCondition(this.clauseName, Operator.LESS_THAN, date);
    }

    public JqlClauseBuilder ltFunc(String funcName) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.LESS_THAN, funcName);
    }

    public JqlClauseBuilder ltFunc(String funcName, String ... args) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.LESS_THAN, funcName, args);
    }

    public JqlClauseBuilder ltFunc(String funcName, Collection<String> args) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.LESS_THAN, funcName, args);
    }

    public ValueBuilder ltEq() {
        return new DefaultValueBuilder(this.builder, this.clauseName, Operator.LESS_THAN_EQUALS);
    }

    public JqlClauseBuilder ltEq(String value) {
        return this.builder.addStringCondition(this.clauseName, Operator.LESS_THAN_EQUALS, value);
    }

    public JqlClauseBuilder ltEq(Long value) {
        return this.builder.addNumberCondition(this.clauseName, Operator.LESS_THAN_EQUALS, value);
    }

    public JqlClauseBuilder ltEq(Operand operand) {
        return this.builder.addCondition(this.clauseName, Operator.LESS_THAN_EQUALS, operand);
    }

    public JqlClauseBuilder ltEq(Date date) {
        return this.builder.addDateCondition(this.clauseName, Operator.LESS_THAN_EQUALS, date);
    }

    public JqlClauseBuilder ltEqFunc(String funcName) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.LESS_THAN_EQUALS, funcName);
    }

    public JqlClauseBuilder ltEqFunc(String funcName, String ... args) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.LESS_THAN_EQUALS, funcName, args);
    }

    public JqlClauseBuilder ltEqFunc(String funcName, Collection<String> args) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.LESS_THAN_EQUALS, funcName, args);
    }

    public ValueBuilder gt() {
        return new DefaultValueBuilder(this.builder, this.clauseName, Operator.GREATER_THAN);
    }

    public JqlClauseBuilder gt(String value) {
        return this.builder.addStringCondition(this.clauseName, Operator.GREATER_THAN, value);
    }

    public JqlClauseBuilder gt(Long value) {
        return this.builder.addNumberCondition(this.clauseName, Operator.GREATER_THAN, value);
    }

    public JqlClauseBuilder gt(Operand operand) {
        return this.builder.addCondition(this.clauseName, Operator.GREATER_THAN, operand);
    }

    public JqlClauseBuilder gt(Date date) {
        return this.builder.addDateCondition(this.clauseName, Operator.GREATER_THAN, date);
    }

    public JqlClauseBuilder gtFunc(String funcName) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.GREATER_THAN, funcName);
    }

    public JqlClauseBuilder gtFunc(String funcName, String ... args) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.GREATER_THAN, funcName, args);
    }

    public JqlClauseBuilder gtFunc(String funcName, Collection<String> args) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.GREATER_THAN, funcName, args);
    }

    public ValueBuilder gtEq() {
        return new DefaultValueBuilder(this.builder, this.clauseName, Operator.GREATER_THAN_EQUALS);
    }

    public JqlClauseBuilder gtEq(String value) {
        return this.builder.addStringCondition(this.clauseName, Operator.GREATER_THAN_EQUALS, value);
    }

    public JqlClauseBuilder gtEq(Long value) {
        return this.builder.addNumberCondition(this.clauseName, Operator.GREATER_THAN_EQUALS, value);
    }

    public JqlClauseBuilder gtEq(Operand operand) {
        return this.builder.addCondition(this.clauseName, Operator.GREATER_THAN_EQUALS, operand);
    }

    public JqlClauseBuilder gtEq(Date date) {
        return this.builder.addDateCondition(this.clauseName, Operator.GREATER_THAN_EQUALS, date);
    }

    public JqlClauseBuilder gtEqFunc(String funcName) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.GREATER_THAN_EQUALS, funcName);
    }

    public JqlClauseBuilder gtEqFunc(String funcName, String ... args) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.GREATER_THAN_EQUALS, funcName, args);
    }

    public JqlClauseBuilder gtEqFunc(String funcName, Collection<String> args) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.GREATER_THAN_EQUALS, funcName, args);
    }

    public ValueBuilder in() {
        return new DefaultValueBuilder(this.builder, this.clauseName, Operator.IN);
    }

    public JqlClauseBuilder in(String ... values) {
        return this.builder.addStringCondition(this.clauseName, Operator.IN, values);
    }

    public JqlClauseBuilder inStrings(Collection<String> values) {
        return this.builder.addStringCondition(this.clauseName, Operator.IN, values);
    }

    public JqlClauseBuilder in(Long ... values) {
        return this.builder.addNumberCondition(this.clauseName, Operator.IN, values);
    }

    public JqlClauseBuilder inNumbers(Collection<Long> values) {
        return this.builder.addNumberCondition(this.clauseName, Operator.IN, values);
    }

    public JqlClauseBuilder in(Operand ... operands) {
        return this.builder.addCondition(this.clauseName, Operator.IN, operands);
    }

    public JqlClauseBuilder inOperands(Collection<Operand> operands) {
        return this.builder.addCondition(this.clauseName, Operator.IN, operands);
    }

    public JqlClauseBuilder in(Date ... dates) {
        return this.builder.addDateCondition(this.clauseName, Operator.IN, dates);
    }

    public JqlClauseBuilder inDates(Collection<Date> dates) {
        return this.builder.addDateCondition(this.clauseName, Operator.IN, dates);
    }

    public JqlClauseBuilder inFunc(String funcName) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.IN, funcName);
    }

    public JqlClauseBuilder inFunc(String funcName, String ... args) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.IN, funcName, args);
    }

    public JqlClauseBuilder inFunc(String funcName, Collection<String> args) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.IN, funcName, args);
    }

    public ValueBuilder notIn() {
        return new DefaultValueBuilder(this.builder, this.clauseName, Operator.NOT_IN);
    }

    public JqlClauseBuilder notIn(String ... values) {
        return this.builder.addStringCondition(this.clauseName, Operator.NOT_IN, values);
    }

    public JqlClauseBuilder notInStrings(Collection<String> values) {
        return this.builder.addStringCondition(this.clauseName, Operator.NOT_IN, values);
    }

    public JqlClauseBuilder notIn(Long ... values) {
        return this.builder.addNumberCondition(this.clauseName, Operator.NOT_IN, values);
    }

    public JqlClauseBuilder notInNumbers(Collection<Long> values) {
        return this.builder.addNumberCondition(this.clauseName, Operator.NOT_IN, values);
    }

    public JqlClauseBuilder notIn(Operand ... operands) {
        return this.builder.addCondition(this.clauseName, Operator.NOT_IN, operands);
    }

    public JqlClauseBuilder notIn(Date ... dates) {
        return this.builder.addDateCondition(this.clauseName, Operator.NOT_IN, dates);
    }

    public JqlClauseBuilder notInDates(Collection<Date> dates) {
        return this.builder.addDateCondition(this.clauseName, Operator.NOT_IN, dates);
    }

    public JqlClauseBuilder notInOperands(Collection<Operand> operands) {
        return this.builder.addCondition(this.clauseName, Operator.NOT_IN, operands);
    }

    public JqlClauseBuilder notInFunc(String funcName) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.NOT_IN, funcName);
    }

    public JqlClauseBuilder notInFunc(String funcName, String ... args) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.NOT_IN, funcName, args);
    }

    public JqlClauseBuilder notInFunc(String funcName, Collection<String> args) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.NOT_IN, funcName, args);
    }

    public JqlClauseBuilder range(Date start, Date end) {
        return this.builder.addDateRangeCondition(this.clauseName, start, end);
    }

    public JqlClauseBuilder range(String start, String end) {
        return this.builder.addStringRangeCondition(this.clauseName, start, end);
    }

    public JqlClauseBuilder range(Long start, Long end) {
        return this.builder.addNumberRangeCondition(this.clauseName, start, end);
    }

    public JqlClauseBuilder range(Operand start, Operand end) {
        return this.builder.addRangeCondition(this.clauseName, start, end);
    }
}

