/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.index.ManagedIndexSearcher;
import com.atlassian.jira.issue.search.SearchProviderFactory;
import com.atlassian.jira.jql.operand.EmptyWasClauseOperandHandler;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.HistoryPredicateQueryFactory;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.jql.resolver.ChangeHistoryFieldIdResolver;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.WasClause;
import com.atlassian.query.operand.EmptyOperand;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.MultiValueOperand;
import com.atlassian.query.operator.Operator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.join.JoinUtil;
import org.apache.lucene.search.join.ScoreMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WasClauseQueryFactory {
    private static final Logger log = LoggerFactory.getLogger(WasClauseQueryFactory.class);
    private final SearchProviderFactory searchProviderFactory;
    private final JqlOperandResolver operandResolver;
    private final HistoryPredicateQueryFactory wasPredicateQueryFactory;
    private final EmptyWasClauseOperandHandler emptyWasClauseOperandHandler;
    private final ChangeHistoryFieldIdResolver changeHistoryFieldIdResolver;

    public WasClauseQueryFactory(SearchProviderFactory searchProviderFactory, JqlOperandResolver operandResolver, HistoryPredicateQueryFactory wasPredicateQueryFactory, EmptyWasClauseOperandHandler emptyWasClauseOperandHandler, ChangeHistoryFieldIdResolver changeHistoryFieldIdResolver) {
        this.searchProviderFactory = searchProviderFactory;
        this.operandResolver = operandResolver;
        this.changeHistoryFieldIdResolver = changeHistoryFieldIdResolver;
        this.wasPredicateQueryFactory = wasPredicateQueryFactory;
        this.emptyWasClauseOperandHandler = emptyWasClauseOperandHandler;
    }

    public QueryFactoryResult create(ApplicationUser searcher, WasClause clause) {
        Query historyQuery = this.makeQuery(searcher, clause);
        ManagedIndexSearcher historySearcher = this.searchProviderFactory.getSearcher("changes");
        try {
            if (log.isDebugEnabled()) {
                log.debug("Running history query (" + clause + "): " + historyQuery);
            }
            Query joinQuery = JoinUtil.createJoinQuery((String)"issue_id", (boolean)false, (String)"issue_id", (Query)historyQuery, (IndexSearcher)historySearcher, (ScoreMode)ScoreMode.None);
            boolean mustNotOccur = clause.getOperator() != Operator.WAS && clause.getOperator() != Operator.WAS_IN;
            return new QueryFactoryResult(joinQuery, mustNotOccur);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Query makeQuery(ApplicationUser searcher, WasClause clause) {
        BooleanQuery.Builder outerWasQuery = new BooleanQuery.Builder();
        boolean isEmptyOperand = clause.getOperand() instanceof EmptyOperand;
        ArrayList<QueryLiteral> literals = new ArrayList<QueryLiteral>();
        if (isEmptyOperand) {
            literals.addAll(this.emptyWasClauseOperandHandler.getEmptyValue(clause));
        } else if (clause.getOperand() instanceof MultiValueOperand) {
            literals.addAll(this.operandResolver.getValues(searcher, clause.getOperand(), (TerminalClause)clause));
        } else if (clause.getOperand() instanceof FunctionOperand) {
            literals.addAll(this.operandResolver.getValues(searcher, clause.getOperand(), (TerminalClause)clause));
        } else {
            literals.add(this.operandResolver.getSingleValue(searcher, clause.getOperand(), (TerminalClause)clause));
        }
        for (QueryLiteral literal : literals) {
            BooleanQuery.Builder wasQuery = new BooleanQuery.Builder();
            Collection ids = this.changeHistoryFieldIdResolver.resolveIdsForField(clause.getField(), literal, isEmptyOperand);
            if (ids == null || ids.isEmpty()) {
                if (literal != null) {
                    String value = literal.getLongValue() != null ? literal.getLongValue().toString() : literal.getStringValue();
                    TermQuery fromQuery = this.createTermQuery(clause, WasClauseQueryFactory.encodeProtocol(value), "ch_from");
                    TermQuery toQuery = this.createTermQuery(clause, WasClauseQueryFactory.encodeProtocol(value), "ch_to");
                    if (value != null && clause.getPredicate() == null) {
                        wasQuery.add((Query)fromQuery, BooleanClause.Occur.SHOULD);
                    }
                    wasQuery.add((Query)toQuery, BooleanClause.Occur.SHOULD);
                }
            } else {
                for (String id : ids) {
                    TermQuery fromQuery = this.createTermQuery(clause, WasClauseQueryFactory.encodeProtocolPreservingCase(id), "ch_oldvalue");
                    TermQuery toQuery = this.createTermQuery(clause, WasClauseQueryFactory.encodeProtocolPreservingCase(id), "ch_newvalue");
                    if (id != null && clause.getPredicate() == null) {
                        wasQuery.add((Query)fromQuery, BooleanClause.Occur.SHOULD);
                    }
                    wasQuery.add((Query)toQuery, BooleanClause.Occur.SHOULD);
                }
            }
            if (clause.getPredicate() != null) {
                BooleanQuery wasPredicateQuery = this.wasPredicateQueryFactory.makePredicateQuery(searcher, clause.getField().toLowerCase(), clause.getPredicate(), false);
                BooleanQuery.Builder wasWithPredicateQuery = new BooleanQuery.Builder();
                wasWithPredicateQuery.add((Query)wasQuery.build(), BooleanClause.Occur.MUST);
                wasWithPredicateQuery.add((Query)wasPredicateQuery, BooleanClause.Occur.MUST);
                wasQuery = wasWithPredicateQuery;
            }
            outerWasQuery.add((Query)wasQuery.build(), BooleanClause.Occur.SHOULD);
        }
        return outerWasQuery.build();
    }

    private TermQuery createTermQuery(WasClause clause, String value, String documentField) {
        return new TermQuery(new Term(clause.getField().toLowerCase() + '.' + documentField, value));
    }

    private static String encodeProtocol(String changeItem) {
        return "ch-" + (changeItem == null ? "" : changeItem.toLowerCase());
    }

    private static String encodeProtocolPreservingCase(String changeItem) {
        return "ch-" + (changeItem == null ? "" : changeItem);
    }
}

