/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.util;

import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.web.action.admin.translation.TranslationManager;
import java.util.Locale;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class TerminologyJqlAutocompleteAliasProvider {
    private static final Locale LOCALE_EN = Locale.ENGLISH;
    private final TranslationManager translationManager;

    public TerminologyJqlAutocompleteAliasProvider(TranslationManager translationManager) {
        this.translationManager = translationManager;
    }

    public Optional<String> getAliasForCustomField(CustomField customField) {
        String translation = this.translationManager.getCustomFieldNameTranslation(customField, LOCALE_EN);
        if (StringUtils.isEmpty((CharSequence)translation) || customField.getUntranslatedName().equals(translation)) {
            return Optional.empty();
        }
        return Optional.of(this.createAliasDisplayName(customField.getUntranslatedName(), translation));
    }

    public Optional<String> getAliasForIssueConstant(IssueConstant issueConstant) {
        String translation = issueConstant.getNameTranslation(LOCALE_EN.toString());
        if (StringUtils.isEmpty((CharSequence)translation) || issueConstant.getName().equals(translation)) {
            return Optional.empty();
        }
        return Optional.of(this.createAliasDisplayName(issueConstant.getName(), translation));
    }

    private String createAliasDisplayName(String originalName, String newName) {
        return String.format("%s (%s)", newName, originalName);
    }
}

