/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.license;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.license.BuildVersionLicenseCheck;
import com.atlassian.jira.license.BuildVersionLicenseCheckFailure;
import com.atlassian.jira.license.JiraLicenseManager;
import com.atlassian.jira.license.LicenseCheck;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.license.LicenseMaintenancePredicate;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;

public final class BuildVersionLicenseCheckImpl
implements BuildVersionLicenseCheck {
    private final JiraLicenseManager licenseManager;
    private final BuildUtilsInfo buildUtilsInfo;
    private final I18nHelper i18n;
    private final LicenseMaintenancePredicate isMaintenanceValid;
    private final DateTimeFormatter dateTimeFormatter;

    public BuildVersionLicenseCheckImpl(@Nonnull JiraLicenseManager licenseManager, @Nonnull BuildUtilsInfo buildUtilsInfo, @Nonnull I18nHelper i18n, @Nonnull DateTimeFormatter dateTimeFormatter, @Nonnull LicenseMaintenancePredicate isMaintenanceValid) {
        this.i18n = (I18nHelper)Assertions.notNull((String)"i18n", (Object)i18n);
        this.buildUtilsInfo = (BuildUtilsInfo)Assertions.notNull((String)"buildUtilsInfo", (Object)buildUtilsInfo);
        this.dateTimeFormatter = ((DateTimeFormatter)Assertions.notNull((String)"dateTimeFormatter", (Object)dateTimeFormatter)).withSystemZone();
        this.isMaintenanceValid = (LicenseMaintenancePredicate)Assertions.notNull((String)"isMaintenanceValid", (Object)isMaintenanceValid);
        this.licenseManager = (JiraLicenseManager)Assertions.notNull((String)"licenseManager", (Object)licenseManager);
    }

    @Override
    public LicenseCheck.Result evaluate() {
        return this.evaluate(true);
    }

    @Override
    public LicenseCheck.Result evaluateWithoutGracePeriod() {
        return this.evaluate(false);
    }

    private LicenseCheck.Result evaluate(boolean considerGracePeriodStatus) {
        Iterable licenses = this.licenseManager.getLicenses();
        if (Iterables.isEmpty((Iterable)licenses)) {
            return BuildVersionLicenseCheckFailure.noLicense();
        }
        Collection<LicenseDetails> versionOneLicenses = BuildVersionLicenseCheckImpl.getVersionOneLicenses(licenses);
        if (!versionOneLicenses.isEmpty()) {
            return new BuildVersionLicenseCheckFailure((List<? extends LicenseDetails>)ImmutableList.copyOf(versionOneLicenses), this.i18n.getText("setup.error.invalidlicensekey.v1.license.version"), BuildVersionLicenseCheckFailure.FailureType.VERSION_1_LICENSE_FOUND);
        }
        Collection<LicenseDetails> serverLicenses = this.getServerLicenses(licenses);
        if (!serverLicenses.isEmpty()) {
            return new BuildVersionLicenseCheckFailure((List<? extends LicenseDetails>)ImmutableList.copyOf(serverLicenses), this.i18n.getText("setup.error.invalidlicensekey.server.licence.used"), BuildVersionLicenseCheckFailure.FailureType.SERVER_LICENSE_FOUND);
        }
        if (considerGracePeriodStatus && this.licenseManager.hasLicenseTooOldForBuildConfirmationBeenDone()) {
            return PASS;
        }
        if (BuildVersionLicenseCheckImpl.allLicensesAreELAs(licenses)) {
            return PASS;
        }
        List<LicenseDetails> licensesPastMaintenance = this.getLicensesPastMaintenance(licenses);
        if (licensesPastMaintenance.isEmpty()) {
            return PASS;
        }
        return new BuildVersionLicenseCheckFailure(licensesPastMaintenance, this.getMaintenanceDateFailureMessage(licensesPastMaintenance), BuildVersionLicenseCheckFailure.FailureType.LICENSE_PAST_MAINTENANCE_DATE);
    }

    private Collection<LicenseDetails> getServerLicenses(Iterable<LicenseDetails> licenses) {
        return (Collection)StreamSupport.stream(licenses.spliterator(), false).filter(license -> !license.isDataCenter()).filter(license -> license.hasApplication(ApplicationKeys.CORE) || license.hasApplication(ApplicationKeys.SERVICE_DESK) || license.hasApplication(ApplicationKeys.SOFTWARE)).collect(CollectorsUtil.toImmutableList());
    }

    private static Collection<LicenseDetails> getVersionOneLicenses(Iterable<LicenseDetails> licenses) {
        return (Collection)StreamSupport.stream(licenses.spliterator(), false).filter(license -> license.getLicenseVersion() == 1).collect(CollectorsUtil.toImmutableList());
    }

    private List<LicenseDetails> getLicensesPastMaintenance(Iterable<LicenseDetails> licenses) {
        return (List)StreamSupport.stream(licenses.spliterator(), false).filter(this.isMaintenanceValid.negate()).collect(CollectorsUtil.toImmutableList());
    }

    private static boolean allLicensesAreELAs(Iterable<LicenseDetails> licenses) {
        return StreamSupport.stream(licenses.spliterator(), false).allMatch(LicenseDetails::isEnterpriseLicenseAgreement);
    }

    private String getMaintenanceDateFailureMessage(Collection<LicenseDetails> licensesPastMaintenance) {
        String expiredAppDescription = licensesPastMaintenance.stream().map(LicenseDetails::getApplicationDescription).collect(Collectors.joining(", "));
        Date expiryDateOfInstance = licensesPastMaintenance.stream().map(LicenseDetails::getMaintenanceExpiryDate).min(Date::compareTo).orElseThrow(() -> new IllegalStateException("Licenses past maintenance should have an expiry date"));
        return this.i18n.getText("admin.license.build.update.not.possible", this.buildUtilsInfo.getVersion(), this.dateTimeFormatter.format(expiryDateOfInstance), expiredAppDescription);
    }
}

