/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.license;

import com.atlassian.jira.license.ForgedLicenseDetector;
import com.atlassian.jira.license.JiraLicenseManager;
import com.atlassian.jira.license.LegitimacyLicenseCheck;
import com.atlassian.jira.license.LicenseCheck;
import com.atlassian.jira.license.LicenseDetails;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class LegitimacyLicenseCheckImpl
implements LegitimacyLicenseCheck {
    private final JiraLicenseManager jiraLicenseManager;
    private final ForgedLicenseDetector forgedLicenseDetector;

    public LegitimacyLicenseCheckImpl(JiraLicenseManager jiraLicenseManager, ForgedLicenseDetector forgedLicenseDetector) {
        this.jiraLicenseManager = jiraLicenseManager;
        this.forgedLicenseDetector = forgedLicenseDetector;
    }

    @Override
    public LicenseCheck.Result evaluate() {
        return StreamSupport.stream(this.jiraLicenseManager.getLicenses().spliterator(), false).filter(licenseDetails -> this.forgedLicenseDetector.isLicenseForged(licenseDetails.getLicenseString())).collect(Collectors.collectingAndThen(Collectors.toList(), failedLicenses -> new LicenseCheck.Result((Iterable<? extends LicenseDetails>)failedLicenses, "Detected a product license which is not legitimate.")));
    }
}

