/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.SubscriptionSentEvent;
import com.atlassian.jira.issue.subscription.FilterSubscription;
import com.atlassian.jira.mail.SubscriptionMailQueueItemFactory;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.mail.queue.AbstractMailQueueItem;
import com.atlassian.mail.queue.MailQueue;
import com.atlassian.mail.queue.MailQueueItem;
import io.atlassian.util.concurrent.Lazy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionMailQueueItem
extends AbstractMailQueueItem {
    private static final Logger log = LoggerFactory.getLogger(SubscriptionMailQueueItem.class);
    private static final int RECEIPIENTS_SIZE_INFO_LOG_THRESHOLD = 30;
    public static final String USER_KEY_COLUMN_NAME = "username";
    public static final String ATTACHMENTS_MANAGER_KEY = "attachmentsManager";
    private final FilterSubscription subscription;
    private final Supplier<ApplicationUser> subscriptionCreator;
    private final UserManager userManager;
    private final GroupManager groupManager;
    private final SubscriptionMailQueueItemFactory mailQueueItemFactory;
    private final MailQueue mailQueue;
    private final EventPublisher eventPublisher;

    SubscriptionMailQueueItem(FilterSubscription sub, UserManager userManager, GroupManager groupManager, MailQueue mailQueue, SubscriptionMailQueueItemFactory mailQueueItemFactory, EventPublisher eventPublisher) {
        this.subscription = sub;
        this.userManager = userManager;
        this.groupManager = groupManager;
        this.mailQueue = mailQueue;
        this.mailQueueItemFactory = mailQueueItemFactory;
        this.eventPublisher = eventPublisher;
        this.subscriptionCreator = Lazy.supplier(() -> userManager.getUserByKey(this.subscription.getUserKey()));
    }

    public void send() {
        this.incrementSendCount();
        Collection<ApplicationUser> recipients = this.getSubscriptionRecipients();
        this.logSubscriptionSize(recipients);
        for (ApplicationUser user : recipients) {
            this.mailQueue.addItem((MailQueueItem)this.mailQueueItemFactory.createSelfEvaluatingEmailQueueItem(this.subscription, user));
        }
    }

    @Nonnull
    private Collection<ApplicationUser> getSubscriptionRecipients() {
        String groupName = this.subscription.getGroupName();
        if (StringUtils.isNotEmpty((CharSequence)groupName)) {
            return this.getGroupRecipients(groupName);
        }
        return this.getSingleRecipient();
    }

    @Nonnull
    private Collection<ApplicationUser> getGroupRecipients(@Nonnull String groupName) {
        Group group = this.userManager.getGroup(groupName);
        if (group == null) {
            log.warn("Group '{}' referenced in subscription '{}' of filter '{}' does not exist.", new Object[]{groupName, this.subscription.getId(), this.subscription.getFilterId()});
            return Collections.emptySet();
        }
        return new ArrayList<ApplicationUser>(this.groupManager.getUsersInGroup(groupName, Boolean.valueOf(false)));
    }

    @Nonnull
    private Collection<ApplicationUser> getSingleRecipient() {
        ApplicationUser user = this.getSubscriptionUser();
        if (user == null) {
            log.warn("User '{}' referenced in subscription '{}' of filter '{}' does not exist.", new Object[]{this.subscription.getUserKey(), this.subscription.getId(), this.subscription.getFilterId()});
            return Collections.emptySet();
        }
        return Collections.singleton(user);
    }

    private void logSubscriptionSize(@Nonnull Collection<ApplicationUser> recipients) {
        if (recipients.isEmpty()) {
            return;
        }
        if (recipients.size() > 30) {
            log.info("Sending subscription '{}' of filter '{}' to {} recipients.", new Object[]{this.subscription.getId(), this.subscription.getFilterId(), recipients.size()});
        } else {
            log.debug("Sending subscription '{}' of filter '{}' to {} recipients.", new Object[]{this.subscription.getId(), this.subscription.getFilterId(), recipients.size()});
        }
        this.eventPublisher.publish((Object)new SubscriptionSentEvent(this.subscription.getId(), this.subscription.getFilterId(), recipients.size()));
    }

    @Nullable
    private ApplicationUser getSubscriptionUser() {
        return this.subscriptionCreator.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SubscriptionMailQueueItem)) {
            return false;
        }
        SubscriptionMailQueueItem subscriptionMailQueueItem = (SubscriptionMailQueueItem)((Object)o);
        if (!this.subscription.equals(subscriptionMailQueueItem.subscription)) {
            return false;
        }
        return Objects.equals(this.subscriptionCreator, subscriptionMailQueueItem.subscriptionCreator);
    }

    public int hashCode() {
        int result = this.subscription.hashCode();
        result = 29 * result + (this.subscriptionCreator != null ? this.subscriptionCreator.hashCode() : 0);
        return result;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + " id: '" + this.subscription.getId() + "' owner: '" + this.getSubscriptionUser() + "'";
    }
}

