/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail.util;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.avatar.AvatarManagerImpl;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.avatar.AvatarTranscoder;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.mail.TemplateUser;
import com.atlassian.jira.mail.attachment.ImageAttachmentAltAttributeService;
import com.atlassian.jira.mail.util.MailAttachment;
import com.atlassian.jira.mail.util.MailAttachments;
import com.atlassian.jira.mail.util.MailAttachmentsManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.jwt.ImageAttachmentJwtTokenGenerateParams;
import com.atlassian.jira.security.jwt.ImageAttachmentJwtTokenService;
import com.atlassian.jira.security.jwt.JwtGenerateTokenParametersBuilder;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.web.ServletContextProvider;
import com.google.common.collect.Maps;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailAttachmentsManagerImpl
implements MailAttachmentsManager {
    private static final Logger log = LoggerFactory.getLogger(MailAttachmentsManagerImpl.class);
    private static final String IMAGE_ATTACHMENT_JWT_TOKEN_QUERY_PARAM = "?imgAttachmentToken=";
    private static final Pattern IMG_TAG_WITH_SRC_PATTERN = Pattern.compile("(<img .*?src *= *['\"]?)([^\\s'\">]*)(['\"]?.*?>)");
    private final AvatarService avatarService;
    private final AvatarTranscoder avatarTranscoder;
    private final UserManager userManager;
    private final AvatarManager avatarManager;
    private final ApplicationProperties applicationProperties;
    private final ImageAttachmentJwtTokenService imageAttachmentJwtTokenService;
    private final ImageAttachmentAltAttributeService imageAttachmentAltAttributeService;
    private final String recipientUserName;
    private final Supplier<JiraAuthenticationContext> jiraAuthenticationContextSupplier;
    @ClusterSafe(value="This is a local object used in the creation of a single email")
    private final Map<MailAttachment, String> mailAttachmentToCid = Collections.synchronizedMap(Maps.newHashMap());
    private int securedImagesCount = 0;

    private MailAttachmentsManagerImpl(AvatarService avatarService, AvatarTranscoder avatarTranscoder, UserManager userManager, AvatarManager avatarManager, ApplicationProperties applicationProperties, ImageAttachmentJwtTokenService imageAttachmentJwtTokenService, ImageAttachmentAltAttributeService imageAttachmentAltAttributeService, String recipientUserName) {
        this.avatarService = avatarService;
        this.avatarTranscoder = avatarTranscoder;
        this.userManager = userManager;
        this.avatarManager = avatarManager;
        this.applicationProperties = applicationProperties;
        this.imageAttachmentJwtTokenService = imageAttachmentJwtTokenService;
        this.imageAttachmentAltAttributeService = imageAttachmentAltAttributeService;
        this.recipientUserName = recipientUserName;
        this.jiraAuthenticationContextSupplier = ComponentAccessor::getJiraAuthenticationContext;
    }

    public static MailAttachmentsManagerImpl withoutJwtTokens(AvatarService avatarService, AvatarTranscoder avatarTranscoder, UserManager userManager, AvatarManager avatarManager, ApplicationProperties applicationProperties, ImageAttachmentJwtTokenService imageAttachmentJwtTokenService, ImageAttachmentAltAttributeService imageAttachmentAltAttributeService) {
        return new MailAttachmentsManagerImpl(avatarService, avatarTranscoder, userManager, avatarManager, applicationProperties, imageAttachmentJwtTokenService, imageAttachmentAltAttributeService, null);
    }

    public static MailAttachmentsManagerImpl withJwtTokens(AvatarService avatarService, AvatarTranscoder avatarTranscoder, UserManager userManager, AvatarManager avatarManager, ApplicationProperties applicationProperties, ImageAttachmentJwtTokenService imageAttachmentJwtTokenService, ImageAttachmentAltAttributeService imageAttachmentAltAttributeService, String recipientUserName) {
        return new MailAttachmentsManagerImpl(avatarService, avatarTranscoder, userManager, avatarManager, applicationProperties, imageAttachmentJwtTokenService, imageAttachmentAltAttributeService, recipientUserName);
    }

    @Override
    public String getAvatarUrl(String username) {
        ApplicationUser user = this.userManager.getUserByName(username);
        return this.getAvatarUrl(user);
    }

    @Override
    public String getAvatarUrl(TemplateUser templateUser) {
        return this.getAvatarUrl(templateUser.getName());
    }

    @Override
    public String getAvatarUrl(ApplicationUser user) {
        if (user != null && this.avatarService.isUsingExternalAvatar(this.getLoggedInUser(), user)) {
            return this.avatarService.getAvatarUrlNoPermCheck(user, Avatar.Size.defaultSize()).toString();
        }
        return this.addAttachmentAndReturnCid(this.createUserAvatarAttachment(user));
    }

    @Override
    public String getAvatarUrl(@Nonnull Avatar avatar, @Nonnull Avatar.Size size, String avatarOwnerDescription) {
        Objects.requireNonNull(size);
        return this.addAttachmentAndReturnCid(this.createAvatarAttachment(avatar, size, avatarOwnerDescription));
    }

    public String getIssueTypeIconUrl(IssueType issueType) {
        return issueType.getAvatar() == null ? this.getImageUrl(issueType.getIconUrlHtml()) : this.addAttachmentAndReturnCid(this.createAvatarAttachment(issueType.getAvatar(), Avatar.Size.MEDIUM, "issue type: " + issueType.getName()));
    }

    private ApplicationUser getLoggedInUser() {
        return this.jiraAuthenticationContextSupplier.get().getLoggedInUser();
    }

    private FeatureManager getFeatureManager() {
        return (FeatureManager)ComponentAccessor.getComponent(FeatureManager.class);
    }

    @Override
    public String addAttachmentAndReturnCid(MailAttachment mailAttachment) {
        if (this.mailAttachmentToCid.containsKey(mailAttachment)) {
            return this.buildCidUrl(this.mailAttachmentToCid.get(mailAttachment));
        }
        String cid = this.generateCid(mailAttachment);
        if (this.mailAttachmentToCid.containsValue(cid)) {
            cid = cid + UUID.randomUUID().toString();
        }
        this.mailAttachmentToCid.put(mailAttachment, cid);
        return this.buildCidUrl(cid);
    }

    private String buildCidUrl(String cid) {
        return "cid:" + cid;
    }

    private String generateCid(MailAttachment attachment) {
        return "jira-generated-image-" + attachment.getUniqueName();
    }

    private boolean isInternalResource(String path) {
        ServletContext servletContext = ServletContextProvider.getServletContext();
        try {
            return servletContext.getResource(path) != null;
        }
        catch (IllegalArgumentException | MalformedURLException e) {
            return false;
        }
    }

    private boolean isSecuredThumbnailOrAttachment(String path) {
        return path.startsWith("/secure/attachment/") || path.startsWith("/secure/thumbnail/");
    }

    @Override
    public String getImageUrl(String path) {
        if (this.isInternalResource(path)) {
            return this.addAttachmentAndReturnCid(MailAttachments.newImageAttachment(path, this.avatarTranscoder));
        }
        String absoluteUrl = this.getAbsoluteUrl(path);
        if (this.shouldAddJwtToken() && this.isSecuredThumbnailOrAttachment(path)) {
            return this.addJwtTokenTo(absoluteUrl);
        }
        return absoluteUrl;
    }

    private boolean shouldAddJwtToken() {
        return this.imageAttachmentJwtTokenService.isImageAttachmentJwtTokenEnabled() && this.recipientUserName != null && !this.recipientUserName.isEmpty();
    }

    private String addJwtTokenTo(String absoluteUrl) {
        ImageAttachmentJwtTokenGenerateParams jwtTokenGenerateParams = new JwtGenerateTokenParametersBuilder().setHowManyHoursValid(this.imageAttachmentJwtTokenService.getTokenExpiryHours()).setAbsoluteRequestUrl(absoluteUrl).setUserName(this.recipientUserName).build();
        try {
            String token = this.imageAttachmentJwtTokenService.generateToken(jwtTokenGenerateParams);
            return absoluteUrl + IMAGE_ATTACHMENT_JWT_TOKEN_QUERY_PARAM + token;
        }
        catch (Exception e) {
            log.error("Could not generate JWT token for image attachment. This will not stop from sending an email, but JWT token will not be attached", (Throwable)e);
            return absoluteUrl;
        }
    }

    @Override
    public String processImages(String html) {
        this.resetSecuredImagesCount();
        Matcher imgTagMatcher = IMG_TAG_WITH_SRC_PATTERN.matcher(html);
        StringBuilder result = new StringBuilder(html.length());
        int endPositionOfLastImgTag = 0;
        while (imgTagMatcher.find()) {
            result.append(html, endPositionOfLastImgTag, imgTagMatcher.start());
            String originalImgSrcUrl = imgTagMatcher.group(2);
            String processedImgTag = this.inlineImageOrAddJwtToken(originalImgSrcUrl, imgTagMatcher);
            processedImgTag = this.addAltAttribute(processedImgTag, originalImgSrcUrl);
            result.append(processedImgTag);
            endPositionOfLastImgTag = imgTagMatcher.end();
        }
        result.append(html, endPositionOfLastImgTag, html.length());
        return result.toString();
    }

    private String addAltAttribute(String imgTag, String originalImgSrcUrl) {
        return this.imageAttachmentAltAttributeService.addDefaultAltAttributeIfNeeded(imgTag, originalImgSrcUrl);
    }

    private String inlineImageOrAddJwtToken(String originalSrcUrl, Matcher imgTagMatcher) {
        StringBuilder result = new StringBuilder();
        result.append(imgTagMatcher.group(1));
        String pathWithoutBaseUrl = this.removeBaseUrl(originalSrcUrl);
        this.increaseSecuredImagesCount(pathWithoutBaseUrl);
        String imageInlinedOrWithJwtToken = this.getImageUrl(pathWithoutBaseUrl);
        if (imageInlinedOrWithJwtToken.startsWith("cid:") || imageInlinedOrWithJwtToken.contains(IMAGE_ATTACHMENT_JWT_TOKEN_QUERY_PARAM)) {
            result.append(imageInlinedOrWithJwtToken);
        } else {
            result.append(originalSrcUrl);
        }
        result.append(imgTagMatcher.group(3));
        return result.toString();
    }

    @Override
    public String inlineImages(String html) {
        return this.processImages(html);
    }

    private void increaseSecuredImagesCount(String imageInlinedOrWithJwtToken) {
        if (this.isSecuredThumbnailOrAttachment(imageInlinedOrWithJwtToken)) {
            ++this.securedImagesCount;
        }
    }

    @Override
    public boolean hasSecuredImage() {
        return this.securedImagesCount > 0;
    }

    private void resetSecuredImagesCount() {
        this.securedImagesCount = 0;
    }

    @Override
    public String removeBaseUrl(String url) {
        String baseUrl = this.applicationProperties.getJiraBaseUrl();
        String basePath = this.getBasePath();
        String urlWithRemovedBaseUrl = StringUtils.removeStart((String)url, (String)baseUrl);
        return StringUtils.removeStart((String)urlWithRemovedBaseUrl, (String)basePath);
    }

    private String getBasePath() {
        String baseUrl = this.applicationProperties.getJiraBaseUrl();
        try {
            URI url = new URI(baseUrl);
            return url.getPath();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getExternalImageUrl(String path) {
        try {
            URI uri = new URI(path);
            if (uri.isAbsolute()) {
                return path;
            }
            return this.addAttachmentAndReturnCid(MailAttachments.newUrlImageAttachment(this.getAbsoluteUrl(path)));
        }
        catch (URISyntaxException e) {
            log.trace("Cannot understand URI: " + path, (Throwable)e);
            return path;
        }
    }

    protected String getAbsoluteUrl(String path) {
        String baseUrl = this.applicationProperties.getJiraBaseUrl();
        try {
            URI uri = new URI(path);
            return uri.isAbsolute() ? path : StringUtils.stripEnd((String)baseUrl, (String)"/") + "/" + StringUtils.stripStart((String)path, (String)"/");
        }
        catch (URISyntaxException e) {
            log.trace("Cannot understand URI: " + path, (Throwable)e);
            return path;
        }
    }

    @Override
    public int getAttachmentsCount() {
        return this.mailAttachmentToCid.size();
    }

    @Override
    public Iterable<BodyPart> buildAttachmentsBodyParts() {
        return this.mailAttachmentToCid.entrySet().stream().map(entry -> this.buildMimeBodyPartFromMailAttachment((MailAttachment)entry.getKey(), (String)entry.getValue())).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private BodyPart buildMimeBodyPartFromMailAttachment(MailAttachment mailAttachment, String cid) {
        BodyPart bodyPart = mailAttachment.buildBodyPart();
        if (bodyPart != null) {
            try {
                bodyPart.setHeader("Content-ID", String.format("<%s>", cid));
            }
            catch (MessagingException e) {
                log.warn("Cannot add 'Content-ID' header to mail part", (Throwable)e);
                return null;
            }
        } else {
            log.warn(" can not obtain {} bodyPart ", (Object)cid);
        }
        return bodyPart;
    }

    private MailAttachment createUserAvatarAttachment(ApplicationUser user) {
        String userName = null == user ? "anonymous" : user.getName();
        String avatarOwnerDescription = "user: " + userName;
        Avatar avatar = this.avatarService.getAvatarTagged(user, user);
        Optional<Avatar> jiraAvatar = this.getJiraAvatar(avatar = this.handleBrokenAvatars(avatar, Avatar.Size.MEDIUM));
        if (jiraAvatar.isPresent() && AvatarManagerImpl.isAvatarTranscodeable(jiraAvatar.get())) {
            return MailAttachments.newTranscodedAvatarAttachment(jiraAvatar.get(), avatarOwnerDescription, this.avatarManager);
        }
        return MailAttachments.newAvatarAttachment(avatar, avatarOwnerDescription, this.avatarManager);
    }

    @Nonnull
    private Avatar handleBrokenAvatars(@Nonnull Avatar avatar, @Nonnull Avatar.Size size) {
        if (this.getFeatureManager().isEnabled(JiraFeatureFlagRegistrar.RETURN_DEFAULT_AVATARS_FOR_BROKEN_AVATARS) && !this.avatarManager.hasImage(avatar, size)) {
            Avatar defaultAvatar = this.avatarManager.getDefaultAvatar(avatar.getIconType());
            if (defaultAvatar != null) {
                log.debug("Unable to obtain avatar data for {}/{}/{}. Using default avatar {}", new Object[]{avatar.getId(), size, avatar.getIconType(), defaultAvatar.getId()});
                return defaultAvatar;
            }
            log.debug("Unable to obtain avatar data for {}/{}/{}. Unable to find default avatar.", new Object[]{avatar.getId(), size, avatar.getIconType()});
        }
        return avatar;
    }

    private MailAttachment createAvatarAttachment(@Nonnull Avatar avatar, @Nullable Avatar.Size size, String avatarOwnerDescription) {
        Avatar.Size avatarSize = Optional.ofNullable(size).orElse(Avatar.Size.MEDIUM);
        if (AvatarManagerImpl.isAvatarTranscodeable(avatar = this.handleBrokenAvatars(avatar, avatarSize))) {
            return MailAttachments.newTranscodedAvatarAttachment(avatar, avatarOwnerDescription, this.avatarManager, avatarSize);
        }
        return MailAttachments.newAvatarAttachment(avatar, avatarOwnerDescription, this.avatarManager, avatarSize);
    }

    private Optional<Avatar> getJiraAvatar(Avatar avatar) {
        try {
            Long avatarId = avatar.getId();
            if (avatarId == null) {
                return Optional.empty();
            }
            return Optional.ofNullable(this.avatarManager.getById(avatarId));
        }
        catch (Exception e) {
            log.debug("Could not obtain JIRA avatar.", (Throwable)e);
            return Optional.empty();
        }
    }
}

